/*
 * VisChainerPanel.java
 *2D plot - 2 genomes
 *this is the internal frame , which contains the panel where the projection draw 
 *
 *Asem A. Othamn
 */

import javax.swing.*;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

import java.awt.*;
import java.awt.event.*;

class VisChainerPanel extends JInternalFrame {
	
	
	//Variables for internal farmes 
    static int openFrameCount = 0;//the number of opened frames
    static final int xOffset = 5 ;
    static final int yOffset = 5 ;

	/**
	 * 
	 * @uml.property name="panel"
	 * @uml.associationEnd multiplicity="(1 1)" inverse="parent:DrawPanel"
	 */
	// the components  
	DrawPanel panel;

	/**
	 * 
	 * @uml.property name="parent"
	 * @uml.associationEnd multiplicity="(1 1)" inverse="arrOfInternalFrames:VisChainerMain"
	 */
	public VisChainerMain parent;

	/**
	 * 
	 * @uml.property name="stBar"
	 * @uml.associationEnd multiplicity="(1 1)"
	 */
	JToolBar stBar = new JToolBar();

	/**
	 * 
	 * @uml.property name="stLabel"
	 * @uml.associationEnd multiplicity="(1 1)"
	 */
	JLabel stLabel = new JLabel();

	/**
	 * 
	 * @uml.property name="scrollPane"
	 * @uml.associationEnd multiplicity="(1 1)"
	 */
	public JScrollPane scrollPane;

	/*
	 * the constructor
	 * param> take the main frame "the main for each session as parent"
	 */
	public VisChainerPanel(VisChainerMain p) 
	{
		super("VisChainer #" + (++openFrameCount), 
              true, //resizable
              true, //closable
              true, //maximizable
              true);//iconifiable
              parent =p;
       //...Then set the window size or call pack...
        setSize(600,600);
        //Set the window's location.
        setLocation(xOffset*openFrameCount, yOffset*openFrameCount);
        //Setup the GUI
		init();
		this.addComponentListener( new ComponentListener()
		{
			public void componentResized(ComponentEvent e){
				setPointLocation();
				}
			public void componentShown (ComponentEvent e){setPointLocation();}
			public void componentHidden (ComponentEvent e){}
			public void componentMoved (ComponentEvent e){}
			
			void setPointLocation()
			{ 
				if(panel.zoomFactorX ==1 && panel.zoomFactorY ==1)
				{
				panel.p1.setLocation(panel.p1.x,panel.getSize().height*0.95);
			 	panel.p2.setLocation(panel.p2.x,panel.p2.y);
				panel.p3.setLocation(panel.p3.x,panel.getSize().height*0.95);
				panel.p4.setLocation(panel.getSize().width*0.95,panel.getSize().height*0.95);}
			}
			 
		});
		
		//----------------to add listener for the closing event
		addInternalFrameListener(new InternalFrameAdapter() {
            public void internalFrameClosing(InternalFrameEvent e)  
            {
                JOptionPane.showMessageDialog(parent,"To open the closed Projection , go to Window menu. \n To Delete Specific File go to opened files list and double click on the file.","Help",JOptionPane.INFORMATION_MESSAGE);
                
            }
        });
	}
	/*
	 * to darw the component
	 */
	void init()
	{
		scrollPane = new JScrollPane();
		panel = new DrawPanel(VisChainerPanel.this,scrollPane);  
		stBar.add(stLabel);
		scrollPane.setViewportView(panel);
	    this.getContentPane().add(scrollPane,BorderLayout.CENTER);
	    this.getContentPane().add(stBar,BorderLayout.SOUTH);   
	}
}
