/**
*VisChainerMain.java
*
*this is the session frame..
* -the GUI"the tool bar for buttons, the menu to open the projection,Drawing options and drawig check box to choose which appear in the projection"
* - the objects of opening file
* -the objects of projections -"internal frames"
* -----the important variable which contains the information
* the comparison , opened in this session
*Asem A. Othamn(a.othman@k-space.org)
*/
import javax.swing.*;
import javax.swing.event.*;
import java.awt.event.*;
import java.awt.image.*;
import java.awt.*;
import java.util.*;

import org.biojava.bio.seq.*;


public class VisChainerMain extends JInternalFrame {
	
	//----Variables for internal farmes 
	//the number of opened frames
    static int openFrameCount = 0;
    //the offset in x and y , where the new window will open"openFrameCount * offset"
    static final int xOffset = 10 ;
    //the offset in x and y , where the new window will open"openFrameCount * offset"
    static final int yOffset = 10 ;

	/**
	 * 
	 * @uml.property name="desktop"
	 * @uml.associationEnd multiplicity="(1 1)"
	 */
	//--------
	//----GUI Varaibles
	//the desktop where the internal frames added
	JDesktopPane desktop;

	/**
	 * 
	 * @uml.property name="arrOfInternalFrames"
	 * @uml.associationEnd multiplicity="(0 -1)" inverse="parent:VisChainerPanel"
	 */
	//array list of the internal frame "projection"
	ArrayList arrOfInternalFrames = new ArrayList();

	/**
	 * 
	 * @uml.property name="menuBar"
	 * @uml.associationEnd multiplicity="(1 1)"
	 */
	//it the menu item  array for each projection[not all menu item appear]
	JMenuBar menuBar;

	/**
	 * 
	 * @uml.property name="menu"
	 * @uml.associationEnd multiplicity="(1 1)"
	 */
	JMenu menu;

	/**
	 * 
	 * @uml.property name="menuItems"
	 * @uml.associationEnd multiplicity="(0 -1)"
	 */
	MyMenuItem[] menuItems;

    //the number menuitems"the projection" want to added to the window menu....to open the projections from it
    int numberOfShownProjections =3;

	/**
	 * 
	 * @uml.property name="buttonBar"
	 * @uml.associationEnd multiplicity="(1 1)"
	 */
	//Buttons to open the files
	JToolBar buttonBar;

	/**
	 * 
	 * @uml.property name="openFiles"
	 * @uml.associationEnd multiplicity="(1 1)"
	 */
	JButton openFiles;

	/**
	 * 
	 * @uml.property name="openForwardFiles"
	 * @uml.associationEnd multiplicity="(1 1)"
	 */
	JButton openForwardFiles;

	/**
	 * 
	 * @uml.property name="openReverseFiles"
	 * @uml.associationEnd multiplicity="(1 1)"
	 */
	JButton openReverseFiles;

	/**
	 * 
	 * @uml.property name="openButtonForMultipleGenomes"
	 * @uml.associationEnd multiplicity="(1 1)"
	 */
	JButton openButtonForMultipleGenomes;

	/**
	 * 
	 * @uml.property name="openLinealMode"
	 * @uml.associationEnd multiplicity="(1 1)"
	 */
	JButton openLinealMode;

	/**
	 * 
	 * @uml.property name="openAnnotaionfile"
	 * @uml.associationEnd multiplicity="(1 1)"
	 */
	JButton openAnnotaionfile;

	/**
	 * 
	 * @uml.property name="checkPanel"
	 * @uml.associationEnd multiplicity="(1 1)"
	 */
	//the panels
	JPanel checkPanel;

	/**
	 * used to put in it the sequence and the file list and the console area
	 * @uml.property name="listPanel"
	 * @uml.associationEnd multiplicity="(0 1)"
	 */
	JPanel listPanel;

	/**
	 * 
	 * @uml.property name="checkAndList"
	 * @uml.associationEnd multiplicity="(1 1)"
	 */
	JToolBar checkAndList;

	/**
	 * 
	 * @uml.property name="tabbedPane"
	 * @uml.associationEnd multiplicity="(1 1)"
	 */
	JTabbedPane tabbedPane;

	/**
	 * 
	 * @uml.property name="drawOption"
	 * @uml.associationEnd multiplicity="(1 1)"
	 */
	JPanel drawOption;

	/**
	 * 
	 * @uml.property name="checkAndListPanel"
	 * @uml.associationEnd multiplicity="(1 1)"
	 */
	JPanel checkAndListPanel;

	JPanel filterationPanel;
	/**
	 * 
	 * @uml.property name="seqList"
	 * @uml.associationEnd multiplicity="(1 1)"
	 */
	//the list of opened sequence
	JList seqList;

	/**
	 * 
	 * @uml.property name="arrOfSeqName"
	 * @uml.associationEnd multiplicity="(0 -1)" elementType="java.lang.String"
	 */
	//the array list of strings which will added to the list
	Vector arrOfSeqName = new Vector();

	/**
	 * 
	 * @uml.property name="fragmentDraw"
	 * @uml.associationEnd multiplicity="(1 1)"
	 */
	//the checkBoxes and note that there r setselcted in create frame
	JCheckBox fragmentDraw;

	/**
	 * 
	 * @uml.property name="chainDraw"
	 * @uml.associationEnd multiplicity="(1 1)"
	 */
	JCheckBox chainDraw;

	/**
	 * 
	 * @uml.property name="clusterDraw"
	 * @uml.associationEnd multiplicity="(1 1)"
	 */
	JCheckBox clusterDraw;

	/**
	 * 
	 * @uml.property name="revFragmentDraw"
	 * @uml.associationEnd multiplicity="(1 1)"
	 */
	JCheckBox revFragmentDraw;

	/**
	 * 
	 * @uml.property name="revChainDraw"
	 * @uml.associationEnd multiplicity="(1 1)"
	 */
	JCheckBox revChainDraw;

	/**
	 * 
	 * @uml.property name="revClusterDraw"
	 * @uml.associationEnd multiplicity="(1 1)"
	 */
	JCheckBox revClusterDraw;

	/**
	 * 
	 * @uml.property name="chainFileDraw"
	 * @uml.associationEnd multiplicity="(1 1)"
	 */
	JCheckBox chainFileDraw;

	/**
	 * 
	 * @uml.property name="revChainFileDraw"
	 * @uml.associationEnd multiplicity="(1 1)"
	 */
	JCheckBox revChainFileDraw;

	JCheckBox chainConnectionDraw;
	/**
	 * 
	 * @uml.property name="exportImage"
	 * @uml.associationEnd multiplicity="(1 1)"
	 */
	//the button added under the check boxes to export image ,only for selected projection
	JButton exportImage;

    
    GridLayout gr2 ;//for the check box
    GridLayout gr3 ;// for check box and the list panel
    GridLayout gr4 ;// for draw options
    GridLayout gr5 ;// for the 3 list
    GridLayout gr6 ;// for the 3 list

	/**
	 * 
	 * @uml.property name="fragmentDrawOp"
	 * @uml.associationEnd multiplicity="(1 1)"
	 */
	// for drawing options
	JButton fragmentDrawOp;

	/**
	 * 
	 * @uml.property name="chainDrawOp"
	 * @uml.associationEnd multiplicity="(1 1)"
	 */
	JButton chainDrawOp;

	/**
	 * 
	 * @uml.property name="clusterDrawOp"
	 * @uml.associationEnd multiplicity="(1 1)"
	 */
	JButton clusterDrawOp;

	/**
	 * 
	 * @uml.property name="revFragmentDrawOp"
	 * @uml.associationEnd multiplicity="(1 1)"
	 */
	JButton revFragmentDrawOp;

	/**
	 * 
	 * @uml.property name="revChainDrawOp"
	 * @uml.associationEnd multiplicity="(1 1)"
	 */
	JButton revChainDrawOp;

	/**
	 * 
	 * @uml.property name="revClusterDrawOp"
	 * @uml.associationEnd multiplicity="(1 1)"
	 */
	JButton revClusterDrawOp;

	/**
	 * 
	 * @uml.property name="chainFileDrawOp"
	 * @uml.associationEnd multiplicity="(1 1)"
	 */
	JButton chainFileDrawOp;

	/**
	 * 
	 * @uml.property name="revChainFileDrawOp"
	 * @uml.associationEnd multiplicity="(1 1)"
	 */
	JButton revChainFileDrawOp;
	
	JButton scoreFilteration;
	
	JButton lengthFilteration;

	/**
	 * 
	 * @uml.property name="proFilesArr"
	 * @uml.associationEnd multiplicity="(0 -1)" inverse="parent:ProcessingFiles"
	 */
	//----------------------------
	//---- to read files, and each file opened will have it own object in this array list
	//"take care this array list have intial object ..empty one..."
	ArrayList proFilesArr = new ArrayList();

    //-------------------------------
    
    //--if the new file will overlaid on old ones or in new windows
    boolean allGenomesFlag = false;

	/**
	 * 
	 * @uml.property name="arrForNonOverLaidframes"
	 * @uml.associationEnd multiplicity="(0 -1)" elementType="VisChainerPanel"
	 */
	ArrayList arrForNonOverLaidframes = new ArrayList();

	/**
	 * 
	 * @uml.property name="arrOfMenuItemsOfNonOverLay"
	 * @uml.associationEnd multiplicity="(0 -1)" elementType="MyMenuItem"
	 */
	ArrayList arrOfMenuItemsOfNonOverLay = new ArrayList();

    //------------------------------------
    //---to know if log file opened or not...for the reverse file and multiple genomes
    boolean openNewLog=true;

	/**
	 * 
	 * @uml.property name="parent"
	 * @uml.associationEnd multiplicity="(1 1)"
	 */
	//--it refrence to our parent...the main frame where the seesion opened"VisChainer[# Of Version]"
	VisChainer parent;

    //--it used for make screen capture
    private Robot robot ;

	/**
	 * 
	 * @uml.property name="arrOfSequences"
	 * @uml.associationEnd multiplicity="(0 -1)" elementType="org.biojava.bio.seq.Sequence"
	 */
	//--the important variable which contains the information the comparison , opened in this session
	//  to store the opened sequences
	public ArrayList arrOfSequences = new ArrayList();
	//to store the number of opened sequence, make it integer in spite of call function of the above arraylist ".size()"
	public int numberOfOpenedSeq = 0;
	
	//-----------Fragments Info.
    //these variables are static to all objects in th earray list refrence to th esame
	//the number of genomes
    public  int num = 0;
    //----variables from the static file
	public  int numOfFragments=0;
	public  int maxLengthOfInterval=0;
	public  int minLengthOfInterval=0;

	/**
	 * 
	 * @uml.property name="maxEndInFragments"
	 * @uml.associationEnd multiplicity="(1 1)"
	 */
	//the max fragment length .. get it from the static file , from the length of the sequence if the sequence file opened 
	//or when read the file,which contains fragments. 
	public MyLongArrayList maxEndInFragments = new MyLongArrayList();

	
	public boolean flag_openStcfile = true;//will be false if stc file opened
    public boolean flagForMaxEndArr = true;//will be false if openfragment call"arr of max end has been intialize"

	/**
	 * 
	 * @uml.property name="logFile"
	 * @uml.associationEnd multiplicity="(1 1)"
	 */
	//----variables from the log file
	//the lengthes from the log file..to help me when make the reverse in transformation
	public MyLongArrayList logFile = new MyLongArrayList();

	/**
	 * 
	 * @uml.property name="pathesOfFragmentFilesForMultipleGenomes"
	 * @uml.associationEnd multiplicity="(0 -1)" elementType="java.lang.String"
	 */
	//the pathes of the fragment files ..in case of multiple genomes,and from it get the pathes of chain or ccn or....files 
	public ArrayList pathesOfFragmentFilesForMultipleGenomes;

	/**
	 * 
	 * @uml.property name="linealModeframe"
	 * @uml.associationEnd multiplicity="(0 1)" inverse="parent:VisChainerLinealMode"
	 */
	//-------------------------------------------------------------------------------------------------------------------------------
	//---------the internal frame of the lineal mode projection
	//make it equal null because there is check to see in the begining is it nul or create before
	//if null create one
	//if !null only show it
	VisChainerLinealMode linealModeframe = null;

	/**
	 * 
	 * @uml.property name="annoObjects"
	 * @uml.associationEnd multiplicity="(0 -1)" elementType="[I"
	 */
	// array list for the objects which read the annotation file and store it data
	ArrayList annoObjects = new ArrayList();
	
	//the list to show the opned files and form it also it can delete file form the memory and drawing 
	JList openedFiles;
	Vector openedFilesArr = new Vector();//there is intial object add to this arraylist
	
	//list to show wha was writing in the console
	JList consoleArea;
	Vector consoleArr = new Vector();//there is intial object add to this arraylist

	//Array list to save session
	//there is intial object add to this arraylist contain the title of the vischainer main
	//so if any object in profilesArr deleted , can delete the object here in the same index
	//the log file and stc file are saved in another arraylist
	ArrayList saveSessionArr = new ArrayList();
	
	//to save the path of log file , and stc file 
	//and the index of profiles which will draw in new window "not over laid"
	//there is intial object add to this arraylist contain the title of the vischainer main
	ArrayList saveSessionArr_ = new ArrayList();
	
	

	//to save the path of the last opened directroy, for processing files class
	String pathDir="";
	
	int checkAndListWidth = 170;
	
	
	
	
	public int minLength = Integer.MAX_VALUE;
	public int maxLength = Integer.MIN_VALUE;

	public float minScore = Float.MAX_VALUE;
	public float maxScore = Float.MIN_VALUE;
	//--------------------------------------------------------------------------------------------------------
    public VisChainerMain(String name,VisChainer p) 
    {
        super(name,
        		true, //resizable
                true, //closable
                true, //maximizable
                true);//iconifiable
        ++openFrameCount;
        //from the constractor
        parent =p;
        //only intial one --------
        ProcessingFiles proIntial=new ProcessingFiles(VisChainerMain.this);
        proFilesArr.add(proIntial);
        //where the internal frames added
        desktop = new JDesktopPane(); //a specialized layered pane
        //Make dragging faster:
        desktop.putClientProperty("JDesktopPane.dragMode", "outline");
        
        //Set up the GUI
        init();
        //Setup the menu in the window
        setJMenuBar(createMenuBar());
        
        //--- to set the size and location 
       setSize(new Dimension(parent.getWidth()-xOffset*openFrameCount,parent.getHeight()-yOffset*openFrameCount));
        // Set the window's location.
        setLocation(xOffset*openFrameCount, yOffset*openFrameCount);
        
        addInternalFrameListener(new InternalFrameAdapter() {
            public void internalFrameClosing(InternalFrameEvent e)  
            {
                VisChainerMain.this.dispose();
            }
        });
        
        saveSessionArr.add(this.title);
        saveSessionArr_.add(this.title);
          //---------------------------------------------------------------------------------------------------------------
    }//end of the constractor
 	
 	/**
 	 * SetUp the GUI
 	 * intialize the components
 	 * add the components and manage the layout on the window
 	 * add the action listener to each component ,if it important
 	 */
 	void init()
 	{
 		buttonBar = new JToolBar();
        openFiles = new JButton("open Sequence File");
		openForwardFiles=  new JButton("Open Forward File");
		openReverseFiles =new JButton("open  Reverse File");
        openButtonForMultipleGenomes =new JButton("open All Files of  Multiple Genomes ");
        openLinealMode = new  JButton("Lineal Mode Window");
        openAnnotaionfile = new JButton("open Annotaion File");
        
        checkPanel = new JPanel();
		checkAndList = new JToolBar();
		tabbedPane = new JTabbedPane();
		drawOption= new JPanel();
		checkAndListPanel= new JPanel();
		filterationPanel = new JPanel();
		checkAndListPanel.setPreferredSize(new Dimension((int)checkAndListWidth,(int)checkAndListPanel.HEIGHT));
		filterationPanel.setPreferredSize(new Dimension((int)filterationPanel.WIDTH,(int)filterationPanel.HEIGHT));
		listPanel = new JPanel();
		
		
        fragmentDraw = new JCheckBox("Draw Fragments");
        chainDraw = new JCheckBox("Draw Ccn");
        clusterDraw = new JCheckBox("Draw Clusters");
        chainFileDraw = new JCheckBox("Draw Chains");
        
        revFragmentDraw = new JCheckBox("Draw Rev. Fragments");
        revChainDraw = new JCheckBox("Draw Rev. Ccn");
        revClusterDraw = new JCheckBox("Draw Rev. Clusters");	
		revChainFileDraw = new JCheckBox("Draw Rev. Chains");

		chainConnectionDraw = new JCheckBox("Draw the Chains Connection");
		
		//the intialization for the check boxes selection
		fragmentDraw.setSelected(false);
		chainDraw.setSelected(false);
		clusterDraw.setSelected(false);
		chainFileDraw.setSelected(false);
		
		revFragmentDraw.setSelected(false);
		revChainDraw.setSelected(false);
		revClusterDraw.setSelected(false);
		revChainFileDraw.setSelected(false);
		chainConnectionDraw.setSelected(false);

		exportImage = new JButton("Export Image...JPEG");
		
		fragmentDrawOp = new JButton("Color of Fragments");
	    chainDrawOp = new JButton("Color of Ccn");
	    clusterDrawOp = new JButton("Color of Clusters");
	    chainFileDrawOp = new JButton("Color of Chains");
	        
	    revFragmentDrawOp = new JButton("Color of Rev. Fragments");
	    revChainDrawOp = new JButton("Color of Rev. Ccn");
	    revClusterDrawOp = new JButton("Color of Rev. Clusters");	
	    revChainFileDrawOp = new JButton("Color of Rev. Chains");
			
	    scoreFilteration = new JButton("Score Filteration");
	    
	    lengthFilteration = new JButton("Length Filteration");
	    
	    //the layout for the panel where the check boxes and the export image will added
		gr2 = new GridLayout(10,1);
		checkPanel.setLayout(gr2);
		
		//the layout for the list and the checkboxes,in the first tabe pane 
		gr3 = new GridLayout(2,1);
		checkAndListPanel.setLayout(gr3);
		
		//the layout for the drawing options, in other tab pane
		gr4 = new GridLayout(9,1);
		drawOption.setLayout(gr4);
		
		//the layout for filteration buttons,in the third tab pane 
		gr6 = new GridLayout(2,1);
		filterationPanel.setLayout(gr6);
		
		
//		the layout for the drawing options, in other tab pane
		gr5 = new GridLayout(3,1);
		listPanel.setLayout(gr5);
		
		//---Create the list of selected fragments and put it in a scroll pane
		arrOfSeqName.add("Sequences Files:-");
        seqList = new JList(arrOfSeqName);
        seqList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        seqList.setSelectedIndex(0);
        seqList.addMouseListener( new MouseAdapter()
		{
			public void mouseClicked(MouseEvent e) 
			{
              if (e.getClickCount() == 2) 
              {
               int index = seqList.locationToIndex(e.getPoint());
               SequenceFrame sf= new SequenceFrame((Sequence)arrOfSequences.get(index-1));
               sf.setVisible(true);
              }
            }
        });
        JScrollPane listScrollPane = new JScrollPane(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED,JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
		listScrollPane.getViewport().setView(seqList);
		
		
		openedFilesArr.add("Opened Files:- ");
        openedFiles = new JList(openedFilesArr);
        openedFiles.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        openedFiles.setSelectedIndex(0);
        openedFiles.addMouseListener( new MouseAdapter()
		{
			public void mouseClicked(MouseEvent e) 
			{
              if (e.getClickCount() == 2) 
              {
               int n = JOptionPane.showConfirmDialog(VisChainerMain.this,"Do u want to delete this file?","Question",JOptionPane.YES_NO_OPTION);
               if(n == JOptionPane.YES_OPTION)
               {
            	   int index = openedFiles.getSelectedIndex();
            	   //remove from the arrays 
            	   
            	   
            	   openedFilesArr.set(index,(String)"");
            	   openedFiles.setListData(openedFilesArr.toArray());
              	   openedFiles.repaint();
              	   
              	   //create embty object to put it in the place of deleted one
              	   ProcessingFiles profiles = new ProcessingFiles(VisChainerMain.this);
              	   proFilesArr.set(index,profiles);
              	   saveSessionArr.set(index,"3,Delete");
               }
              }
            }
        });
        JScrollPane listScrollPane1 = new JScrollPane(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED,JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
		listScrollPane1.getViewport().setView(openedFiles);
		
		consoleArr.add("Console:- ");
        consoleArea = new JList(consoleArr);
        consoleArea.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
        consoleArea.setSelectedIndex(0);
        
        JScrollPane listScrollPane2 = new JScrollPane();
		listScrollPane2.getViewport().setView(consoleArea);
		
		//----------- button action listener ----------------
		//-- to open the sequence Files
		openFiles.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) 
            {
            	 ProcessingFiles proFiles = new ProcessingFiles(VisChainerMain.this);
            	 boolean openFlag =proFiles.openSequenceFile();
            	 if(openFlag)
            	 {
            	 //to pass the length of the genomes to the projections and the sequences
            	 passLists(-1,proFiles);
            	 saveSessionArr.add("0,"+proFiles.fc.getSelectedFile().getPath());
            	 }
            }
        });
        //----------------------------------------------------------------------------------------
		 openForwardFiles.addActionListener(new ActionListener() {
	            public void actionPerformed(ActionEvent e) 
	            {
	            	//to set the type of the forward files, which the program can open in combo box ,appear to user to choose
	            	String[] possibilities = {"Fragment", "Chain", "Compact Chain","Cluster"};
	            	String s = (String)JOptionPane.showInputDialog(VisChainerMain.this,"Choose the Type of file : ","Open Forward File:",JOptionPane.QUESTION_MESSAGE,
	            	                    null,
	            	                    possibilities,
	            	                    "Fragment");
	            	if ((s != null) && (s.length() > 0)) {
	            		if(s==possibilities[0])
	            			{
	            			 ProcessingFiles proFiles = new ProcessingFiles(VisChainerMain.this);
	                      	 fragmentDraw.setSelected(proFiles.openFragmentFile(1,proFiles.arrToDrawTheFragments));
	                      	 if( fragmentDraw.isSelected())
	                      	 {
	                      		 boolean duplicateFile = false;
	                      		 String name= "1,1,"+proFiles.fc.getSelectedFile().getPath();
	                      		 for(int i= 0; i< saveSessionArr.size();i++)
	                      		 {
	                      			 if(name.equalsIgnoreCase((String)saveSessionArr.get(i)))
	                      				 {
	                      				 duplicateFile = true;
	                      				 JOptionPane.showMessageDialog(parent,"This file opened before","Warning",JOptionPane.WARNING_MESSAGE);
	                      				 break;
	                      				 }
	                      		 }
	                      		 if(!duplicateFile)
	                      		 {passLists(1,proFiles);
	                      		 toWriteInTheOpenedFilesList("F.Frag. :"+proFiles.fc.getSelectedFile().getName());
	                      		 saveSessionArr.add("1,1,"+proFiles.fc.getSelectedFile().getPath());}
	                      	 }
	            			}
	            		if(s==possibilities[1])
	            			{
	            			ProcessingFiles proFiles = new ProcessingFiles(VisChainerMain.this);
	                    	chainFileDraw.setSelected(proFiles.openFragmentFile(7,proFiles.arrToDrawTheChainesFile));
	                    	 if( chainFileDraw.isSelected())
	                    	 {
	                    		 boolean duplicateFile = false;
	                      		 String name= "1,7,"+proFiles.fc.getSelectedFile().getPath();
	                      		 for(int i= 0; i< saveSessionArr.size();i++)
	                      		 {
	                      			if(name.equalsIgnoreCase((String)saveSessionArr.get(i)))
	                      				 {
	                      				 duplicateFile = true;
	                      				 JOptionPane.showMessageDialog(parent,"This file opened before","Warning",JOptionPane.WARNING_MESSAGE);
	                      				 break;
	                      				 }
	                      		 }
	                      		 if(!duplicateFile){
	                    		 passLists(7,proFiles);
	                    		 toWriteInTheOpenedFilesList("F.Chain. :"+proFiles.fc.getSelectedFile().getName());
	                    		 saveSessionArr.add("1,7,"+proFiles.fc.getSelectedFile().getPath());}
	                    	 }
	                    	 }
	            		if(s==possibilities[2])
	            			{ProcessingFiles proFiles = new ProcessingFiles(VisChainerMain.this);
	                    	chainDraw.setSelected(proFiles.openFragmentFile(2,proFiles.arrToDrawTheChaines));
	                    	 if( chainDraw.isSelected())
	                    	 {
	                    		 boolean duplicateFile = false;
	                      		 String name= "1,2,"+proFiles.fc.getSelectedFile().getPath();
	                      		 for(int i= 0; i< saveSessionArr.size();i++)
	                      		 {
	                      			if(name.equalsIgnoreCase((String)saveSessionArr.get(i)))
	                      				 {
	                      				 duplicateFile = true;
	                      				 JOptionPane.showMessageDialog(parent,"This file opened before","Warning",JOptionPane.WARNING_MESSAGE);
	                      				 break;
	                      				 }
	                      		 }
	                      		 if(!duplicateFile){
	                    		 passLists(2,proFiles);
	                    		 toWriteInTheOpenedFilesList("F.Ccn. :"+proFiles.fc.getSelectedFile().getName());
	                    		 saveSessionArr.add("1,2,"+proFiles.fc.getSelectedFile().getPath());}
	                    	 }
	            			}
	            		if(s==possibilities[3])
	            			{ProcessingFiles proFiles = new ProcessingFiles(VisChainerMain.this);
	                        clusterDraw.setSelected(proFiles.openFragmentFile(3,proFiles.arrToDrawTheClusters));
	                        if( clusterDraw.isSelected())
	                        {
	                        	boolean duplicateFile = false;
	                      		 String name= "1,3,"+proFiles.fc.getSelectedFile().getPath();
	                      		 for(int i= 0; i< saveSessionArr.size();i++)
	                      		 {
	                      			if(name.equalsIgnoreCase((String)saveSessionArr.get(i)))
	                      				 {
	                      				 duplicateFile = true;
	                      				 JOptionPane.showMessageDialog(parent,"This file opened before","Warning",JOptionPane.WARNING_MESSAGE);
	                      				 break;
	                      				 }
	                      		 }
	                      		 if(!duplicateFile){
	                        	passLists(3,proFiles);
	                        	toWriteInTheOpenedFilesList("F.Cst. :"+proFiles.fc.getSelectedFile().getName());
	                        	saveSessionArr.add("1,3,"+proFiles.fc.getSelectedFile().getPath());}
	                        }
	            			}
	            }//end of if((s != null) && (s.length() > 0)) 
	            }
	        });
		 ///----------------------------------------------------------------------------------
		 openReverseFiles.addActionListener(new ActionListener() {
	            public void actionPerformed(ActionEvent e) 
	            {
	            	if(openNewLog){
	            		JOptionPane.showMessageDialog(VisChainerMain.this, "You must open info/log file first","Open Log File....",JOptionPane.INFORMATION_MESSAGE);
	            		ProcessingFiles proFiles = new ProcessingFiles(VisChainerMain.this);
	            		boolean openNewLog1  = proFiles.openLogFileForMultipleGenomes();
	                    if(openNewLog1)
	                     {
	                    	//here add the profiles object which contian the information of the log file
	                    	//proFilesArr.add(proFiles);
	                    	openNewLog = false;
	                     }
	            	}//end of if(openNewLog)
	            
	            	//not else..to make enter it if the log file has been opened..for the first time
	            	if(!openNewLog){
	            	String[] possibilities = {"Rev. Fragment", "Rev. Chain", "Rev. Compact Chain","Rev. Cluster"};
	            	String s = (String)JOptionPane.showInputDialog(VisChainerMain.this,"Choose the Type of file : ","Open Reverse File:",JOptionPane.QUESTION_MESSAGE,
	            	                    null,
	            	                    possibilities,
	            	                    "Fragment");
	            	if ((s != null) && (s.length() > 0)) {
	            		if(s==possibilities[0])
	            			{
	            			ProcessingFiles proFiles = new ProcessingFiles(VisChainerMain.this);
	                        revFragmentDraw.setSelected(proFiles.openFragmentFile(4,proFiles.arrToDrawTheRevFragments));
	                        if( revFragmentDraw.isSelected())
	                        {
	                        	boolean duplicateFile = false;
	                      		 String name= "1,4,"+proFiles.fc.getSelectedFile().getPath();
	                      		 for(int i= 0; i< saveSessionArr.size();i++)
	                      		 {
	                      			if(name.equalsIgnoreCase((String)saveSessionArr.get(i)))
	                      				 {
	                      				 duplicateFile = true;
	                      				 JOptionPane.showMessageDialog(parent,"This file opened before","Warning",JOptionPane.WARNING_MESSAGE);
	                      				 break;
	                      				 }
	                      		 }
	                      		 if(!duplicateFile){
	                        	passLists(4,proFiles);
	                        	toWriteInTheOpenedFilesList("R.Frag. :"+proFiles.fc.getSelectedFile().getName());
	                        	saveSessionArr.add("1,4,"+proFiles.fc.getSelectedFile().getPath());}
	                        }
	            			}
	            		if(s==possibilities[1])
	            			{ProcessingFiles proFiles = new ProcessingFiles(VisChainerMain.this);
	                        revChainFileDraw.setSelected(proFiles.openFragmentFile(8,proFiles.arrToDrawTheRevChainesFile));
	                        if( revChainFileDraw.isSelected())
	                        {
	                        	boolean duplicateFile = false;
	                      		 String name= "1,8,"+proFiles.fc.getSelectedFile().getPath();
	                      		 for(int i= 0; i< saveSessionArr.size();i++)
	                      		 {
	                      			if(name.equalsIgnoreCase((String)saveSessionArr.get(i)))
	                      				 {
	                      				 duplicateFile = true;
	                      				 JOptionPane.showMessageDialog(parent,"This file opened before","Warning",JOptionPane.WARNING_MESSAGE);
	                      				 break;
	                      				 }
	                      		 }
	                      		 if(!duplicateFile){
	                        	passLists(8,proFiles);
	                        	toWriteInTheOpenedFilesList("R.Chain. :"+proFiles.fc.getSelectedFile().getName());
	                        	saveSessionArr.add("1,8,"+proFiles.fc.getSelectedFile().getPath());}
	                        }
	            			}
	            		if(s==possibilities[2])
	            			{ProcessingFiles proFiles = new ProcessingFiles(VisChainerMain.this);
	                        revChainDraw.setSelected(proFiles.openFragmentFile(5,proFiles.arrToDrawTheRevChaines));
	                        if( revChainDraw.isSelected())
	                        {
	                        	boolean duplicateFile = false;
	                      		 String name= "1,5,"+proFiles.fc.getSelectedFile().getPath();
	                      		 for(int i= 0; i< saveSessionArr.size();i++)
	                      		 {
	                      			if(name.equalsIgnoreCase((String)saveSessionArr.get(i)))
	                      				 {
	                      				 duplicateFile = true;
	                      				 JOptionPane.showMessageDialog(parent,"This file opened before","Warning",JOptionPane.WARNING_MESSAGE);
	                      				 break;
	                      				 }
	                      		 }
	                      		 if(!duplicateFile){
	                        	passLists(5,proFiles);
	                        	toWriteInTheOpenedFilesList("R.Ccn. :"+proFiles.fc.getSelectedFile().getName());
	                        	saveSessionArr.add("1,5,"+proFiles.fc.getSelectedFile().getPath());}
	                        }
	            			}
	            		if(s==possibilities[3])
	            			{ProcessingFiles proFiles = new ProcessingFiles(VisChainerMain.this);
	                    	revClusterDraw.setSelected(proFiles.openFragmentFile(6,proFiles.arrToDrawTheRevClusters));
	                    	 if( revClusterDraw.isSelected())
	                    	{
	                    		 boolean duplicateFile = false;
	                      		 String name= "1,6,"+proFiles.fc.getSelectedFile().getPath();
	                      		 for(int i= 0; i< saveSessionArr.size();i++)
	                      		 {
	                      			if(name.equalsIgnoreCase((String)saveSessionArr.get(i)))
	                      				 {
	                      				 duplicateFile = true;
	                      				 JOptionPane.showMessageDialog(parent,"This file opened before","Warning",JOptionPane.WARNING_MESSAGE);
	                      				 break;
	                      				 }
	                      		 }
	                      		 if(!duplicateFile){
	                    		 passLists(6,proFiles);
	                    		 toWriteInTheOpenedFilesList("R.Cst. :"+proFiles.fc.getSelectedFile().getName());
	                    		 saveSessionArr.add("1,6,"+proFiles.fc.getSelectedFile().getPath());}
	                    	}
	            			}
	            }//end of if
	            	}//end of if opennewlog1
	            }
	        });
     
        //--------------- open log file for multiple genomes or open the multiple file according to the type the user choose in the message dialog -------
        openButtonForMultipleGenomes.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) 
            { 
        	if(openNewLog){
        		JOptionPane.showMessageDialog(VisChainerMain.this, "You must open info/log file first","Open Log File....",JOptionPane.INFORMATION_MESSAGE);
        		ProcessingFiles proFiles = new ProcessingFiles(VisChainerMain.this);
        		boolean openNewLog1 = proFiles.openLogFileForMultipleGenomes();
                if(openNewLog1)
                 {
                	//proFilesArr.add(proFiles);
                	openNewLog = false;
                 }
        	}//end ofif(openNewLog) 
        	
        	//not else..to make enter it if the log file has been opened..for the first time
        	if(!openNewLog){
        		//to refer to the corrseponding check box,which will be marked if the file opened
               JCheckBox cb=new JCheckBox();
               JCheckBox cbr= new JCheckBox();
            	String[] possibilities = {"Fragment", "Chain", "Compact Chain","Cluster"/*,"Enter extension"*/};
            	String s = (String)JOptionPane.showInputDialog(VisChainerMain.this,"Choose the Type of file : ","Open Multiple Genomes Files",JOptionPane.QUESTION_MESSAGE,
            	                    null,
            	                    possibilities,
            	                    "Fragment");
            	if ((s != null) && (s.length() > 0)) {
            		if(s==possibilities[0])
            			{s="";
            			cb = fragmentDraw;
            			cbr = revFragmentDraw;
            			}
            		if(s==possibilities[1])
            			{s=".chn";
            			cb = chainFileDraw;
            			cbr= revChainFileDraw;
            			}
            		if(s==possibilities[2])
            			{s=".ccn";
            			cb = chainDraw;
            			cbr = revChainDraw;
            			}
            		if(s==possibilities[3])
            			{s=".cst";
            			cb = clusterDraw;
            			cbr = revClusterDraw;
            			}
            		String input = s;
//            		if(s == possibilities[4])
//            		{
//            			input = JOptionPane.showInputDialog("Enter extension");
//            			
//            			s = input.substring(input.lastIndexOf('.'));
//            			
//            			if(s.equalsIgnoreCase(".chn"))
//            				{
//            				cb = chainFileDraw;
//                			cbr= revChainFileDraw;
//            				
//            				}
//            			if(s.equalsIgnoreCase(".ccn"))
//            				{
//            				cb = chainDraw;
//                			cbr = revChainDraw;
//            				}
//            			if(s.equalsIgnoreCase(".cst"))
//            				{
//            				cb = clusterDraw;
//                			cbr = revClusterDraw;
//            				}
//            			if(s.equalsIgnoreCase(".filtered"))
//            			{
//            				s = input.substring(input.lastIndexOf('.')-4,input.lastIndexOf('.'));
//            				if(s.equalsIgnoreCase(".chn"))
//            				{
//            				cb = chainFileDraw;
//                			cbr= revChainFileDraw;
//            				
//            				}
//            			if(s.equalsIgnoreCase(".ccn"))
//            				{
//            				cb = chainDraw;
//                			cbr = revChainDraw;
//            				}
//            			if(s.equalsIgnoreCase(".cst"))
//            				{
//            				cb = clusterDraw;
//                			cbr = revClusterDraw;
//            				}
//            			}
            			
            			
 //           		}
            		ProcessingFiles proFiles = new ProcessingFiles(VisChainerMain.this);
                    boolean openedFlag = proFiles.openFileOfMultipleGenomesToSetLength(s,input);
                    if(openedFlag)
                    {
                  	  
                  	 cb.setSelected(proFiles.openFragmentsOfMultipleGenomes(s,input));
                  	 cbr.setSelected(cb.isSelected());
                  	 //flag to :1.to make multiple files over laid 
                  	 //2. to set the check box in the frames for the multiple genomes
                  	 allGenomesFlag=true;	
                  	  
                  	  //this is the write place for it , because the add to profiles arr is in passlist function
                  	 if(s.equalsIgnoreCase("")&& cb.isSelected())
                 	  {
                  		boolean duplicateFile = false;
                 		 String name= "2,1,M";
                 		 for(int i= 0; i< saveSessionArr.size();i++)
                 		 {
                 			if(name.equalsIgnoreCase((String)saveSessionArr.get(i)))
                 				 {
                 				 duplicateFile = true;
                 				 JOptionPane.showMessageDialog(parent,"This file opened before","Warning",JOptionPane.WARNING_MESSAGE);
                 				 break;
                 				 }
                 		 }
                 		 if(!duplicateFile){	 
               		  passLists(1,proFiles);
               		  toWriteInTheOpenedFilesList("Fragments files for Multiple genomes");
               		  saveSessionArr.add("2,1,M");}
                 	  }	
               		if(s.equalsIgnoreCase(".chn")&& cb.isSelected())
                  		 {
               			boolean duplicateFile = false;
                 		 String name= "2,7,M";
                 		 for(int i= 0; i< saveSessionArr.size();i++)
                 		 {
                 			if(name.equalsIgnoreCase((String)saveSessionArr.get(i)))
                 				 {
                 				 duplicateFile = true;
                 				 JOptionPane.showMessageDialog(parent,"This file opened before","Warning",JOptionPane.WARNING_MESSAGE);
                 				 break;
                 				 }
                 		 }
                 		 if(!duplicateFile){
               			passLists(7,proFiles);
               			toWriteInTheOpenedFilesList("Chain files for Multiple genomes");
               			saveSessionArr.add("2,7,M");}
                  		 }
               		if(s.equalsIgnoreCase(".ccn")&& cb.isSelected())
                  		 {
               			boolean duplicateFile = false;
                 		 String name= "2,2,M";
                 		 for(int i= 0; i< saveSessionArr.size();i++)
                 		 {
                 			if(name.equalsIgnoreCase((String)saveSessionArr.get(i)))
                 				 {
                 				 duplicateFile = true;
                 				 JOptionPane.showMessageDialog(parent,"This file opened before","Warning",JOptionPane.WARNING_MESSAGE);
                 				 break;
                 				 }
                 		 }
                 		 if(!duplicateFile){
               			passLists(2,proFiles);
               			toWriteInTheOpenedFilesList("Compact Chain files for Multiple genomes");
               			saveSessionArr.add("2,2,M");}
                  		 }
               		if(s.equalsIgnoreCase(".cst")&& cb.isSelected())
                  		 {
               			boolean duplicateFile = false;
                 		 String name= "2,3,M";
                 		 for(int i= 0; i< saveSessionArr.size();i++)
                 		 {
                 			if(name.equalsIgnoreCase((String)saveSessionArr.get(i)))
                 				 {
                 				 duplicateFile = true;
                 				 JOptionPane.showMessageDialog(parent,"This file opened before","Warning",JOptionPane.WARNING_MESSAGE);
                 				 break;
                 				 }
                 		 }
                 		 if(!duplicateFile){
               			passLists(3,proFiles);
               			toWriteInTheOpenedFilesList("Cluster files for Multiple genomes");
               			saveSessionArr.add("2,3,M");}
                  		 }
                  	 
                  	 allGenomesFlag=false;
                  	  //proFilesArr.add(proFiles);
            	}//end of   if(openedFlag)
              }//end of if ((s != null) && (s.length() > 0)
            }//end of if opennewlog1
            }
        });
        //-----------------------------TO OPEN THE LINEAL MODE--------------------------------------
        openLinealMode.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) 
            { 
            	if(linealModeframe == null)
            	//to make declaration of the lineal mode 
                linealModeframe =  new VisChainerLinealMode(VisChainerMain.this);
            	 //make listener for the frame , if it activiated "selected" ...change the state and the color of the check boxes
            	linealModeframe.addInternalFrameListener( new InternalFrameAdapter() 
                {
                	public void internalFrameActivated(InternalFrameEvent e) 
                	{
                		VisChainerLinealMode f = (VisChainerLinealMode)e.getSource();
                		//to set the check BOX
                		fragmentDraw.setSelected(f.panel.drawFrag);
                		chainDraw.setSelected(f.panel.drawChain);
                		clusterDraw.setSelected(f.panel.drawCluster);
                		chainFileDraw.setSelected(f.panel.drawChainFile);
                		revFragmentDraw.setSelected(f.panel.drawRevFrag);
                		revChainDraw.setSelected(f.panel.drawRevChain);
                		revChainFileDraw.setSelected(f.panel.drawRevChainFile);
                		revClusterDraw.setSelected(f.panel.drawRevCluster);
                		
                		fragmentDraw.setForeground(f.panel.drawFragColor);
                		chainDraw.setForeground(f.panel.drawChainColor);
                		clusterDraw.setForeground(f.panel.drawClusterColor);
                		chainFileDraw.setForeground(f.panel.drawChainFileColor);
                		
                		revFragmentDraw.setForeground(f.panel.drawRevFragColor);
                		revChainDraw.setForeground(f.panel.drawRevChainColor);
                		revChainFileDraw.setForeground(f.panel.drawRevChainFileColor);
                		revClusterDraw.setForeground(f.panel.drawRevClusterColor);
                		
                	}
                	});
            	//----to get the maximum length for the genomes
            	int maximum = (int)maxEndInFragments.get(0);   // start with the first value
                for (int i=1; i<maxEndInFragments.size(); i++) {
                    if ((int)maxEndInFragments.get(i) > maximum) {
                        maximum = (int)maxEndInFragments.get(i);   // new maximum
                    }
                }              
                linealModeframe.panel.setPreferredSize(new Dimension(linealModeframe.getWidth(),num*linealModeframe.panel.heightInterval));
                linealModeframe.panel.theMaxLength = maximum;
                linealModeframe.panel.setSize(linealModeframe.panel.getPreferredSize());
                linealModeframe.panel.proFilesArr = proFilesArr;
            	
                linealModeframe.setVisible(true); //necessary as of 1.3
                desktop.add(linealModeframe);
                try {
                	linealModeframe.setSelected(true);
                } catch (java.beans.PropertyVetoException ex) {}
                linealModeframe.moveToFront();
            }
        });
        
        /**
         * //-------------------------------- to open the Annotation file -----------------------
         * */
        
        openAnnotaionfile.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) 
            {
            	AnnotationForGenome annotationreader = new AnnotationForGenome(VisChainerMain.this,annoObjects.size());
            	annotationreader.readAnnotation();
            	
            	GridLayout gr = (GridLayout)drawOption.getLayout();
            	drawOption.setLayout(new GridLayout(gr.getRows()+annotationreader.keysName.size(),1));
            	for(int h = 0; h < annotationreader.keysName.size() ; h++)
            	{
            		JButton bu = new JButton(annotationreader.keysName.get(h)+" for genome "+(annoObjects.size()+1));
            		bu.setForeground((Color)annotationreader.ColorForKeys.get(h));
            		bu.addActionListener(new ActionListener() {
                        public void actionPerformed(ActionEvent e) 
                        {
                        	JButton b = (JButton)e.getSource();
                        	Color co = JColorChooser.showDialog(VisChainerMain.this, "Choose Color....", b.getForeground() );
                        	b.setForeground(co);
                        	//annotationreader.ColorForKeys.set(h, co);
                        }});
            	}
            	
            	//--------
            	annoObjects.add(annotationreader);
            }
            });
        
        
        
        /**
         * 
         * 
         *  //--------------------- check box item listener ----------------------
         *    //Note that: for non overlaid projecation, it draw only one file..so there is no mean to make it take effect from the check box
         */
        fragmentDraw.addItemListener(new ItemListener() {
           public void itemStateChanged(ItemEvent e) {
             
        	   //if the lineal mode declared and selected
        	   if(linealModeframe != null && linealModeframe.isSelected())
        	   {		   
        			   if (e.getStateChange() == ItemEvent.DESELECTED)
        				   linealModeframe.panel.drawFrag= false;
                       	else
                       		linealModeframe.panel.drawFrag= true;
        			   linealModeframe.panel.repaint();		   
        			   return;
        	   }//end of if(linealModeframe != null && linealModeframe.isSelected())
        	   
        	  //for the internal frame"contians the projection",the one selected
             for(int i=0;i<arrOfInternalFrames.size();i++)
             {
             	VisChainerPanel f = (VisChainerPanel)arrOfInternalFrames.get(i);
             	if(f.isSelected())
             	{
             		if (e.getStateChange() == ItemEvent.DESELECTED)
                	f.panel.drawFrag= false;
                	else
                	f.panel.drawFrag= true;
                	f.panel.repaint();
                	 return;
                }
        	}//end for loop
           }
        });
        
        chainFileDraw.addItemListener(new ItemListener() {
            public void itemStateChanged(ItemEvent e) {
            	 //if the lineal mode declared and selected
         	   if(linealModeframe != null && linealModeframe.isSelected())
         	   { 
         			   if (e.getStateChange() == ItemEvent.DESELECTED)
         				   linealModeframe.panel.drawChainFile= false;
                        	else
                        		linealModeframe.panel.drawChainFile= true;
         			   linealModeframe.panel.repaint();
         			  return;
         	   }//end of if(linealModeframe != null && linealModeframe.isSelected())
         	   
         	  //for the internal frame"contians the projection",the one selected
              for(int i=0;i<arrOfInternalFrames.size();i++)
              {
              	VisChainerPanel f = (VisChainerPanel)arrOfInternalFrames.get(i);
              	if(f.isSelected())
              	{
              		if (e.getStateChange() == ItemEvent.DESELECTED)
                 	f.panel.drawChainFile= false;
                 	else
                 	f.panel.drawChainFile= true;
                 	f.panel.repaint();
                 	return;
                 }
         	}//end for loop
            }
         });
        
        chainDraw.addItemListener(new ItemListener() {
           public void itemStateChanged(ItemEvent e) {
        	   //if the lineal mode declared and selected
         	   if(linealModeframe != null && linealModeframe.isSelected())
         	   {
         			   if (e.getStateChange() == ItemEvent.DESELECTED)
         				   linealModeframe.panel.drawChain= false;
                        	else
                        		linealModeframe.panel.drawChain= true;
         			   linealModeframe.panel.repaint();
          			  return;
         	   }//end of if(linealModeframe != null && linealModeframe.isSelected())
        	   for(int i=0;i<arrOfInternalFrames.size();i++)
             {
             	VisChainerPanel f = (VisChainerPanel)arrOfInternalFrames.get(i);
             	if(f.isSelected())
             	{
             	if (e.getStateChange() == ItemEvent.DESELECTED)
                	f.panel.drawChain= false;
                else
                	f.panel.drawChain= true;
            	f.panel.repaint();
   			  return;
            	}
        	}//end for loop
           }
        });
        
        clusterDraw.addItemListener(new ItemListener() {
           public void itemStateChanged(ItemEvent e) {
        	   //if the lineal mode declared and selected
         	   if(linealModeframe != null && linealModeframe.isSelected())
         	   {	   
         			   if (e.getStateChange() == ItemEvent.DESELECTED)
         				   linealModeframe.panel.drawCluster= false;
                        	else
                        		linealModeframe.panel.drawCluster= true;
         			   linealModeframe.panel.repaint();   
          			  return;
         	   }//end of if(linealModeframe != null && linealModeframe.isSelected())
             for(int i=0;i<arrOfInternalFrames.size();i++)
             {
             	VisChainerPanel f = (VisChainerPanel)arrOfInternalFrames.get(i);
             	if(f.isSelected())
             	{
             if (e.getStateChange() == ItemEvent.DESELECTED)
                f.panel.drawCluster= false;
                else
                f.panel.drawCluster= true;
            	f.panel.repaint();
   			  return;
             	}
             }//end of for loop
          }
        });
       
        revFragmentDraw.addItemListener(new ItemListener() {
           public void itemStateChanged(ItemEvent e) {
        	   //if the lineal mode declared and selected
         	   if(linealModeframe != null && linealModeframe.isSelected())
         	   {
         			   if (e.getStateChange() == ItemEvent.DESELECTED)
         				   linealModeframe.panel.drawRevFrag= false;
                        	else
                        		linealModeframe.panel.drawRevFrag= true;
         			   linealModeframe.panel.repaint();
          			  return;
         	   }//end of if(linealModeframe != null && linealModeframe.isSelected())
        	   for(int i=0;i<arrOfInternalFrames.size();i++)
             {
             	VisChainerPanel f = (VisChainerPanel)arrOfInternalFrames.get(i);
             	if(f.isSelected())
             	{
             if (e.getStateChange() == ItemEvent.DESELECTED)
                f.panel.drawRevFrag= false;
                else
                f.panel.drawRevFrag= true;
                f.panel.repaint();
   			  return;
             	}
             }//end of for loop
            }
        });
        
        revChainFileDraw.addItemListener(new ItemListener() {
            public void itemStateChanged(ItemEvent e) {
            	 //if the lineal mode declared and selected
          	   if(linealModeframe != null && linealModeframe.isSelected())
          	   {
          			   if (e.getStateChange() == ItemEvent.DESELECTED)
          				   linealModeframe.panel.drawRevChainFile= false;
                         	else
                         		linealModeframe.panel.drawRevChainFile= true;
          			   linealModeframe.panel.repaint(); 
          			  return;
          	   }//end of if(linealModeframe != null && linealModeframe.isSelected())
            	for(int i=0;i<arrOfInternalFrames.size();i++)
              {
              	VisChainerPanel f = (VisChainerPanel)arrOfInternalFrames.get(i);
              	if(f.isSelected())
              	{
              if (e.getStateChange() == ItemEvent.DESELECTED)
                 f.panel.drawRevChainFile= false;
                 else
                 f.panel.drawRevChainFile= true;
                 f.panel.repaint();
    			  return;
              	}
              }//end of for loop
             }
         });
        
        revChainDraw.addItemListener(new ItemListener() {
           public void itemStateChanged(ItemEvent e) {
        	   //if the lineal mode declared and selected
         	   if(linealModeframe != null && linealModeframe.isSelected())
         	   {
         			   if (e.getStateChange() == ItemEvent.DESELECTED)
         				   linealModeframe.panel.drawRevChain= false;
                        	else
                        		linealModeframe.panel.drawRevChain= true;
         			   linealModeframe.panel.repaint();
          			  return;
         	   }//end of if(linealModeframe != null && linealModeframe.isSelected())
             for(int i=0;i<arrOfInternalFrames.size();i++)
             {
             	VisChainerPanel f = (VisChainerPanel)arrOfInternalFrames.get(i);
             	if(f.isSelected())
             	{
             if (e.getStateChange() == ItemEvent.DESELECTED)
                f.panel.drawRevChain= false;
                else
                f.panel.drawRevChain= true;      
            	f.panel.repaint();
   			  return;
   			  }
             	}//end of for loop
            }
        });
        
        revClusterDraw.addItemListener(new ItemListener() {
           public void itemStateChanged(ItemEvent e) {
        	   //if the lineal mode declared and selected
         	   if(linealModeframe != null && linealModeframe.isSelected())
         	   {
         			   if (e.getStateChange() == ItemEvent.DESELECTED)
         				   linealModeframe.panel.drawRevCluster= false;
                        	else
                        		linealModeframe.panel.drawRevCluster= true;
         			   linealModeframe.panel.repaint();
          			  return;
         	   }//end of if(linealModeframe != null && linealModeframe.isSelected())
             for(int i=0;i<arrOfInternalFrames.size();i++)
             {
             	VisChainerPanel f = (VisChainerPanel)arrOfInternalFrames.get(i);
             	if(f.isSelected())
             	{
             if (e.getStateChange() == ItemEvent.DESELECTED)
                f.panel.drawRevCluster= false;
                else
                f.panel.drawRevCluster= true;
            	f.panel.repaint();
   			  return;
   			  }
             }//end of for loop
            }
        });
        
        chainConnectionDraw.addItemListener(new ItemListener() {
            public void itemStateChanged(ItemEvent e) {
         	   //if the lineal mode declared and selected
          	  /* if(linealModeframe != null && linealModeframe.isSelected())
          	   {
          			   if (e.getStateChange() == ItemEvent.DESELECTED)
          				   linealModeframe.panel.drawRevCluster= false;
                         	else
                         		linealModeframe.panel.drawRevCluster= true;
          			   linealModeframe.panel.repaint();
           			  return;
          	   }//end of if(linealModeframe != null && linealModeframe.isSelected())*/
              for(int i=0;i<arrOfInternalFrames.size();i++)
              {
              	VisChainerPanel f = (VisChainerPanel)arrOfInternalFrames.get(i);
              	if(f.isSelected())
              	{
              if (e.getStateChange() == ItemEvent.DESELECTED)
                 f.panel.drawChainConnection= false;
                 else
                 f.panel.drawChainConnection= true;
             	f.panel.repaint();
    			  return;
    			  }
              }//end of for loop
              
              //to show the connection between chaines, in the non overlaid frames , if there is one selected and draw chain in it
              for(int i=0;i<arrForNonOverLaidframes.size();i++)
              {
              	VisChainerPanel f = (VisChainerPanel)arrForNonOverLaidframes.get(i);
              	if(f.isSelected())
              	{
              if (e.getStateChange() == ItemEvent.DESELECTED)
                 f.panel.drawChainConnection= false;
                 else
                 f.panel.drawChainConnection= true;
             	f.panel.repaint();
    			  return;
    			  }
              }//end of for loop
              
             }
         });
        
        exportImage.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) 
            {
            	 //if the lineal mode declared and selected
          	   if(linealModeframe != null && linealModeframe.isSelected())
          	   {
          		   //not same function because there is now rowheader in this frame
          			//------- to get the screen capture image 
           		try {
           			 robot = new Robot();
         		    } catch (AWTException awte) {
         		      awte.printStackTrace();} 
           	  Rectangle screen = new Rectangle();
           	  screen.setRect(linealModeframe.panel.scrollPane.getCorner(JScrollPane.UPPER_LEFT_CORNER).getX(),linealModeframe.panel.scrollPane.getCorner(JScrollPane.UPPER_LEFT_CORNER).getY()
           			  ,linealModeframe.panel.scrollPane.getColumnHeader().getWidth()+linealModeframe.panel.scrollPane.getCorner(JScrollPane.UPPER_LEFT_CORNER).getWidth()
           			  ,linealModeframe.panel.scrollPane.getViewport().getViewRect().getHeight()+linealModeframe.panel.scrollPane.getCorner(JScrollPane.UPPER_LEFT_CORNER).getHeight());
         	      Point loc = screen.getLocation();
         	      SwingUtilities.convertPointToScreen(loc,linealModeframe.getContentPane());
         	      screen.setLocation(loc);
         	      BufferedImage bb=robot.createScreenCapture(screen);
         	  //------------------------------------------------------------------------------------------------------------    
           		JFileChooser fc = new JFileChooser();
           		fc.setDialogTitle("Choose the Directory....... ");
               	fc.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
               	int returnVal =  fc.showSaveDialog(VisChainerMain.this);
                   String s="";
                   if (returnVal == JFileChooser.APPROVE_OPTION) 
            	   {  
                    try 
                        { 
                   		  s = (String)JOptionPane.showInputDialog(VisChainerMain.this,"Write The Name of file : ","Save As........ ",JOptionPane.QUESTION_MESSAGE,
            	                    null,
            	                    null,
            	                    null); 
                   		  if(s != null)
                   		  {
                   			linealModeframe.panel.exportImage(bb,fc.getSelectedFile().getCanonicalFile()+parent.fileDash+s+".jpg");
                    			  return;
                   		  }
                        }catch(Exception ex){}
            	   }
           			  
          	   }//end of if(linealModeframe != null && linealModeframe.isSelected())
          	   
            	for(int i=0;i<arrOfInternalFrames.size();i++)
                {
                	VisChainerPanel f = (VisChainerPanel)arrOfInternalFrames.get(i);
                	if(f.isSelected())
                	{		
                		exportImage(f);
                	}
               }
            	for(int i=0;i<arrForNonOverLaidframes.size();i++)
                {
                	VisChainerPanel f = (VisChainerPanel)arrForNonOverLaidframes.get(i);
                	if(f.isSelected())
                	{
                		exportImage(f);
                	}
               }
               
            }});
        
        //---the action listener for the drawing options buttons------------------
        fragmentDrawOp.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) 
            {
            	 if(linealModeframe != null && linealModeframe.isSelected())
            	   {
            		 linealModeframe.panel.drawFragColor = JColorChooser.showDialog(VisChainerMain.this, "Choose Color....", linealModeframe.panel.drawFragColor );
            		 fragmentDraw.setForeground(linealModeframe.panel.drawFragColor);
            		 linealModeframe.panel.repaint();
             		  return;
            	   }
            	for(int i=0;i<arrOfInternalFrames.size();i++)
                {
                	VisChainerPanel f = (VisChainerPanel)arrOfInternalFrames.get(i);
                	if(f.isSelected())
                	{
                              f.panel.drawFragColor = JColorChooser.showDialog(VisChainerMain.this, "Choose Color....", f.panel.drawFragColor );
                              fragmentDraw.setForeground(f.panel.drawFragColor);
                      		  f.panel.repaint();
                      		  return;
                              
                 	  }
                }
            	for(int i=0;i<arrForNonOverLaidframes.size();i++)
                {
                	VisChainerPanel f = (VisChainerPanel)arrForNonOverLaidframes.get(i);
                	if(f.isSelected())
                	{
                		 f.panel.drawFragColor = JColorChooser.showDialog(VisChainerMain.this, "Choose Color....", f.panel.drawFragColor );
                		 fragmentDraw.setForeground(f.panel.drawFragColor);
                		 f.panel.repaint();
                 		return;
                	}
               }
            }});
        chainFileDrawOp.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) 
            {
            	 if(linealModeframe != null && linealModeframe.isSelected())
          	   {
            	 linealModeframe.panel.drawChainFileColor = JColorChooser.showDialog(VisChainerMain.this, "Choose Color....", linealModeframe.panel.drawChainFileColor );		 
              	chainFileDraw.setForeground(linealModeframe.panel.drawChainFileColor);
          		linealModeframe.panel.repaint();
           		  return;
          	   }
            	for(int i=0;i<arrOfInternalFrames.size();i++)
                {
                	VisChainerPanel f = (VisChainerPanel)arrOfInternalFrames.get(i);
                	if(f.isSelected())
                	{
                		 f.panel.drawChainFileColor = JColorChooser.showDialog(VisChainerMain.this, "Choose Color....", f.panel.drawChainFileColor );		 
                 		chainFileDraw.setForeground(f.panel.drawChainFileColor);
                 		f.panel.repaint();
                 		
                 	  }
                }
               
            	for(int i=0;i<arrForNonOverLaidframes.size();i++)
                {
                	VisChainerPanel f = (VisChainerPanel)arrForNonOverLaidframes.get(i);
                	if(f.isSelected())
                	{
                		 f.panel.drawChainFileColor = JColorChooser.showDialog(VisChainerMain.this, "Choose Color....", f.panel.drawChainFileColor );
                 		chainFileDraw.setForeground(f.panel.drawChainFileColor);
                 		f.panel.repaint();
                 		
                	}
               }
            }});
        chainDrawOp.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) 
            {
            	 if(linealModeframe != null && linealModeframe.isSelected())
          	   {
            	 linealModeframe.panel.drawChainColor = JColorChooser.showDialog(VisChainerMain.this, "Choose Color....", linealModeframe.panel.drawChainColor );
                 chainDraw.setForeground(linealModeframe.panel.drawChainColor);
          		 linealModeframe.panel.repaint();
           		  return;
          	   }
            	for(int i=0;i<arrOfInternalFrames.size();i++)
                {
                	VisChainerPanel f = (VisChainerPanel)arrOfInternalFrames.get(i);
                	if(f.isSelected())
                	{
                		f.panel.drawChainColor = JColorChooser.showDialog(VisChainerMain.this, "Choose Color....", f.panel.drawChainColor );
                 		chainDraw.setForeground(f.panel.drawChainColor);
                 		f.panel.repaint();
                 		
                 	  }
                }
               
            	for(int i=0;i<arrForNonOverLaidframes.size();i++)
                {
                	VisChainerPanel f = (VisChainerPanel)arrForNonOverLaidframes.get(i);
                	if(f.isSelected())
                	{
                		 f.panel.drawChainColor = JColorChooser.showDialog(VisChainerMain.this, "Choose Color....", f.panel.drawChainColor );		 
                 		chainDraw.setForeground(f.panel.drawChainColor);	
                 		f.panel.repaint();
                	}
               }
            }});
        clusterDrawOp.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) 
            {
            	 if(linealModeframe != null && linealModeframe.isSelected())
          	   {
            	 linealModeframe.panel.drawClusterColor = JColorChooser.showDialog(VisChainerMain.this, "Choose Color....", linealModeframe.panel.drawClusterColor );
              	 clusterDraw.setForeground(linealModeframe.panel.drawClusterColor);
          		 linealModeframe.panel.repaint();
           		  return;
          	   }
            	for(int i=0;i<arrOfInternalFrames.size();i++)
                {
                	VisChainerPanel f = (VisChainerPanel)arrOfInternalFrames.get(i);
                	if(f.isSelected())
                	{
                		f.panel.drawClusterColor = JColorChooser.showDialog(VisChainerMain.this, "Choose Color....", f.panel.drawClusterColor );
                 		clusterDraw.setForeground(f.panel.drawClusterColor);
                 		f.panel.repaint();
                 	  }
                }
               
            	for(int i=0;i<arrForNonOverLaidframes.size();i++)
                {
                	VisChainerPanel f = (VisChainerPanel)arrForNonOverLaidframes.get(i);
                	if(f.isSelected())
                	{
                		 f.panel.drawClusterColor = JColorChooser.showDialog(VisChainerMain.this, "Choose Color....", f.panel.drawClusterColor ); 		
                 		clusterDraw.setForeground(f.panel.drawClusterColor);
                 		f.panel.repaint();
                	}
               }
            }});
        revFragmentDrawOp.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) 
            {
            	 if(linealModeframe != null && linealModeframe.isSelected())
          	   {
            	linealModeframe.panel.drawRevFragColor = JColorChooser.showDialog(VisChainerMain.this, "Choose Color....",linealModeframe.panel.drawRevFragColor );   		
                 revFragmentDraw.setForeground(linealModeframe.panel.drawRevFragColor);
          		 linealModeframe.panel.repaint();
           		  return;
          	   }
            	for(int i=0;i<arrOfInternalFrames.size();i++)
                {
                	VisChainerPanel f = (VisChainerPanel)arrOfInternalFrames.get(i);
                	if(f.isSelected())
                	{
                		 f.panel.drawRevFragColor = JColorChooser.showDialog(VisChainerMain.this, "Choose Color....", f.panel.drawRevFragColor );   		
                 		revFragmentDraw.setForeground(f.panel.drawRevFragColor);
                 		f.panel.repaint();
                 		
                 	  }
                }
               
            	for(int i=0;i<arrForNonOverLaidframes.size();i++)
                {
                	VisChainerPanel f = (VisChainerPanel)arrForNonOverLaidframes.get(i);
                	if(f.isSelected())
                	{
                		 f.panel.drawRevFragColor = JColorChooser.showDialog(VisChainerMain.this, "Choose Color....", f.panel.drawRevFragColor );        		
                 		revFragmentDraw.setForeground(f.panel.drawRevFragColor);
                 		f.panel.repaint();
                	}
               }
            }});
        revChainFileDrawOp.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) 
            {
            	 if(linealModeframe != null && linealModeframe.isSelected())
          	   {
            	linealModeframe.panel.drawRevChainFileColor = JColorChooser.showDialog(VisChainerMain.this, "Choose Color....", linealModeframe.panel.drawRevChainFileColor );	
             	revChainFileDraw.setForeground(linealModeframe.panel.drawRevChainFileColor);
          		 linealModeframe.panel.repaint();
           		  return;
          	   }
            	for(int i=0;i<arrOfInternalFrames.size();i++)
                {
                	VisChainerPanel f = (VisChainerPanel)arrOfInternalFrames.get(i);
                	if(f.isSelected())
                	{
                		 f.panel.drawRevChainFileColor = JColorChooser.showDialog(VisChainerMain.this, "Choose Color....", f.panel.drawRevChainFileColor );	
                		revChainFileDraw.setForeground(f.panel.drawRevChainFileColor);
                 		f.panel.repaint();
                 		
                 	  }
                }
               
            	for(int i=0;i<arrForNonOverLaidframes.size();i++)
                {
                	VisChainerPanel f = (VisChainerPanel)arrForNonOverLaidframes.get(i);
                	if(f.isSelected())
                	{
                		 f.panel.drawRevChainFileColor = JColorChooser.showDialog(VisChainerMain.this, "Choose Color....", f.panel.drawRevChainFileColor );          		
                 		revChainFileDraw.setForeground(f.panel.drawRevChainFileColor);
                 		f.panel.repaint();
                 		
                	}
               }
            }});
        revChainDrawOp.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) 
            {
            	 if(linealModeframe != null && linealModeframe.isSelected())
          	   {
            	 linealModeframe.panel.drawRevChainColor = JColorChooser.showDialog(VisChainerMain.this, "Choose Color....", linealModeframe.panel.drawRevChainColor );
              	revChainDraw.setForeground(linealModeframe.panel.drawRevChainColor);
          		 linealModeframe.panel.repaint();
           		  return;
          	   }
            	for(int i=0;i<arrOfInternalFrames.size();i++)
                {
                	VisChainerPanel f = (VisChainerPanel)arrOfInternalFrames.get(i);
                	if(f.isSelected())
                	{
                		 f.panel.drawRevChainColor = JColorChooser.showDialog(VisChainerMain.this, "Choose Color....", f.panel.drawRevChainColor );
                 		revChainDraw.setForeground(f.panel.drawRevChainColor);
                 		f.panel.repaint();
                 		
                		 
                 	  }
                }
               
            	for(int i=0;i<arrForNonOverLaidframes.size();i++)
                {
                	VisChainerPanel f = (VisChainerPanel)arrForNonOverLaidframes.get(i);
                	if(f.isSelected())
                	{
                		 f.panel.drawRevChainColor = JColorChooser.showDialog(VisChainerMain.this, "Choose Color....", f.panel.drawRevChainColor );
                 		revChainDraw.setForeground(f.panel.drawRevChainColor);
                 		f.panel.repaint();
                	}
               }
            }});
        revClusterDrawOp.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) 
            {
            	 if(linealModeframe != null && linealModeframe.isSelected())
          	   {
          		 linealModeframe.panel.drawRevClusterColor = JColorChooser.showDialog(VisChainerMain.this, "Choose Color....", linealModeframe.panel.drawRevClusterColor );
          		 revClusterDraw.setForeground(linealModeframe.panel.drawRevClusterColor);
          		 linealModeframe.panel.repaint();
           		  return;
          	   }
            	for(int i=0;i<arrOfInternalFrames.size();i++)
                {
                	VisChainerPanel f = (VisChainerPanel)arrOfInternalFrames.get(i);
                	if(f.isSelected())
                	{
                		 f.panel.drawRevClusterColor = JColorChooser.showDialog(VisChainerMain.this, "Choose Color....", f.panel.drawRevClusterColor );           		
                 		revClusterDraw.setForeground(f.panel.drawRevClusterColor);
                 		f.panel.repaint();
                 	  }
                }
               
            	for(int i=0;i<arrForNonOverLaidframes.size();i++)
                {
                	VisChainerPanel f = (VisChainerPanel)arrForNonOverLaidframes.get(i);
                	if(f.isSelected())
                	{
                		 f.panel.drawRevClusterColor = JColorChooser.showDialog(VisChainerMain.this, "Choose Color....", f.panel.drawRevClusterColor );		 
                 		revClusterDraw.setForeground(f.panel.drawRevClusterColor);
                 		f.panel.repaint();
                	}
               }
            }});
        
        
        scoreFilteration.addActionListener(new ActionListener(){
        	public void actionPerformed(ActionEvent e)
        	{
        		String s
        		=JOptionPane.showInputDialog(VisChainerMain.this,"enter the value between "+minScore+"--"+maxScore,"The Score Filteration",JOptionPane.QUESTION_MESSAGE);
        		if(s!= null && s!="")
        		{
        			try{
        				for(int i=0;i<arrOfInternalFrames.size();i++)
                        {
                        	VisChainerPanel f = (VisChainerPanel)arrOfInternalFrames.get(i);
                        	if(f.isSelected())
                        	{
                        		f.panel.threshold = Float.parseFloat(s);
                        	  f.panel.repaint();
                         	  
                        	}
                        }
                       
                    	for(int i=0;i<arrForNonOverLaidframes.size();i++)
                        {
                        	VisChainerPanel f = (VisChainerPanel)arrForNonOverLaidframes.get(i);
                        	if(f.isSelected())
                        	{
                        		f.panel.threshold = Float.parseFloat(s); 
                         		f.panel.repaint();
                        	}
                       }
        				
        			}catch(Exception ex)
        			{
        				JOptionPane.showMessageDialog(VisChainerMain.this,"Worng Format","Error",JOptionPane.ERROR_MESSAGE);
        			}
        		}
        	}
        });
        lengthFilteration.addActionListener(new ActionListener(){
        	public void actionPerformed(ActionEvent e)
        	{
        		String s
        		=JOptionPane.showInputDialog(VisChainerMain.this,"Enter the value between "+ minLength+"--"+ maxLength,"The Length Filteration",JOptionPane.QUESTION_MESSAGE);
        		if(s!= null && s!="")
        		{
        			try{
        				for(int i=0;i<arrOfInternalFrames.size();i++)
                        {
                        	VisChainerPanel f = (VisChainerPanel)arrOfInternalFrames.get(i);
                        	if(f.isSelected())
                        	{
                        		f.panel.length_threshold = Integer.parseInt(s);
                        	  f.panel.repaint();
                         	  
                        	}
                        }
                       
                    	for(int i=0;i<arrForNonOverLaidframes.size();i++)
                        {
                        	VisChainerPanel f = (VisChainerPanel)arrForNonOverLaidframes.get(i);
                        	if(f.isSelected())
                        	{
                        		f.panel.length_threshold = Integer.parseInt(s); 
                         		f.panel.repaint();
                        	}
                       }
        				
        			}catch(Exception ex)
        			{
        				JOptionPane.showMessageDialog(VisChainerMain.this,"Worng Format","Error",JOptionPane.ERROR_MESSAGE);
        			}
        		}
        	}
        });
       // ----------- to button to button panel 
        buttonBar.add(openButtonForMultipleGenomes);
        buttonBar.addSeparator();
        buttonBar.add(openForwardFiles);
        buttonBar.add(openReverseFiles);
        buttonBar.addSeparator();
        buttonBar.add(openFiles);
        buttonBar.addSeparator();
       // buttonBar.add(openLinealMode);
       // buttonBar.add(openAnnotaionfile);
        //-------------- add component -----------------------    
	    checkPanel.add(fragmentDraw);
	    checkPanel.add(chainFileDraw);
	    checkPanel.add(chainDraw);
	    checkPanel.add(clusterDraw);
	    
	    checkPanel.add(revFragmentDraw);
	    checkPanel.add(revChainFileDraw);
	    checkPanel.add(revChainDraw);
	    checkPanel.add(revClusterDraw);
	    checkPanel.add(chainConnectionDraw);
	    
	    checkPanel.add(exportImage);
	    
	    listPanel.add(listScrollPane);
	    listPanel.add(listScrollPane1);
	    listPanel.add(listScrollPane2);
	    
	    checkAndListPanel.add(checkPanel);
	    checkAndListPanel.add(listPanel);
	    
	    drawOption.add(fragmentDrawOp);
	    drawOption.add(chainFileDrawOp);
	    drawOption.add(chainDrawOp);
	    drawOption.add(clusterDrawOp);
	    
	    drawOption.add(revFragmentDrawOp);
	    drawOption.add(revChainFileDrawOp);
	    drawOption.add(revChainDrawOp);
	    drawOption.add(revClusterDrawOp);
	    
	    filterationPanel.add(scoreFilteration);
	    filterationPanel.add(lengthFilteration);
	    
	    tabbedPane.addTab("Check list",checkAndListPanel);
	    tabbedPane.addTab("Drawing Option", drawOption);
	    tabbedPane.addTab("Filteration", filterationPanel);
	    
	    
	    checkAndList.add(tabbedPane);	    
		checkAndList.setFloatable(false);

	//----------------------------------------------------------------------------     
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(desktop,BorderLayout.CENTER);
        this.getContentPane().add(buttonBar,BorderLayout.NORTH);
        this.getContentPane().add(checkAndList,BorderLayout.EAST);   	
 	}
 	/*
 	 * createMenuBar and Menu Items
 	 */
    JMenuBar createMenuBar() {
        menuBar = new JMenuBar();
        menu = new JMenu("Window");    	           
        menuBar.add(menu);
        menu.setVisible(false);
        return menuBar;
    }
//---------------------------------------------------
    /*
     * exportImage method
     * take the frame it will capture the image from
     */
    void exportImage(VisChainerPanel f)
    {
//    	------- to get the screen capture image 
		try {
			 robot = new Robot();
		    } catch (AWTException awte) {
		      awte.printStackTrace();} 
	  Rectangle screen = new Rectangle();
	  screen.setRect(f.panel.scrollPane.getCorner(JScrollPane.UPPER_LEFT_CORNER).getX(),f.panel.scrollPane.getCorner(JScrollPane.UPPER_LEFT_CORNER).getY()
			  ,f.panel.scrollPane.getColumnHeader().getWidth()+f.panel.scrollPane.getCorner(JScrollPane.UPPER_LEFT_CORNER).getWidth()
			  ,f.panel.scrollPane.getRowHeader().getHeight()+f.panel.scrollPane.getCorner(JScrollPane.UPPER_LEFT_CORNER).getHeight());
	      Point loc = screen.getLocation();
	      SwingUtilities.convertPointToScreen(loc,f.getContentPane());
	      screen.setLocation(loc);
	      BufferedImage bb=robot.createScreenCapture(screen);
	  //------------------------------------------------------------------------------------------------------------    
		JFileChooser fc = new JFileChooser();
		fc.setDialogTitle("Choose the Directory....... ");
    	fc.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
    	int returnVal =  fc.showSaveDialog(VisChainerMain.this);
    	
        String s="";
        if (returnVal == JFileChooser.APPROVE_OPTION) 
 	   {  
         try 
             { 
        		  s = (String)JOptionPane.showInputDialog(VisChainerMain.this,"Write The Name of file : ","Save As........ ",JOptionPane.QUESTION_MESSAGE,
 	                    null,
 	                    null,
 	                    null); 
        		  if(s != null)
        		  {
        			  f.panel.exportImage(bb,fc.getSelectedFile().getCanonicalFile()+parent.fileDash+s+".jpg");
         			  return;
        		  }
             }catch(Exception ex){}
 	   }
    }//end method
    
//-------------------------------------------------------
    /*
     * passLists method
     * take the number ,show the type of the file opened and the object open this file
     * -ask if the user want to open this file in new window or not
     * -assign the suitable flag in drawing panel to draw the opened file
     */
 	void passLists(int ext , ProcessingFiles profiles)
 	{
 		boolean overLayFlag= true;
 		//if there any opened files before , this function doesn't call when multiple genomes open and the file isn't sequence file
 		//it will ask if the user want to open the file in new window
 		if(arrOfInternalFrames.size() != 0 && !allGenomesFlag && ext != -1)
 		{
 			
 			int n = JOptionPane.showConfirmDialog(
 					VisChainerMain.this, "Do You want to open new window to this file? ",
    	            "Question",
    	            JOptionPane.YES_NO_OPTION);
    	            
    	        if (n == JOptionPane.YES_OPTION) 
    	        {
    	        	overLayFlag = false;
    	        	//----- to make not draw anywhere ,but in new window only
    	        	profiles.forNewWindow=true;
    	        	proFilesArr.add(profiles);
    	        	//----to ask if ,the user want to open the projection of this file for all genomes or for 2 genomes
    	        	//the choose will be by combo box appear in the message dialog
    	        	String[] possibilities =new String[arrOfInternalFrames.size()+1];
    	        	possibilities[0]= "All Genomes";
    	        	
    	        	//to get the refrence to all windows of 2 genomes
    	        	for(int i=0;i<arrOfInternalFrames.size();i++)
    	            {
    	            	VisChainerPanel f = (VisChainerPanel)arrOfInternalFrames.get(i);
    	            	possibilities[i+1]= (f.panel.firstGenomeNum+1)+" & "+((f.panel.secondGenomeNum+1));
    	            }
                	String s = (String)JOptionPane.showInputDialog(VisChainerMain.this,"Choose the compination : ","According to Which....",JOptionPane.QUESTION_MESSAGE,
                	                    null,
                	                    possibilities,
                	                    "All Genomes");
                	if ((s != null) && (s.length() > 0))
                	{
                		for(int j=0;j<possibilities.length;j++)
                		{
                			//---for specific 2 genomes
                			if(s == possibilities[j] && j !=0)
                				{
                					creatNonOverLayFrames(ext,j);
                					saveSessionArr_.add("3,"+j+","+(proFilesArr.size()-1));
                				}
                		//-if the user want to draw it , for all genomes	
                		if(s == possibilities[j] && j ==0)
                			{
                				for(int k=1 ;k <= arrOfInternalFrames.size();k++)
                					creatNonOverLayFrames(ext, k);
                				saveSessionArr_.add("3,0,"+(proFilesArr.size()-1));
                			}
                		}
                	}
                	
                	
    	        }  
 		}//end of if(arrOfInternalFrames.size() != 0 && !allGenomesFlag && ext != -1)
 		
 		//--if the file is the first file the user open or the user wants to draw it overlay on the other files
 		if(overLayFlag){
 		
 			//to create the internal frame..if nothing created , not sequence file and the file opened[check if the open file function return true]	
 		if(arrOfInternalFrames.size() == 0 && ext != -1 && (fragmentDraw.isSelected() || chainDraw.isSelected()|| clusterDraw.isSelected()
 				|| chainFileDraw.isSelected()|| revFragmentDraw.isSelected()|| revChainDraw.isSelected() || 
 				revClusterDraw.isSelected()|| revChainFileDraw.isSelected()))//ext = -1 , in case of open sequence file
    	openInternalFrames();
 		
 		//to add the processing files object......
 		proFilesArr.add(profiles);
 		
 		//counter 
 		int k =0;
 		//nested loop to reach all the internal frames and know the number of genomes it contian
    	for(int i=0; i<num;i++)
    	{
    		for(int j=i+1; j < num;j++)
    		{
    			VisChainerPanel frame = (VisChainerPanel)arrOfInternalFrames.get(k);
    			//to send the number of the genomes in the projection to the panel which draw the projection
    			//this only one time..if the panel not get these numbers yet
    			if(frame.panel.firstGenomeNum ==-1)
    			{
    			frame.panel.firstGenomeNum = i;
    			frame.panel.secondGenomeNum=j;
    			frame.panel.proFilesArr = this.proFilesArr;
    			}//end if to set these variables only one time
    			
				if(ext == 1)
				{
				frame.panel.drawFrag=true;
				if(allGenomesFlag)
					frame.panel.drawRevFrag = true;
				}
				if(ext == 2)
				{
				frame.panel.drawChain= true;
				if(allGenomesFlag)
					frame.panel.drawRevChain = true;
				}
				if(ext == 3)
				{
				frame.panel.drawCluster=true;
				if(allGenomesFlag)
					frame.panel.drawRevCluster = true;
				}
				
				if(ext == 4)
				{
				frame.panel.drawRevFrag=true;
				}
				if(ext == 5)
				{
				frame.panel.drawRevChain=true;
				}
				if(ext == 6)
				{
    		  	frame.panel.drawRevCluster=true;
    		  	}
				if(ext == 7)
				{
    		  	frame.panel.drawChainFile=true;
    		  	if(allGenomesFlag)
					frame.panel.drawRevChainFile = true;
    		  	}
				if(ext == 8)
				{
    		  	frame.panel.drawRevChainFile=true;
    		  	}
				//----
    		  	//----
    		  	k++;
    		  	//---
    		  	if(frame.panel.firstEnd <(int)maxEndInFragments.get(i))
    		  	frame.panel.firstEnd=(int)maxEndInFragments.get(i);
    		  	if(frame.panel.secondEnd < (int)maxEndInFragments.get(j))
    		  	frame.panel.secondEnd=(int)maxEndInFragments.get(j);
    		  	
    		  	//---
    		  	//==if the sequence file open after the internal frames have been opened
    		  	if(ext == -1 && arrOfInternalFrames.size() != 0)
    		  	{
    		  		if((numberOfOpenedSeq-1) == i)
    		  		frame.panel.seqArr[0] = (Sequence)arrOfSequences.get(i);
    		  		if((numberOfOpenedSeq-1) == j)
    		  		frame.panel.seqArr[1] = (Sequence)arrOfSequences.get(j);
    		  	}
    		  	//---
            }//end j for loop 
          }//end i for loop
    	
    	//---------- lineal mode frame
    	 if(linealModeframe != null)
    	   {
			if(ext == 1)
			{
				linealModeframe.panel.drawFrag=true;
			}
				if(ext == 2)
				{
					linealModeframe.panel.drawChain= true;
				}
			if(ext == 3)
			{
				linealModeframe.panel.drawCluster=true;}
			if(ext == 4)
			{
				linealModeframe.panel.drawRevFrag=true;
			}
			if(ext == 5)
			{
				linealModeframe.panel.drawRevChain=true;
			}
			if(ext == 6)
			{
				linealModeframe.panel.drawRevCluster=true;
 		  	}
			if(ext == 7)
			{
				linealModeframe.panel.drawChainFile=true;
 		  	}
			if(ext == 8)
			{
				linealModeframe.panel.drawRevChainFile=true;
 		  	}
			//check the maximum
			//----to get the maximum length for the genomes
            for (int i=1; i<maxEndInFragments.size(); i++) {
                if ((int)maxEndInFragments.get(i) > linealModeframe.panel.theMaxLength) {
                	linealModeframe.panel.theMaxLength = (int)maxEndInFragments.get(i);   // new maximum
                }
            }           
    	   }//end of if(linealModeframe != null)
 		}//end of if overLayFlag is true
 		
 	}//end of function passLists
 	
 	//method same as the above but customize for calling when open session from saved file
 	/**
 	 * Method:passListsForOpenSessionMethod
 	 * param> ext to know the type of the file
 	 * param>the object of the profiles
 	 * param>if the profiles object is non over lay file
 	 * param>the neumber to show the file which non overllay , will draw for which 2 genomes or for all
 	 */
 	void passListsForOpenSessionMethod(int ext , ProcessingFiles profiles,boolean overLayFlag,int forNonoverlay)
 	{
 		
 		//if there any opened files before , this function doesn't call when multiple genomes open and the file isn't sequence file
 		//it will ask if the user want to open the file in new window
 		if(!overLayFlag)
 		{
    	        	//----- to make not draw anywhere ,but in new window only
    	        	profiles.forNewWindow=true;
    	        	
    	        	proFilesArr.add(profiles);
    	        	//----to ask if ,the user want to open the projection of this file for all genomes or for 2 genomes
    	        	//the choose will be by combo box appear in the message dialog
    	        	String[] possibilities =new String[arrOfInternalFrames.size()+1];
    	        	possibilities[0]= "All Genomes";
    	        	
    	        	if(forNonoverlay ==0)
    	        	{
    	        		for(int k=1 ;k <= arrOfInternalFrames.size();k++)
        					creatNonOverLayFrames(ext, k);
    	        		
    	        	}
    	        	else
    	        	{
    	        		creatNonOverLayFrames(ext,forNonoverlay);
    	        		
    	        	}
    	        	saveSessionArr_.add("3,"+forNonoverlay+","+(proFilesArr.size()-1));
    	        	
    	          
 		}//end of if(arrOfInternalFrames.size() != 0 && !allGenomesFlag && ext != -1)
 		
 		//--if the file is the first file the user open or the user wants to draw it overlay on the other files
 		if(overLayFlag){
 		
 			//to create the internal frame..if nothing created , not sequence file and the file opened[check if the open file function return true]	
 		if(arrOfInternalFrames.size() == 0 && ext != -1 && (fragmentDraw.isSelected() || chainDraw.isSelected()|| clusterDraw.isSelected()
 				|| chainFileDraw.isSelected()|| revFragmentDraw.isSelected()|| revChainDraw.isSelected() || 
 				revClusterDraw.isSelected()|| revChainFileDraw.isSelected()))//ext = -1 , in case of open sequence file
    	openInternalFrames();
 		
 		//to add the processing files object......
 		proFilesArr.add(profiles);
 		
 		//counter 
 		int k =0;
 		//nested loop to reach all the internal frames and know the number of genomes it contian
    	for(int i=0; i<num;i++)
    	{
    		for(int j=i+1; j < num;j++)
    		{
    			VisChainerPanel frame = (VisChainerPanel)arrOfInternalFrames.get(k);
    			//to send the number of the genomes in the projection to the panel which draw the projection
    			//this only one time..if the panel not get these numbers yet
    			if(frame.panel.firstGenomeNum ==-1)
    			{
    			frame.panel.firstGenomeNum = i;
    			frame.panel.secondGenomeNum=j;
    			frame.panel.proFilesArr = this.proFilesArr;
    			}//end if to set these variables only one time
    			
				if(ext == 1)
				{
				frame.panel.drawFrag=true;
				if(allGenomesFlag)
					frame.panel.drawRevFrag = true;
				}
				if(ext == 2)
				{
				frame.panel.drawChain= true;
				if(allGenomesFlag)
					frame.panel.drawRevChain = true;
				}
				if(ext == 3)
				{
				frame.panel.drawCluster=true;
				if(allGenomesFlag)
					frame.panel.drawRevCluster = true;
				}
				
				if(ext == 4)
				{
				frame.panel.drawRevFrag=true;
				}
				if(ext == 5)
				{
				frame.panel.drawRevChain=true;
				}
				if(ext == 6)
				{
    		  	frame.panel.drawRevCluster=true;
    		  	}
				if(ext == 7)
				{
    		  	frame.panel.drawChainFile=true;
    		  	if(allGenomesFlag)
					frame.panel.drawRevChainFile = true;
    		  	}
				if(ext == 8)
				{
    		  	frame.panel.drawRevChainFile=true;
    		  	}
				//----
    		  	//----
    		  	k++;
    		  	//---
    		  	if(frame.panel.firstEnd <(int)maxEndInFragments.get(i))
    		  	frame.panel.firstEnd=(int)maxEndInFragments.get(i);
    		  	if(frame.panel.secondEnd < (int)maxEndInFragments.get(j))
    		  	frame.panel.secondEnd=(int)maxEndInFragments.get(j);
    		  	
    		  	//---
    		  	//==if the sequence file open after the internal frames have been opened
    		  	if(ext == -1 && arrOfInternalFrames.size() != 0)
    		  	{
    		  		if((numberOfOpenedSeq-1) == i)
    		  		frame.panel.seqArr[0] = (Sequence)arrOfSequences.get(i);
    		  		if((numberOfOpenedSeq-1) == j)
    		  		frame.panel.seqArr[1] = (Sequence)arrOfSequences.get(j);
    		  	}
    		  	//---
            }//end j for loop 
          }//end i for loop

 		}//end of if overLayFlag is true
 	}//end of method passListForOpenSessionMethod()
//-------------------------------------------
//--------------------------------------------------
	// to open internal frames to draw every two genomes togther 
    // the number of internal frames =
    // (n-1) + (n-2) + (n-3) +....+1
 	// it is important to create the frames and make refrence to them all, to add to them the file opened
 	//even if the frame not visible,but if it visible all file which the user choose to draw as overlaw draw must appear in all, projections
	void openInternalFrames()
	{
 		int numberOfInternalFrames = 0;
 		//get the number of the frames
 		numberOfInternalFrames = numOFInternal(num);
 		this.menuItems = new MyMenuItem[numberOfInternalFrames];
 		//create the projection frames and add it to the array list
 		for(int i =0 ; i < numberOfInternalFrames ; i++)
 		{
 		 	this.arrOfInternalFrames.add(createFrame());
 		}
 		//to show only first one in the first open
 		if(this.arrOfInternalFrames.size()>0)
 		{
 			VisChainerPanel frame1 =(VisChainerPanel)this.arrOfInternalFrames.get(0);
 			frame1.setVisible(true);
 			desktop.add(frame1);
 		}
 		
 		//create array of menu item contian the name of all the frames
 		//to intialize the objects in the array and add action listener to each one
 		for(int i=0;i<this.menuItems.length;i++)
 		{
 			this.menuItems[i] = new MyMenuItem();
 			this.menuItems[i].index = i;
 			//add action listener for menu items to make the frame visible if it is not
 			this.menuItems[i].addActionListener(new ActionListener()
 			{
 				public void actionPerformed(ActionEvent e)
 				{
 					MyMenuItem m = (MyMenuItem)e.getSource();
 					VisChainerPanel frame =(VisChainerPanel)arrOfInternalFrames.get(m.index);
 					if(!frame.isVisible())
 					{	
 						frame.setVisible(true); //necessary as of 1.3; OK to use before
 						desktop.add(frame);
 						
 						try {
              				frame.setSelected(true);
             				}
        				catch (java.beans.PropertyVetoException ex){}
        				//this function is depracated , but it is imporant here ...and delete them will make difference ;)
        				frame.show(true);
        				frame.resize(600, 650);
 				    }
 					frame.moveToFront();
 				}
 			});
 		}
 		
 		//--- to set the title of all frames and sent the sequence 
 		int k =0;
        for(int i=0; i< num;i++)
        {
           for(int j=i+1; j< num;j++)
            {
            	VisChainerPanel frame =(VisChainerPanel)this.arrOfInternalFrames.get(k);
            	frame.setTitle(frame.getTitle()+": genome "+(i+1)+"and "+(j+1));
            	menuItems[k].setText(frame.getTitle());
            	k++;
            	//---if the sequence file opened before the internal frames
            	if(numberOfOpenedSeq > 0)
    		  	{
    		  		if(numberOfOpenedSeq > i)
    		  		frame.panel.seqArr[0] = (Sequence)arrOfSequences.get(i);
    		  		if(numberOfOpenedSeq > j)
    		  		frame.panel.seqArr[1] = (Sequence)arrOfSequences.get(j);
    		  	}	
            }
        }
        menu.setVisible(true);
       
        //not add menu items for all frames, only three of them and the other u can opened by enter the number of the genome,
        //want to see the projection between them
        JMenuItem openChossen = new JMenuItem("choose the projection...");
        openChossen.addActionListener(new ActionListener()
			{
				public void actionPerformed(ActionEvent e)
				{	
					//get the index of the internal frame....	
					MsgBox msg=new MsgBox("Enter the projections",true,"1","2");
					if(msg.id)
					{
						int i1 = Integer.parseInt(msg.startFrom);
						int i2 = Integer.parseInt(msg.endTo);
						
						int i3 = Math.min(i1,i2);
						int i4 = Math.max(i1, i2);
						
						for(int i = 0; i < arrOfInternalFrames.size();i++)
						{
							VisChainerPanel frame =(VisChainerPanel)arrOfInternalFrames.get(i);
							
							if(frame.panel.firstGenomeNum == i3-1)
							{
								if(frame.panel.secondGenomeNum == i4-1)
								{
									if(!frame.isVisible())
									{	
										frame.setVisible(true); //necessary as of 1.3; OK to use before
										desktop.add(frame);
										frame.moveToFront();
										try {
				          				frame.setSelected(true);
				         				}
				    				catch (java.beans.PropertyVetoException ex){}
				    				frame.show(true);
				    				frame.resize(600, 650);
								    }
								}
							}
						}
					}
					
				}
			});
        
        menu.add(openChossen);
        
        for(int i=0;i< this.menuItems.length;i++)
        {
        	menu.add(this.menuItems[i]);
        	if(i > numberOfShownProjections)
        		this.menuItems[i].setVisible(false);
		}	
	}
	/*
	 * numOFInternal
	 * param> x : the number of genomes
	 * return>the number of the internal frame which should open
	 * recursive call---in the caculations
	 */
	//------ to get the number of internal
	int numOFInternal(int x)
	{
		if(x <= 2)
		return 1;
		else
		return (x-1) + numOFInternal(x-1);
	}
	
	//-------- createFrame
    VisChainerPanel createFrame()
    {
    	
        VisChainerPanel frame = new VisChainerPanel(VisChainerMain.this);
	    
     //make listener for the frame , if it activiated "selected" ...change the state and the color of the check boxes
        frame.addInternalFrameListener( new InternalFrameAdapter() 
        {
        	public void internalFrameActivated(InternalFrameEvent e) 
        	{
        		VisChainerPanel f = (VisChainerPanel)e.getSource();
        		//to set the check BOX
        		fragmentDraw.setSelected(f.panel.drawFrag);
        		chainDraw.setSelected(f.panel.drawChain);
        		clusterDraw.setSelected(f.panel.drawCluster);
        		chainFileDraw.setSelected(f.panel.drawChainFile);
        		revFragmentDraw.setSelected(f.panel.drawRevFrag);
        		revChainDraw.setSelected(f.panel.drawRevChain);
        		revChainFileDraw.setSelected(f.panel.drawRevChainFile);
        		revClusterDraw.setSelected(f.panel.drawRevCluster);
        		
        		chainConnectionDraw.setSelected(f.panel.drawChainConnection);
        		
        		fragmentDraw.setForeground(f.panel.drawFragColor);
        		chainDraw.setForeground(f.panel.drawChainColor);
        		clusterDraw.setForeground(f.panel.drawClusterColor);
        		chainFileDraw.setForeground(f.panel.drawChainFileColor);
        		
        		revFragmentDraw.setForeground(f.panel.drawRevFragColor);
        		revChainDraw.setForeground(f.panel.drawRevChainColor);
        		revChainFileDraw.setForeground(f.panel.drawRevChainFileColor);
        		revClusterDraw.setForeground(f.panel.drawRevClusterColor);
        		
        	}
        	});
       
        return frame;
    }
//------------------------------------------------------------------------------------------------------------------
// creat non over laid frames
   /*
    * creatNonOverLayFrames
    * param>take number show the type of the file
    * param>the index of the projection ,which contians the same 2 genomes it will drarw the projection to them too
    * so the new window can have the same important variables to draw the projection
    */ 
    void creatNonOverLayFrames(int ext,int j)
    {
    	VisChainerPanel frame1=createFrame();
		VisChainerPanel f = (VisChainerPanel)arrOfInternalFrames.get(j-1);
		frame1.panel.firstGenomeNum = f.panel.firstGenomeNum;
		frame1.panel.secondGenomeNum=f.panel.secondGenomeNum;
		frame1.panel.proFilesArr = this.proFilesArr;
		if((numberOfOpenedSeq-1) ==  f.panel.firstGenomeNum)
	  		frame1.panel.seqArr[0] = (Sequence)arrOfSequences.get(f.panel.firstGenomeNum);
	  	if((numberOfOpenedSeq-1) ==f.panel.secondGenomeNum)
	  		frame1.panel.seqArr[1] = (Sequence)arrOfSequences.get(f.panel.secondGenomeNum);
	  	frame1.panel.firstEnd=(int)maxEndInFragments.get(f.panel.firstGenomeNum);
	  	frame1.panel.secondEnd=(int)maxEndInFragments.get(f.panel.secondGenomeNum);
	  	
	  	//to make draw only one object of processing files
	  	frame1.panel.forNewWindow=true;
	  	frame1.panel.forNewWindowIndex = proFilesArr.size()-1;//because the profile ,is the lat object haas been added
	  	
	  	//create menu item refer to this new window, to open it if it close and its name is the pathe of the file
	  	MyMenuItem menuItem = new MyMenuItem();
		menuItem.index = arrOfMenuItemsOfNonOverLay.size();
		menuItem.addActionListener(new ActionListener()
			{
				public void actionPerformed(ActionEvent e)
				{
					MyMenuItem m = (MyMenuItem)e.getSource();
					VisChainerPanel frame =(VisChainerPanel)arrForNonOverLaidframes.get(m.index);
					if(!frame.isVisible())
					{	
						frame.setVisible(true); //necessary as of 1.3; OK to use before
						desktop.add(frame);
						frame.moveToFront();
						try {
          				frame.setSelected(true);
         				}
    				catch (java.beans.PropertyVetoException ex){}
    				frame.show(true);
    				frame.resize(600, 650);
				    }
				}
			});
		
		//to get the title from the object open the file
		ProcessingFiles profiles = (ProcessingFiles)this.proFilesArr.get(proFilesArr.size()-1);
		frame1.setTitle(profiles.filePath);
    	menuItem.setText(frame1.getTitle());
    	
		frame1.setVisible(true);
			desktop.add(frame1);
			frame1.moveToFront();
			frame1.show(true);
			frame1.resize(600, 650);
			menu.add(menuItem);
	  	if(ext == 1)
		{
	  		frame1.panel.drawFrag=true;
		}
		if(ext == 2)
		{
			frame1.panel.drawChain= true;
		}
		if(ext == 3)
		{
			frame1.panel.drawCluster=true;}
		if(ext == 4)
		{
			frame1.panel.drawRevFrag=true;
		}
		if(ext == 5)
		{
			frame1.panel.drawRevChain=true;
		}
		if(ext == 6)
		{
			frame1.panel.drawRevCluster=true;
	  	}
		if(ext == 7)
		{
			frame1.panel.drawChainFile=true;
	  	}
		if(ext == 8)
		{
			frame1.panel.drawRevChainFile=true;
		}
		
		//add the this new window and the menu item refer to it in array list
			arrOfMenuItemsOfNonOverLay.add(menuItem);
			arrForNonOverLaidframes.add(frame1);
    }

//------------------------------------------------------------------------------------------------------------------
    
    void toWriteInTheOpenedFilesList(String s)
    {
    
    	openedFilesArr.add("ID:"+openedFilesArr.size()+" "+s);
   	 	openedFiles.setListData(openedFilesArr.toArray());
   	 	openedFiles.repaint();  
    }
    
    void toWriteInTheConsoleList(String s)
    {
    	consoleArr.add(s);
      	consoleArea.setListData(consoleArr.toArray());
      	consoleArea.repaint();
    }
//*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-	

  //---------------------------------------------------------------
	//----class to draw jdialog to choose which the user want to show
    //it take the number of the 2 genomes
    class MsgBox extends JDialog implements ActionListener {
		 boolean id = false;
		 Button ok;
		 Button can;
		 String startFrom="";
		 String endTo="";

		/**
		 * 
		 * @uml.property name="startText"
		 * @uml.associationEnd multiplicity="(0 1)"
		 */
		public NumericTextField startText;

		/**
		 * 
		 * @uml.property name="endText"
		 * @uml.associationEnd multiplicity="(0 1)"
		 */
		public NumericTextField endText;

		 MsgBox(String msg, boolean okcan,String x,String y){
			 super(parent);
		  startFrom = x;
		  endTo= y;
		  this.setTitle("Message....");
		  this.setModal(true);
		  this.getContentPane().setLayout(new BorderLayout());
		  this.getContentPane(). add(new Label(msg),BorderLayout.NORTH);
		  addRangePanel();
		  addOKCancelPanel(okcan);
		  createFrame();
		  pack();
		  setVisible(true);
		  }

		 void addRangePanel( ) {
			  Panel p = new Panel();
			  p.setLayout(new FlowLayout());
			  JLabel start = new JLabel(" genome 1: ");
			  JLabel end = new JLabel(" genome 2 : ");
			  startText = new NumericTextField(startFrom,5);
			  endText=new NumericTextField(endTo,5);
			  p.add(start);
			  p.add(startText);
			  p.add(end);
			  p.add(endText);
			  this.getContentPane().add(p,BorderLayout.CENTER);
			  }
		 
		 void addOKCancelPanel( boolean okcan ) {
		  Panel p = new Panel();
		  p.setLayout(new FlowLayout());
		  createOKButton( p );
		  if (okcan == true)
		     createCancelButton( p );
		  this.getContentPane().add(p,BorderLayout.SOUTH);
		  }

		 void createOKButton(Panel p) {
		  p.add(ok = new Button("OK"));
		  ok.addActionListener(this); 
		  }

		 void createCancelButton(Panel p) {
		  p.add(can = new Button("Cancel"));
		  can.addActionListener(this);
		  }

		 void createFrame() {
		  Dimension d = getToolkit().getScreenSize();
		  setLocation(d.width/3,d.height/3);
		  }

		 public void actionPerformed(ActionEvent ae){
		  if(ae.getSource() == ok) {
		    id = true;
		    startFrom = startText.getText();
		    endTo = endText.getText();
		    setVisible(false);
		    }
		  else if(ae.getSource() == can) {
		    setVisible(false);
		    }
		  }
		}
	//--------------------------------------------
    //class to make the text field in the above class ...only take numbers
	public class NumericTextField extends JTextField
	{
	 public NumericTextField (String _initialStr, int _col)
	 { 
	    super (_initialStr, _col) ;
	       
	    this.addKeyListener(new KeyAdapter()
	   {
	       public void keyTyped (KeyEvent e) 
	        { 
	            char c = e.getKeyChar() ;
	                
	            if (! ((c== KeyEvent.VK_ENTER)|| (c == KeyEvent.VK_TAB) 
	                ||  (Character.isDigit(c)))) 
	            {
	               e.consume() ;
	           } 
	            if(c == KeyEvent.VK_BACK_SPACE)
	            {
	            	e.consume() ;
	            }
	        } 
	    });
	 } 
	  public NumericTextField (int _col) 
	  { 
	    this ("", _col) ; 
	  } 
	}
}//end of class
/////////////////////////////////////////////////////////////////////////////////
/*
*MyMenyItem class
*
*Usage: to get the index of it ,which is crossponding to index of internal frame
*
**///////////////////////////////////////////////////////////////////////////////
class MyMenuItem extends JMenuItem
{
   	//only to know the index in the array when use the action listener
   	public int index =-1;
   	
   	public MyMenuItem()
   	{
   		super();
   	}
}//end of class 
