/*
*VisChainer.java
*
*this class is tha main frame open,where all the seesion frame open in its desktopPane 
* as Internal frames
* 
*Asem A. Othamn(a.othman@k-space.org)
*/
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

import java.beans.*;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class VisChainer extends JFrame
{

	/**
	 * 
	 * @uml.property name="menuBar"
	 * @uml.associationEnd multiplicity="(1 1)"
	 */
	//the toolbar contains the button of new session
	JMenuBar menuBar;

	/**
	 * 
	 * @uml.property name="mainMenu"
	 * @uml.associationEnd multiplicity="(1 1)"
	 */
	JMenu mainMenu;

	/**
	 * 
	 * @uml.property name="aboutMenu"
	 * @uml.associationEnd multiplicity="(1 1)"
	 */
	JMenu aboutMenu;

	
	JMenu ThemeMenu;
	/**
	 * 
	 * @uml.property name="about"
	 * @uml.associationEnd multiplicity="(1 1)"
	 */
	JMenuItem about;

	/**
	 * 
	 * @uml.property name="openNew"
	 * @uml.associationEnd multiplicity="(1 1)"
	 */
	//the button which open the session
	JMenuItem openNew;

	/**
	 * 
	 * @uml.property name="openExist"
	 * @uml.associationEnd multiplicity="(1 1)"
	 */
	JMenuItem openExist;

	/**
	 * 
	 * @uml.property name="saveSession"
	 * @uml.associationEnd multiplicity="(1 1)"
	 */
	JMenuItem saveSession;

	/**
	 * 
	 * @uml.property name="recentSession"
	 * @uml.associationEnd multiplicity="(1 1)"
	 */
	JMenu recentSession;
	
	JMenuItem clearRecentSession;
	
	
	/**
	 * 
	 * @uml.property name="desktop"
	 * @uml.associationEnd multiplicity="(1 1)"
	 */
	//the dektop pane object ..to add the internal frame to it
	JDesktopPane desktop;

	//the margin variable, which according to it the window will fill the screen..
	int margin=20;
	
//	for the file path in the different operating systems
	public String fileDash = "/";
	
	//----the constructor
	/*
	 * //Set up the GUI.
	 */
	public VisChainer() 
    {
        super("VisChainer");
        
        String[] possibilities = {"Linux Or Unix","Windows"};
    	String s = (String)JOptionPane.showInputDialog(VisChainer.this,"Choose the type of your operating system : ","Oprating System",JOptionPane.QUESTION_MESSAGE,
    	                    null,
    	                    possibilities,
    	                    "Linux Or Unix");

    	if(s == possibilities[0])
    		fileDash = "/";
    	if(s == possibilities[1])
    		fileDash = "\\";
        
        
        menuBar = new JMenuBar();
        mainMenu = new JMenu("File");
        openNew=  new JMenuItem("New Session");
        openExist = new JMenuItem("Open Session");
        saveSession = new JMenuItem("Save Session");
        recentSession =new  JMenu("Recent Sessions");
        
        clearRecentSession = new JMenuItem("Clear the recents menu");
        
        aboutMenu = new JMenu("Help");
        about = new JMenuItem("About");
        
        ThemeMenu = new JMenu("Look&Feel");
        JMenuItem theme1 = new JMenuItem("BrownSugar");
        JMenuItem theme2 = new JMenuItem("SkyBluer");
        JMenuItem theme3 = new JMenuItem("DesertBlue");
        JMenuItem theme4 = new JMenuItem("DesertYellow");
        JMenuItem theme5 = new JMenuItem("Silver");
        JMenuItem theme6 = new JMenuItem("SkyGreen");
        JMenuItem theme7 = new JMenuItem("SkyPink");
        JMenuItem theme8 = new JMenuItem("SkyKrupp");
        
        //---the actionListener for the button , to open new session and asign name to the session frame
        openNew.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) 
            {
            	//take the name from the user
            	String s = "";
            
            	s = (String)JOptionPane.showInputDialog(VisChainer.this,"Write Name For The new session","Name",
            			JOptionPane.QUESTION_MESSAGE,
            	                    null,
            	                    null,
            	                    "Untitled Session_"+desktop.getAllFrames().length);
            	if(s == "" || s==null)
            		s= "Untitled Session"+desktop.getAllFrames().length;
            	//create the object of the session frame and make it visible
 				VisChainerMain frame = new VisChainerMain(s,VisChainer.this);
 				frame.setVisible(true);
 				
 				//add it to dektopPane object and make appear in the front of the view
 				 desktop.add(frame);
 				frame.moveToFront();
            }
        });
       
        saveSession.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) 
            {
            	saveSessions();
            }
        });
        
        openExist.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) 
            {
            	JFileChooser fc = new JFileChooser();
        	    int returnVal = fc.showOpenDialog(VisChainer.this);
        		if (returnVal == JFileChooser.APPROVE_OPTION) 
        		{
            	openSession(fc.getSelectedFile());
        		}//end of if
      		  else 
      	     {
      	     	JOptionPane.showMessageDialog(VisChainer.this,"You don't select any files");
      	     			
      	     }
            }
        });
        
        /**
         * Recent Sessions
         */
        clearRecentSession.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) 
            {
            	File recentFile  = new File("RecentSession.txt");
              	 boolean existsOFRecent = (recentFile).exists();   
              	 try{
              	 if(existsOFRecent)
              	 {//File exists
           		    	recentFile.deleteOnExit();
              	 }//end of if
              	 }catch(Exception ex){}
            }
        });
                
        about.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) 
            {
            	 ImageIcon icon = new ImageIcon("logo.png");
            	JOptionPane.showMessageDialog(VisChainer.this, ""/* +
            			" VisChainer was written by Asem A. Othman and Mohamed I. Abouelhoda, Theoretical Bioinformatics Group of Ulm University,  \n as " +
            			"part of the CoCoNUT system for comparative genomics supported by DFG \n" +
            			"VisChainer is free software and is distributed under the term s of the GNU General Public License. "
            			*/, "About....", JOptionPane.INFORMATION_MESSAGE,icon);
            }
        });
        //Quit this app when the big window closes.
        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        
        UIManager.addPropertyChangeListener(new UISwitchListener((JComponent)getRootPane()));
        
        theme1.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) 
            {
//            	--- Change the look and feel of our window ************************************************//////////
            	
            	try {
                    //javax.swing.plaf.metal.MetalLookAndFeel.setCurrentTheme( new javax.swing.plaf.metal.);
          	 		com.jgoodies.looks.plastic.PlasticLookAndFeel.setPlasticTheme(new com.jgoodies.looks.plastic.theme.BrownSugar());
                    // UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
          	 		 UIManager.setLookAndFeel(new com.jgoodies.looks.plastic.PlasticXPLookAndFeel());
          	 		
                  }  
                  catch ( Exception ex ) 
                  {
                     
                  }
                  
            }
        });
        
        theme2.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) 
            {
            	try {
                    //javax.swing.plaf.metal.MetalLookAndFeel.setCurrentTheme( new javax.swing.plaf.metal.);
          	 		com.jgoodies.looks.plastic.PlasticLookAndFeel.setPlasticTheme(new com.jgoodies.looks.plastic.theme.SkyBluer());
                    // UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
          	 		 UIManager.setLookAndFeel(new com.jgoodies.looks.plastic.PlasticXPLookAndFeel());
          	 		
                  }  
                  catch ( Exception ex ) 
                  {
                     
                  }
            }
        });
        theme3.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) 
            {
            	try {
                    //javax.swing.plaf.metal.MetalLookAndFeel.setCurrentTheme( new javax.swing.plaf.metal.);
          	 		com.jgoodies.looks.plastic.PlasticLookAndFeel.setPlasticTheme(new com.jgoodies.looks.plastic.theme.DesertBlue());
                    // UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
          	 		 UIManager.setLookAndFeel(new com.jgoodies.looks.plastic.PlasticXPLookAndFeel());
          	 		
                  }  
                  catch ( Exception ex ) 
                  {
                     
                  }
            }
        });
        theme4.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) 
            {
            	try {
                    //javax.swing.plaf.metal.MetalLookAndFeel.setCurrentTheme( new javax.swing.plaf.metal.);
          	 		com.jgoodies.looks.plastic.PlasticLookAndFeel.setPlasticTheme(new com.jgoodies.looks.plastic.theme.DesertYellow());
                    // UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
          	 		 UIManager.setLookAndFeel(new com.jgoodies.looks.plastic.PlasticXPLookAndFeel());
          	 		
                  }  
                  catch ( Exception ex ) 
                  {
                     
                  }
            }
        });
        theme5.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) 
            {
            	try {
                    //javax.swing.plaf.metal.MetalLookAndFeel.setCurrentTheme( new javax.swing.plaf.metal.);
          	 		com.jgoodies.looks.plastic.PlasticLookAndFeel.setPlasticTheme(new com.jgoodies.looks.plastic.theme.Silver());
                    // UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
          	 		 UIManager.setLookAndFeel(new com.jgoodies.looks.plastic.PlasticXPLookAndFeel());
          	 		
                  }  
                  catch ( Exception ex ) 
                  {
                     
                  }
            }
        });
        theme6.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) 
            {
            	try {
                    //javax.swing.plaf.metal.MetalLookAndFeel.setCurrentTheme( new javax.swing.plaf.metal.);
          	 		com.jgoodies.looks.plastic.PlasticLookAndFeel.setPlasticTheme(new com.jgoodies.looks.plastic.theme.SkyGreen());
                    // UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
          	 		 UIManager.setLookAndFeel(new com.jgoodies.looks.plastic.PlasticXPLookAndFeel());
          	 		
                  }  
                  catch ( Exception ex ) 
                  {
                     
                  }
            }
        });
        theme7.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) 
            {
            	try {
                    //javax.swing.plaf.metal.MetalLookAndFeel.setCurrentTheme( new javax.swing.plaf.metal.);
          	 		com.jgoodies.looks.plastic.PlasticLookAndFeel.setPlasticTheme(new com.jgoodies.looks.plastic.theme.SkyPink());
                    // UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
          	 		 UIManager.setLookAndFeel(new com.jgoodies.looks.plastic.PlasticXPLookAndFeel());
          	 		
                  }  
                  catch ( Exception ex ) 
                  {
                     
                  }
            }
        });
        
        theme8.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) 
            {
            	try {
                    //javax.swing.plaf.metal.MetalLookAndFeel.setCurrentTheme( new javax.swing.plaf.metal.);
          	 		com.jgoodies.looks.plastic.PlasticLookAndFeel.setPlasticTheme(new com.jgoodies.looks.plastic.theme.SkyKrupp());
                    // UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
          	 		 UIManager.setLookAndFeel(new com.jgoodies.looks.plastic.PlasticXPLookAndFeel());
          	 		
                  }  
                  catch ( Exception ex ) 
                  {
                     
                  }
            }
        });
        
        
        
        
        
        //Set up the GUI.
        desktop = new JDesktopPane(); //a specialized layered pane
        //Make dragging faster:
        desktop.putClientProperty("JDesktopPane.dragMode", "outline");
       
       recentSession.add(clearRecentSession);
       recentSession.addSeparator();
       
       mainMenu.add(openNew);
       mainMenu.add(openExist);
       mainMenu.add(saveSession);
       mainMenu.addSeparator();
       mainMenu.add(recentSession);

//       recentSession.addMenuListener(new MenuListener()
//       {
//    	   public void menuCanceled(MenuEvent e) {}
//    	   public void menuDeselected(MenuEvent e){}
//    	   public void menuSelected(MenuEvent e)
//    	   {
    		  
//    		 -----to save this file path in the recent session file
    	     	 File recentFile  = new File("RecentSession.txt");
    	     	 boolean existsOFRecent = (recentFile).exists();
    	     	 String sLine1 ="" ,sLine2 ="";   
    	     	 try{
    	     	 if(existsOFRecent)
    	     	 {//File exists
    	  		    	BufferedReader br = new BufferedReader(new FileReader(recentFile));
    	  		    	do
    	  		    	{
    	  		    		sLine1 = br.readLine();
    	  		    		if(sLine1 != null)
    	  		    		{
    	  		    		 JMenuItem menuitem = new JMenuItem(sLine1);
    	  		    		 menuitem.addActionListener(new ActionListener(){
    	  		    			 public void actionPerformed(ActionEvent e)
    	  		    			 {
    	  		    				 JMenuItem m = (JMenuItem)e.getSource();
    	  		    				 openSession(new File(m.getText()));
    	  		    			 }
    	  		    		 });
    	  		    		 
    	  		    		 recentSession.add(menuitem);
    	  		    		}
    	  		    	}while(sLine1 != null);
    	     	 }//end of if
    	     	 }catch(Exception ex)
    	     	 {
    	     		 
    	     	 }
//    	   }
//       });
       

       aboutMenu.add(about);
       
       ThemeMenu.add(theme1);
       ThemeMenu.add(theme2);
       ThemeMenu.add(theme3);
       ThemeMenu.add(theme4);
       ThemeMenu.add(theme5);
       ThemeMenu.add(theme6);
       ThemeMenu.add(theme7);
       ThemeMenu.add(theme8);
       
       menuBar.add(mainMenu);
       menuBar.add(ThemeMenu);
       menuBar.add(aboutMenu);
       setJMenuBar(menuBar);
       
       this.getContentPane().setLayout(new BorderLayout());
       this.getContentPane().add(desktop,BorderLayout.CENTER);
      // this.getContentPane().add(buttonBar,BorderLayout.NORTH);
        
       //the window of the applicatio will assign it hieght and width to be as the width and the height of the screen...with some margin variable
        GraphicsEnvironment env =
            GraphicsEnvironment.getLocalGraphicsEnvironment();
          /*
            The next line determines if the   taskbar (win) is covered
            if unremarked, the task will not be covered by
            the maximized JFRAME.
          */
          this.setMaximizedBounds(env.getMaximumWindowBounds());
          this.setExtendedState(this.getExtendedState() | MAXIMIZED_BOTH);
          this.setSize(new Dimension(env.getMaximumWindowBounds().width-margin,env.getMaximumWindowBounds().height-margin));
          //---------------------------------------------------------------------------------------------------------------
    }//end of constructor
	
	//-------------------------
	
	void saveSessions()
	{
		
		VisChainerMain frame  = (VisChainerMain)desktop.getSelectedFrame();
		BufferedWriter output,output2;
		JFileChooser fc = new JFileChooser();
//		Show dialog; this method does not return until dialog is closed
    	fc.setDialogTitle("Choose the Directory....... ");
    	while(frame != null)
    	{
    	fc.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
    	
    	int returnVal =  fc.showSaveDialog(VisChainer.this);
        String s="";
        
        if (returnVal == JFileChooser.APPROVE_OPTION) 
 	   {  
         try 
             { 
        	 s = (String)JOptionPane.showInputDialog(VisChainer.this,"Write The Name of file : ","Save As........ ",JOptionPane.QUESTION_MESSAGE,
 	                    null,
 	                    null,
 	                    ""+frame.getTitle());
        	 
        	 boolean exists = (new File(fc.getSelectedFile().getCanonicalFile()+fileDash+s+".vic")).exists();
        	 
        	 if(exists)
        	 {
        		 int n = JOptionPane.showConfirmDialog(
        				    VisChainer.this,
        				    "The file exist,Do you want to replace it?",
        				    "Message",
        				    JOptionPane.YES_NO_CANCEL_OPTION);
        		 if(n == JOptionPane.CANCEL_OPTION || n == JOptionPane.CLOSED_OPTION)
        		 {
        			 JOptionPane.showMessageDialog(VisChainer.this,"The Saving operation canceled by the user","Message",JOptionPane.INFORMATION_MESSAGE);
        			 break;
        		 }
        		 if(n == JOptionPane.NO_OPTION)
        			 continue;
        		 
        	 }
        	 
        	 
        	 //-----to save this file path in the recent session file
        	 File recentFile  = new File("RecentSession.txt");
        	 boolean existsOFRecent = (recentFile).exists();
        	 String sLine1 ="" ,sLine2 ="";   
        	 if(existsOFRecent)
        	 {//File exists
			    	BufferedReader br = new BufferedReader(new FileReader(recentFile));
			    	do
			    	{
			    		sLine1 = br.readLine();
			    		if(sLine1 != null)
			    			sLine2+=sLine1+"\n";
			    	}while(sLine1 != null);
			    	output2= new BufferedWriter( new FileWriter(recentFile));
    		 		output2.write(sLine2);
    		 		
    		 		output2.write(fc.getSelectedFile().getCanonicalFile()+fileDash+s+".vic");
    		 		output2.close();
			    } 
			    else 
			    {
			        // File  does not exist
			    	output2= new BufferedWriter( new FileWriter(recentFile));
			    	output2.write(fc.getSelectedFile().getCanonicalFile()+fileDash+s+".vic");
			    	
			    	output2.close();

			    }
        	 
        	 
        	 //if the file doesn't exist, or exist and the user choose to replace the file 
        	 output= new BufferedWriter( new FileWriter(fc.getSelectedFile().getCanonicalFile()+fileDash+s+".vic"));
        	 //-----------To write in the file
        	 output.write((String)frame.saveSessionArr_.get(0)+"\n");
        	 for(int i=1;i<frame.saveSessionArr_.size();i++)
        	 {
        		 output.write("A,"+(String)frame.saveSessionArr_.get(i)+"\n");
        	 }
        	 for(int i=1;i<frame.saveSessionArr.size();i++)
        	 {
        		 output.write("B,"+(String)frame.saveSessionArr.get(i)+"\n");
        	 }
        	 //-------------
        	 output.close();
        	 break;
        	 
        	 }	
        	 catch(Exception ex)
      	    {
      	    JOptionPane.showMessageDialog(VisChainer.this,""+ex.toString(),"Error",JOptionPane.ERROR_MESSAGE);
      	    break;
      	    }     
      	   //---------------------------------------------------------------------------------------------------
         }
         else
         {
         	JOptionPane.showMessageDialog(VisChainer.this,"You don't select any files");
         	break;
         } 
    	}//end of while
	}//end of method
	
	void openSession(File openedFile)
	{
		//the array list to save the index of profiles objects which will draw in new window
		ArrayList indexArr1 = new ArrayList();
		ArrayList indexArr2 = new ArrayList();
		
		BufferedReader br = null;
		
		   
	     //create a buffered reader to read the sequence file specified by File Chooser Dialog 
	     try
	      {
	       br = new BufferedReader(new FileReader(openedFile));
	       //create the object of the session frame and make it visible
	       String lineString="";
	       
	       //1st line in the file contains the title of the frame
	       lineString = br.readLine();
	       
	       VisChainerMain frame = new VisChainerMain(lineString,VisChainer.this);
    	   //add it to dektopPane object and make appear in the front of the view
	       frame.setVisible(true);
		   desktop.add(frame);
		   frame.moveToFront();
		   
		   //----to don't let him ask about the stc file
		   frame.flag_openStcfile = false;
		   
		   while(lineString != null)
	       {
	    	   lineString = br.readLine();
	    	 if(lineString != null)
	    	 {
	    		
	    		 StringTokenizer st = new StringTokenizer(lineString,",");
	    		 String s0 = st.nextToken();
	    		 if(s0.equalsIgnoreCase("A"))
	    		 {
	    			 String s1= st.nextToken();
	    			 if(s1.equalsIgnoreCase( "0"))
	    			 {
	    				 //open log file
	    				 ProcessingFiles profiles = new ProcessingFiles(frame);
	    				 profiles.openLogForopensessionMethod(st.nextToken());
	    				 continue;
	    				 
	    			 }//end log file
	    			 
	    			 if(s1.equalsIgnoreCase("1"))
	    			 {
	    				 //stc file
	    				 frame.flag_openStcfile = false;
	    				 String path=st.nextToken();
	    				 BufferedReader brstc = null;
	 		            try 
	 		            {  
	 		        			//create a buffered reader to read the sequence file specified by File Chooser Dialog 

	 		        		brstc = new BufferedReader(new FileReader(path));
	 		        		//repalce the arraylist of tabs by useing string tokenizer
	 		        		StringTokenizer dataFirstLine = new StringTokenizer(brstc.readLine());
	 		        		
	 		        		int numOfGenomes=Integer.parseInt(dataFirstLine.nextToken());
	 		        		
	 		        		if(frame.num != numOfGenomes)
	 		        		{	
	 		        			int n2 = JOptionPane.showConfirmDialog(
	 		        					frame, "The number of genomes in the statistic file is different"+frame.num+"  "+numOfGenomes+" \n from which has been in Fragment file. Do wnat to replace it? ",
	 		                  	"Question",
	 		                  	JOptionPane.YES_NO_OPTION);
	 		                    
	 		                	if (n2 == JOptionPane.YES_OPTION) 
	 		                	{
	 		                		frame.num = numOfGenomes;
	 		                	}
	 		              }
	 		        		
	 		        		//maxEndInFragments.setlength(num);--length will set here , it will be set in open fragment file method in profiles ,,,,,,,because it " openStcFile" call after it
	 		        		frame.numOfFragments=Integer.parseInt(dataFirstLine.nextToken());
	 		        		frame.maxLengthOfInterval=Integer.parseInt(dataFirstLine.nextToken());
	 		        		frame.minLengthOfInterval=Integer.parseInt(dataFirstLine.nextToken());
	 		        		//-- to get the max end of fragments 
	 		        		StringTokenizer dataSecondLine = new StringTokenizer(br.readLine());
	 		        		for(int i = 0; i< frame.num ; i++)
	 		        		{
	 		        			frame.maxEndInFragments.set(i,Integer.parseInt(dataSecondLine.nextToken()));	
	 		        		}
	 		        			
	 		        	    
	 		        	  frame.saveSessionArr_.add("1,"+path);
	 		        	  brstc.close();
	 		            }//end of try read line
	 		            catch(Exception e)
	 		            {
	 		            	JOptionPane.showMessageDialog(frame,"Please check the file.\n or send this exception to the Auhtor :"+e.toString(),"Error",JOptionPane.WARNING_MESSAGE);
	 		            }
	 		            continue;
	    			 }//end of stc file
	    			 
	    			 if(s1.equalsIgnoreCase( "3"))
	    			 {
	    				 //the the number show the object of profiles will draw in respect to which genomes
	    				 indexArr1.add(st.nextToken());
	    				 // the index of profiles objects which will draw in new window	 
	    				 indexArr2.add(st.nextToken());
	    				 
	    				 continue;
	    			 }
	    			
	    		 }
	    		 else
	    		 {
	    			 String s1 =st.nextToken();
	    			 if( s1.equalsIgnoreCase( "0"))
	    			 {
	    				 //open seqence file
	    				 String path = st.nextToken();
	    				 ProcessingFiles proFiles = new ProcessingFiles(frame);
	                	 boolean openFlag =proFiles.openSequenceMethod(new File(path));
	                	 if(openFlag)
	                	 {
	                	 //to pass the length of the genomes to the projections and the sequences
	                	 frame.passLists(-1,proFiles);
	                	 frame.saveSessionArr.add("0,"+path);
	                	 }
	                	 continue;
	    			 }
	    			 
	    			 if(s1.equalsIgnoreCase( "1"))
	    			 {
	    				 //open file
	    				 String s2 = st.nextToken();
	    				 /////forward 
	    				 if(s2.equalsIgnoreCase("1"))
		    			 {
		    				 //open fragment file
	    					 String path = st.nextToken();
	    					 ProcessingFiles proFiles = new ProcessingFiles(frame);
	                      	 frame.fragmentDraw.setSelected(proFiles.openFragmentMethod(new File(path),1,proFiles.arrToDrawTheFragments));
	                      	 boolean  overLayFlag = true;
	                      	 int forNonoverlay = 0;
	                      	 for(int i = 0; i<indexArr1.size();i++)
	                      	 {
	                      		 if(frame.proFilesArr.size() == Integer.parseInt((String)indexArr2.get(i)) )
	                      		 {
	                      			 overLayFlag = false;
	                      			 forNonoverlay = Integer.parseInt((String)indexArr1.get(i));
	                      		 }
	                      	 }
	                      	 frame.passListsForOpenSessionMethod(1,proFiles,overLayFlag, forNonoverlay);
                     		 frame.toWriteInTheOpenedFilesList("F.Frag. :"+new File(path).getName());
                     		frame.saveSessionArr.add("1,1,"+path);
	    					 continue;
		    			 }
	    				 
	    				 if(s2.equalsIgnoreCase( "7"))
		    			 {
		    				 //open chain file
	    					 String path = st.nextToken();
	    					 ProcessingFiles proFiles = new ProcessingFiles(frame);
	                      	 frame.chainFileDraw.setSelected(proFiles.openFragmentMethod(new File(path),7,proFiles.arrToDrawTheChainesFile));
	                      	 boolean  overLayFlag = true;
	                      	 int forNonoverlay = 0;
	                      	 for(int i = 0; i<indexArr1.size();i++)
	                      	 {
	                      		 if(frame.proFilesArr.size() == Integer.parseInt((String)indexArr2.get(i)) )
	                      		 {
	                      			 overLayFlag = false;
	                      			 forNonoverlay = Integer.parseInt((String)indexArr1.get(i));
	                      		 }
	                      	 }
	                      	 frame.passListsForOpenSessionMethod(7,proFiles,overLayFlag, forNonoverlay);
                     		 frame.toWriteInTheOpenedFilesList("F.Chain. :"+new File(path).getName());
                     		 frame.saveSessionArr.add("1,7,"+path);
	    					 continue;
		    			 }
	    				 if(s2.equalsIgnoreCase( "2"))
		    			 {
		    				 //open ccn file
	    					 String path = st.nextToken();
	    					 ProcessingFiles proFiles = new ProcessingFiles(frame);
	                      	 frame.chainDraw.setSelected(proFiles.openFragmentMethod(new File(path),2,proFiles.arrToDrawTheChaines));
	                      	 boolean  overLayFlag = true;
	                      	 int forNonoverlay = 0;
	                      	 for(int i = 0; i<indexArr1.size();i++)
	                      	 {
	                      		 if(frame.proFilesArr.size() == Integer.parseInt((String)indexArr2.get(i)) )
	                      		 {
	                      			 overLayFlag = false;
	                      			 forNonoverlay = Integer.parseInt((String)indexArr1.get(i));
	                      		 }
	                      	 }
	                      	 frame.passListsForOpenSessionMethod(2,proFiles,overLayFlag, forNonoverlay);
                     		 frame.toWriteInTheOpenedFilesList("F.Ccn. :"+new File(path).getName());
                     		 frame.saveSessionArr.add("1,2,"+path);
	    					 continue;
		    			 }
	    				 if(s2.equalsIgnoreCase( "3"))
		    			 {
		    				 //open cluster file
	    					 String path = st.nextToken();
	    					 ProcessingFiles proFiles = new ProcessingFiles(frame);
	                      	 frame.clusterDraw.setSelected(proFiles.openFragmentMethod(new File(path),3,proFiles.arrToDrawTheClusters));
	                      	 boolean  overLayFlag = true;
	                      	 int forNonoverlay = 0;
	                      	 for(int i = 0; i<indexArr1.size();i++)
	                      	 {
	                      		 if(frame.proFilesArr.size() == Integer.parseInt((String)indexArr2.get(i)) )
	                      		 {
	                      			 overLayFlag = false;
	                      			 forNonoverlay = Integer.parseInt((String)indexArr1.get(i));
	                      		 }
	                      	 }
	                      	 frame.passListsForOpenSessionMethod(3,proFiles,overLayFlag, forNonoverlay);
                     		 frame.toWriteInTheOpenedFilesList("F.Cst. :"+new File(path).getName());
                     		 frame.saveSessionArr.add("1,3,"+path);
	    					 continue;
		    			 }
	    				 /////Reverse
	    				 if(s2.equalsIgnoreCase( "4"))
		    			 {
		    				 //open rev fragment file
	    					 String path = st.nextToken();
	    					 ProcessingFiles proFiles = new ProcessingFiles(frame);
	                      	 frame.revFragmentDraw.setSelected(proFiles.openFragmentMethod(new File(path),4,proFiles.arrToDrawTheRevFragments));
	                      	 boolean  overLayFlag = true;
	                      	 int forNonoverlay = 0;
	                      	 for(int i = 0; i<indexArr1.size();i++)
	                      	 {
	                      		 if(frame.proFilesArr.size() == Integer.parseInt((String)indexArr2.get(i)) )
	                      		 {
	                      			 overLayFlag = false;
	                      			 forNonoverlay = Integer.parseInt((String)indexArr1.get(i));
	                      		 }
	                      	 }
	                      	 frame.passListsForOpenSessionMethod(4,proFiles,overLayFlag, forNonoverlay);
                     		 frame.toWriteInTheOpenedFilesList("R.Frag. :"+new File(path).getName());
                     		 frame.saveSessionArr.add("1,4,"+path);
	    					 continue;
		    			 }
	    				 
	    				 if(s2.equalsIgnoreCase( "8"))
		    			 {
		    				 //open rev chain file
	    					 String path = st.nextToken();
	    					 ProcessingFiles proFiles = new ProcessingFiles(frame);
	                      	 frame.revChainFileDraw.setSelected(proFiles.openFragmentMethod(new File(path),8,proFiles.arrToDrawTheRevChainesFile));
	                      	 boolean  overLayFlag = true;
	                      	 int forNonoverlay = 0;
	                      	 for(int i = 0; i<indexArr1.size();i++)
	                      	 {
	                      		 if(frame.proFilesArr.size() == Integer.parseInt((String)indexArr2.get(i)) )
	                      		 {
	                      			 overLayFlag = false;
	                      			 forNonoverlay = Integer.parseInt((String)indexArr1.get(i));
	                      		 }
	                      	 }
	                      	 frame.passListsForOpenSessionMethod(8,proFiles,overLayFlag, forNonoverlay);
                     		 frame.toWriteInTheOpenedFilesList("R.Chn. :"+new File(path).getName());
                     		 frame.saveSessionArr.add("1,8,"+path);
	    					 continue;
		    			 }
	    				 if(s2.equalsIgnoreCase("5"))
		    			 {
		    				 //open rev ccn file
	    					 String path = st.nextToken();
	    					 ProcessingFiles proFiles = new ProcessingFiles(frame);
	                      	 frame.revChainDraw.setSelected(proFiles.openFragmentMethod(new File(path),5,proFiles.arrToDrawTheRevChaines));
	                      	 boolean  overLayFlag = true;
	                      	 int forNonoverlay = 0;
	                      	 for(int i = 0; i<indexArr1.size();i++)
	                      	 {
	                      		 if(frame.proFilesArr.size() == Integer.parseInt((String)indexArr2.get(i)) )
	                      		 {
	                      			 overLayFlag = false;
	                      			 forNonoverlay = Integer.parseInt((String)indexArr1.get(i));
	                      		 }
	                      	 }
	                      	 frame.passListsForOpenSessionMethod(5,proFiles,overLayFlag, forNonoverlay);
                     		 frame.toWriteInTheOpenedFilesList("R.Ccn. :"+new File(path).getName());
                     		 frame.saveSessionArr.add("1,5,"+path);
	    					 continue;
		    			 }
	    				 if(s2.equalsIgnoreCase("6"))
		    			 {
		    				 //open cluster file
	    					 String path = st.nextToken();
	    					 ProcessingFiles proFiles = new ProcessingFiles(frame);
	                      	 frame.revClusterDraw.setSelected(proFiles.openFragmentMethod(new File(path),6,proFiles.arrToDrawTheRevClusters));
	                      	 boolean  overLayFlag = true;
	                      	 int forNonoverlay = 0;
	                      	 for(int i = 0; i<indexArr1.size();i++)
	                      	 {
	                      		 if(frame.proFilesArr.size() == Integer.parseInt((String)indexArr2.get(i)) )
	                      		 {
	                      			 overLayFlag = false;
	                      			 forNonoverlay = Integer.parseInt((String)indexArr1.get(i));
	                      		 }
	                      	 }
	                      	 frame.passListsForOpenSessionMethod(8,proFiles,overLayFlag, forNonoverlay);
                     		 frame.toWriteInTheOpenedFilesList("R.Cst. :"+new File(path).getName());
                     		 frame.saveSessionArr.add("1,6,"+path);
	    					 continue;
		    			 }
	    			 }//end of s1 == 1 //file
	    			 if(s1.equalsIgnoreCase("2"))
	    			 {
	    				 //open multiple genomes files
	    				 String s2 = st.nextToken();
	    				 
	    				 String s="";
	    				 JCheckBox cb=new JCheckBox();
	    	             JCheckBox cbr= new JCheckBox();
	    	             
	    				 if(s2.equalsIgnoreCase("1"))
		    			 {
		    				 //open fragment file
	    					 s="";
	             			 cb = frame.fragmentDraw;
	             			 cbr = frame.revFragmentDraw;
	    					 
		    			 }
	    				 
	    				 if(s2.equalsIgnoreCase("7"))
		    			 {
		    				 //open chain file
	    					 s=".chn";
	             			 cb = frame.chainFileDraw;
	             			 cbr= frame.revChainFileDraw;
	    					 
		    			 }
	    				 if(s2.equalsIgnoreCase("2"))
		    			 {
		    				 //open ccn file
	    					 s=".ccn";
	             			 cb = frame.chainDraw;
	             			 cbr = frame.revChainDraw;
	    					 
		    			 }
	    				 if(s2.equalsIgnoreCase("3"))
		    			 {
		    				 //open cluster file
	    					 s=".cst";
	             			 cb = frame.clusterDraw;
	             			 cbr = frame.revClusterDraw;
	    					 
		    			 }
	    				 
	    				 
	    				 ProcessingFiles proFiles = new ProcessingFiles(frame);
	    				 boolean openedFlag = proFiles.openFileOfMultipleGenomesToSetLength(s,s);
	    				 cb.setSelected(proFiles.openFragmentsOfMultipleGenomes(s,s));
	                  	 cbr.setSelected(cb.isSelected());
	                  	 //flag to :1.to make multiple files over laid 
	                  	 //2. to set the check box in the frames for the multiple genomes
	                  	frame.allGenomesFlag=true;	
	                  	 
	                  	if(s==""&& cb.isSelected())
	                 	  {
	                  		 
	                  		frame.passLists(1,proFiles);
	                  		frame.toWriteInTheOpenedFilesList("Fragments files for Multiple genomes");
	                  		frame.saveSessionArr.add("2,1,M");
	                  		
	                 	  }	
	               		if(s==".chn"&& cb.isSelected())
	                  		 {
	               			
	               			frame.passLists(7,proFiles);
	               			frame.toWriteInTheOpenedFilesList("Chain files for Multiple genomes");
	               			frame.saveSessionArr.add("2,7,M");
	               			
	                  		 }
	               		if(s==".ccn"&& cb.isSelected())
	                  		 {
	               			frame.passLists(2,proFiles);
	               			frame.toWriteInTheOpenedFilesList("Compact Chain files for Multiple genomes");
	               			frame.saveSessionArr.add("2,2,M");
	               			
	                  		 }
	               		if(s==".cst"&& cb.isSelected())
	                  		 {	
	               			frame.passLists(3,proFiles);
	               			frame.toWriteInTheOpenedFilesList("Cluster files for Multiple genomes");
	               			frame.saveSessionArr.add("2,3,M");
	                  		 }
	                  	 
	               		frame.allGenomesFlag=false;

	               		continue;
	    			 }//end of if s1 == 2 //multiple genomes
	    			 
	    			 if(s1.equalsIgnoreCase("3"))
	    			 {
	    				 //empty profiles
	    				 ProcessingFiles profiles = new ProcessingFiles(frame);
	                	 frame.proFilesArr.add(profiles);
	                	 frame.saveSessionArr.add("3,Delete");
	    			 }
	    		 }//end of else
	    	 }//end of if lineString != null
	    	 
			}//end of while
	       
		    br.close();
	       
	       
	      }
	     catch(Exception ex)
	      {
	    	 JOptionPane.showMessageDialog(VisChainer.this,"Please check the file.\n or send this exception to the Auhtor :"+ex.toString(),"Error",JOptionPane.WARNING_MESSAGE);
	      }
		  
		   
	}
//	------------------------- MAIN ----------------------------------------------
    public static void main(String[] args) 
    {
    //--- Change the look and feel of our window ************************************************//////////
	JDialog.setDefaultLookAndFeelDecorated(true);
	JFrame.setDefaultLookAndFeelDecorated(true);
    Toolkit.getDefaultToolkit().setDynamicLayout(true);
	 	try {
	 		 //javax.swing.plaf.metal.MetalLookAndFeel.setCurrentTheme( new javax.swing.plaf.metal.);
	 		com.jgoodies.looks.plastic.PlasticLookAndFeel.setPlasticTheme(new com.jgoodies.looks.plastic.theme.SkyBluer());
          // UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
	 		 UIManager.setLookAndFeel(new com.jgoodies.looks.plastic.PlasticXPLookAndFeel());
	 		
        }  
        catch ( Exception e ) 
        {
           // System.out.println ("Unexpected error. \nProgram Terminated");
            e.printStackTrace();
           // System.exit(0);
        }
 
        //the main	
        VisChainer frame = new VisChainer();
        frame.setVisible(true);
    }//end of main
}//end of the class

//------------------
/**
 * This class listens for UISwitches, and updates a given component.
 *
 * @version 1.6 12/03/01
 * @author Steve Wilson
 */
 class UISwitchListener implements PropertyChangeListener {
   JComponent componentToSwitch;

   public UISwitchListener(JComponent c) {
       componentToSwitch = c;
   }

   public void propertyChange(PropertyChangeEvent e) {
       String name = e.getPropertyName();
	if (name.equals("lookAndFeel")) {
	    SwingUtilities.updateComponentTreeUI(componentToSwitch);
	    componentToSwitch.invalidate();
	    componentToSwitch.validate();
	    componentToSwitch.repaint();
	}
   }
}
