/*
*SequenceFrame.java
*
*To Show the sequence when selected from the list in main frame
*and contians text area to display the sequence and sequence panel 
*can be used in future to display other information
*
*
*
*
*
*Asem A. Othman
**/

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;


import org.biojava.bio.seq.*;
import org.biojava.bio.gui.sequence.*;


class SequenceFrame extends JFrame
{

	/**
	 * 
	 * @uml.property name="seqText"
	 * @uml.associationEnd multiplicity="(1 1)"
	 */
	JTextArea seqText;

	/**
	 * 
	 * @uml.property name="splitPane"
	 * @uml.associationEnd multiplicity="(1 1)"
	 */
	JSplitPane splitPane;

	/**
	 * 
	 * @uml.property name="panel"
	 * @uml.associationEnd multiplicity="(1 1)"
	 */
	SequencePanel panel;

    
	public SequenceFrame(Sequence seq)
	{
		super(seq.getName()+"  "+seq.getURN());
		addWindowListener(new WindowAdapter() 
		{
            public void windowClosing(WindowEvent e) 
            {
            	dispose();
            	System.gc();
            }
        });
        
        init(seq);
	}
	void init(Sequence seq)
    {
    	seqText = new JTextArea(seq.getName());
    	seqText.setEditable(false);
    	seqText.setLineWrap(true);
    	JScrollPane listScrollPane = new JScrollPane(seqText);
    	 //the panel where the fragments will draw
        panel = new SequencePanel();
        JScrollPane fragmentsScrollPane = new JScrollPane();
        
        fragmentsScrollPane.getViewport().setView(panel);
        
        //Create a split pane with the two scroll panes in it
        splitPane = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT,
                                   listScrollPane, fragmentsScrollPane);
        splitPane.setOneTouchExpandable(true);
        splitPane.setDividerLocation(150);
        
        
        //Provide minimum sizes for the two components in the split pane
        Dimension minimumSize = new Dimension(100, 50);
        listScrollPane.setMinimumSize(minimumSize);
        fragmentsScrollPane.setMinimumSize(minimumSize);

        //Provide a preferred size for the split pane
        splitPane.setPreferredSize(new Dimension(400, 200));
        
        getContentPane().add(splitPane);
        pack();	
    }
}
