/*
*ProcessingFiles.java
*
*to process the files which will open 
*and contians the array list of fragment position which will draw by the panel
*Asem A. Othman
*/

import java.io.*;
import java.util.*;

import javax.swing.*;


import org.biojava.bio.*;
import org.biojava.bio.seq.*;
import org.biojava.bio.seq.io.*;


//-- extend from jcomponent only for the file chooser in it
public class ProcessingFiles extends JComponent

{
//*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*      Member Variables    -*-*-*-*-*-*-*-*-*-*-*-*-*-*-
	
	// -------------------------------------------------
    public  float[] arrOfFragmentScores ;
    public float[]  arrOfRevFragmentScores;
    
    public float[]  arrOfFragmentChainScores;
    public int[]  arrOfFragmentChainID;
    
    public float[]  arrOfRevFragmentChainScores;
    public int[]  arrOfRevFragmentChainID;
    
    public int[] startIndexOfChaines;
    public int[] startIndexOfRevChaines;

    public  float[] arrOfCcnScores ;
    public float[]  arrOfRevCcnScores;
    
	//only temp one,used in different functions
	//public  MyFragmentTempArrayList arrOfFragments;
	//the array lists of the fragment positions , which will draw in the projections
	public MyFragmentPosArrayListToDraw arrToDrawTheFragments = new MyFragmentPosArrayListToDraw();
	public MyFragmentPosArrayListToDraw arrToDrawTheChainesFile = new MyFragmentPosArrayListToDraw();
	public MyFragmentPosArrayListToDraw arrToDrawTheChaines = new MyFragmentPosArrayListToDraw();
	public MyFragmentPosArrayListToDraw arrToDrawTheClusters = new MyFragmentPosArrayListToDraw();
	
	public MyFragmentPosArrayListToDraw arrToDrawTheRevFragments = new MyFragmentPosArrayListToDraw();
	public MyFragmentPosArrayListToDraw arrToDrawTheRevChainesFile = new MyFragmentPosArrayListToDraw();
	public MyFragmentPosArrayListToDraw arrToDrawTheRevChaines = new MyFragmentPosArrayListToDraw();
	public MyFragmentPosArrayListToDraw arrToDrawTheRevClusters = new MyFragmentPosArrayListToDraw();

	
	//--file chooser which will appear when open file
	JFileChooser fc = new JFileChooser();

	//--array list contians array for each genomes, these arrays is 2D array sontians the ranges of the reverse location for each genome
	//this important when open multiple files ....to know the reverse locations
	public ArrayList arrOfReverseLocations = new ArrayList();

	
	//flag to know if this object draw in new window or overlaid 
	public boolean forNewWindow = false;
	
	//keep the file path which opened by the object of this class...
	public String filePath = "";

	//refrence to the parent ...which is the session frame
	//to know the parent when open the file chooser dialog
	//and to get the important variables of the comparison (i.e. the number of genomes)
	VisChainerMain parent;

	
	//the size of the buffer ....which used when read file
	int sizeOfBuffer = 4194304;
	
	//to count the chain id in case of reading multiple-genomes files
	//and it only intialize by 0 and increment for all the files
	int chainIdCounterForMultipleGenomes = 0;
	/*
	 * the constractor
	 * param> the parent ...the session frame
	 */
	
	
	
	public ProcessingFiles(VisChainerMain p)
	{
		parent =p;
	}//end of constructor
//*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*        Functions      *-*-*-*-*-*-*-*-*-*-*-*-*-*
	//--------- to open the file contians sequence ------------
	// even if the file contian more than one sequence
	public  boolean openSequenceFile()
	{
		
		
		fc.setCurrentDirectory(new File(parent.pathDir));
		
       int returnVal = fc.showOpenDialog(parent);
	   if (returnVal == JFileChooser.APPROVE_OPTION) 
	   {   
		   parent.pathDir = fc.getCurrentDirectory().getPath();
      	 return openSequenceMethod(fc.getSelectedFile());
       }
       else 
     	{
     			JOptionPane.showMessageDialog(parent,"You don't select any files");
     			return false;
     	}
	}//end of openSequenceFile
	
	//method where the file opned
	boolean openSequenceMethod(File openedFile)
	{
//		refrence for the sequence which will open
		Sequence seq;
		// to read sequences from the file"if the file contian more than one sequence"
		SequenceIterator sequences;
		BufferedReader br = null;
		
//		create a buffered reader to read the sequence file specified by File Chooser Dialog 
	       try
	       {
	        br = new BufferedReader(new FileReader(openedFile));
	       }
	       catch(Exception e)
	       {
	       	JOptionPane.showMessageDialog(parent,e,"Error",JOptionPane.ERROR_MESSAGE);
	       	return false;
	       }
	       
	       try{    
	        sequences = (SequenceIterator)SeqIOTools.fileToBiojava("fasta","dna", br);
	        
	          while(sequences.hasNext())
	           {
	      		try 
	      		{
	            seq = sequences.nextSequence();
	            parent.arrOfSequences.add(seq);
	            
	            //to add the sequence to the main parent
	            Sequence s = (Sequence)parent.arrOfSequences.get(parent.numberOfOpenedSeq);
	            parent.arrOfSeqName.add((String)(s.getName()));
	            parent.seqList.setListData(parent.arrOfSeqName.toArray());
	            parent.seqList.repaint();   
	            parent.numberOfOpenedSeq++;
	            
	            
	            //get the length from the sequence if it opened after open file"fragment or chain......"
	           //if this the sequence opened first nothing will happen until , open file it will get the sequence length
	            long seqLength = seq.length();
	            if(!parent.flagForMaxEndArr)
	            {
	            	parent.maxEndInFragments.set(parent.numberOfOpenedSeq,seqLength);
	            }
	            br.close();
	            
	     		}
	      		catch (BioException ex) 
	      		{
	             //not in good format
	      			JOptionPane.showMessageDialog(parent,"not in good format.","Error",JOptionPane.ERROR_MESSAGE);
	      			parent.toWriteInTheConsoleList( ex.toString());
	      			return false;
	              
	            }
	      		catch (Exception  ex) 
	      		{
	             //request for more sequence when there isn't any
	      			parent.toWriteInTheConsoleList( ex.toString());
	      			JOptionPane.showMessageDialog(parent,"request for more sequence when there isn't any","Error",JOptionPane.ERROR_MESSAGE);
	      			return false;
	            }
	      		
	           }//end of while
	          return true;
	        }//end of try reading the sequenceItreator
	        catch (BioException ex) 
	        {
	          //not in GenBank format
	        		parent.toWriteInTheConsoleList( ex.toString());
	        		JOptionPane.showMessageDialog(parent,"not in good format","Error",JOptionPane.ERROR_MESSAGE);
	        		return false;
	         }
	}
//**************************************************************************************************************
	/*
	 * openFragmentFile method
	 * param>the type of the file as number
	 * 1->fragment
	 * 2->ccn file
	 * 3->cluster file
	 * 4->rev fragment
	 * 5->rev ccn 
	 * 6->rev cluster
	 * 7->chain file
	 * 8->rev chain file
	 * param>the array list it will fill from the file
	 * 
	 * return>flag if the file opened without exception or wrong format
	 */
//------------------------------------------------------------------open Files -----------------------------------------
	public  boolean openFragmentFile(int ext,MyFragmentPosArrayListToDraw arrList)
	{
		
		fc.setCurrentDirectory(new File(parent.pathDir));
        int returnVal = fc.showOpenDialog(parent);		
        
	    if (returnVal == JFileChooser.APPROVE_OPTION) 
	   {  
	    	parent.pathDir = fc.getCurrentDirectory().getPath();
        return openFragmentMethod(fc.getSelectedFile(), ext, arrList);
        
        }//end if  if (returnVal == JFileChooser.APPROVE_OPTION) 
        else 
     	{
     	  JOptionPane.showMessageDialog(parent,"You don't select any files");
          return false;
     	}
     }//end function 
	
	public boolean openFragmentMethod(File openedFile,int ext,MyFragmentPosArrayListToDraw arrList)
	{
		String lineString="";
		//arrOfFragments = new MyFragmentTempArrayList();
		byte[] readMap;
		char c;
		char[] myString = new char[1500];
		BufferedReader br0 = null;//to read the file to set the legth of the arary
		try 
        { 
    	
    	int countOfFragments = 0 ;
    	int countOfChaines = 0;
    	long startTime =System.currentTimeMillis();
    	//---------------------- to count the count of the fragment in file to set the length of the array
    	// create a buffered reader to read the sequence file specified by File Chooser Dialog 
  		br0 = new BufferedReader(new FileReader(openedFile));
  		//to keep the file path 
  		this.filePath= openedFile.getCanonicalPath();
  		if(filePath.length() > 30)
  		{
  			int indexof = filePath.indexOf(parent.parent.fileDash,20);
  			filePath ="..."+parent.parent.fileDash+ filePath.substring(indexof);
  		}
  		// to know which genomes are reverse if exit,,,to make transformation only to reverse
  		String transformString="";
		int index = filePath.lastIndexOf('.');
 		
 		if (index > 0 &&  index < filePath.length() - 1)
 			 transformString = filePath.substring(index+1).toLowerCase();
  		// ---------------------------------------------------------------------------------------------
 		
 		if(parent.openNewLog && transformString.contains("m") )
 		{
				JOptionPane.showMessageDialog(parent, "You must open info/log file , there is reverse fragments","Open Log File....",JOptionPane.INFORMATION_MESSAGE);
				ProcessingFiles proFiles1 = new ProcessingFiles(parent);
				boolean openNewLog1  = proFiles1.openLogFileForMultipleGenomes();
				if(openNewLog1)
				{
					//here add the profiles object which contian the information of the log file
					//parent.proFilesArr.add(proFiles1);
					parent.openNewLog = false;
				}
				else
					return false;
		}//end of if(openNewLog)
		
				
				
  		lineString = br0.readLine();
  		
  		if(ext != 3 && ext != 6)
		{//if not cluster file
        // to read the number of genomes from-----> #CHA 'num'
        
  		parent.num=Integer.parseInt(lineString.substring(lineString.indexOf("A")+2));
        lineString = br0.readLine();
        
       }//end if the file not cluster file
		else
		{
			lineString = br0.readLine();
			StringTokenizer str=new StringTokenizer(lineString);
			parent.num= str.countTokens();
		}//end else"if the file is cluster file"
  		
  		do
  		{
  			if(lineString.charAt(0)=='[')
  				countOfFragments++;
  			if(lineString.charAt(0)=='#')
  				countOfChaines++;
  			lineString = br0.readLine();
        }while(lineString != null);//end of while
  		br0.close();
  		
  		float elapsedTime = (float)( System.currentTimeMillis() -startTime)/1000F;
  		parent.toWriteInTheConsoleList("  \n  # of Fragments in this file is "+countOfFragments);

		
        //-----to intialize the max end fragment list
        //this list will be also get values when reading file 
        //because it usless to make another for loop agian on the fragment array 
        //to get max.
        if(parent.flagForMaxEndArr)
        {
        	parent.flagForMaxEndArr= false;
        	//will set legth only for one time ......here not in open stc file because this happen first and then see if the stc file will open or not
        	//and if it has not opened ,the array already has been fill with zeros and then with max length from the comparison between the intervals
        	parent.maxEndInFragments.setlength(parent.num);
        	for(int hh = parent.numberOfOpenedSeq ; hh< parent.num ; hh++ )
        	{
        		parent.maxEndInFragments.add(10);
        	}
        	//if there is any opened sequences
        	for(int hh =0 ; hh < parent.numberOfOpenedSeq ; hh++)
        	{
        		Sequence s =(Sequence)parent.arrOfSequences.get(hh);
        		parent.maxEndInFragments.set(hh,s.length());
        	}
    	}
        //---------------------------------
        //----- to open the statistic file if it doesn't open before or the sequences have didn't opened
        
        if(parent.numberOfOpenedSeq < parent.num && parent.flag_openStcfile)
		{
        	parent.flag_openStcfile = false;
			int n = JOptionPane.showConfirmDialog(
					parent, "You didn't open Sequence Would you like to open Statistic File? ",
	            "Question",
	            JOptionPane.YES_NO_OPTION);
	            
	        if (n == JOptionPane.YES_OPTION) 
	        {
	        	JFileChooser fc2 = new JFileChooser();
	        	  fc2.setDialogTitle("Open  Stc File  ");
	        	  fc2.setCurrentDirectory(new File(parent.pathDir));
	        	int returnVal0 = fc2.showOpenDialog(ProcessingFiles.this);
		        if(returnVal0 == JFileChooser.APPROVE_OPTION)
	            {
		        	parent.pathDir = fc2.getCurrentDirectory().getName();
	            	//--------------------------------------------- oprn Stc file -------------------------------------------------------
		        	BufferedReader br = null;
		            try 
		            {  
		        			//create a buffered reader to read the sequence file specified by File Chooser Dialog 
		        		br = new BufferedReader(new FileReader(fc2.getSelectedFile()));
		        		//repalce the arraylist of tabs by useing string tokenizer
		        		StringTokenizer dataFirstLine = new StringTokenizer(br.readLine());
		        		int numOfGenomes=Integer.parseInt(dataFirstLine.nextToken());
		        		if(parent.num != numOfGenomes)
		        		{	
		        			int n2 = JOptionPane.showConfirmDialog(
		        					parent, "The number of genomes in the statistic file is different"+parent.num+"  "+numOfGenomes+" \n from which has been assign from the opened file. Do wnat to replace it? ",
		                  	"Question",
		                  	JOptionPane.YES_NO_OPTION);
		                	if (n2 == JOptionPane.YES_OPTION) 
		                	{
		                		parent.num = numOfGenomes;
		                	}
		              }
		        		
		        		//maxEndInFragments.setlength(num);--length will set here , it will be set in open fragment file method in profiles ,,,,,,,because it " openStcFile" call after it
		        		parent.numOfFragments=Integer.parseInt(dataFirstLine.nextToken());
		        		parent.maxLengthOfInterval=Integer.parseInt(dataFirstLine.nextToken());
		        		parent.minLengthOfInterval=Integer.parseInt(dataFirstLine.nextToken());
		        		//-- to get the max end of fragments 
		        		StringTokenizer dataSecondLine = new StringTokenizer(br.readLine());
		        		for(int i = 0; i<parent. num ; i++)
		        		{
		        			parent.maxEndInFragments.set(i,Integer.parseInt(dataSecondLine.nextToken()));	
		        		}
		        	    br.close();
		        	    parent.saveSessionArr_.add("1,"+fc2.getSelectedFile().getPath());
		            }//end of try read line
		            catch(Exception e)
		            {
		            	JOptionPane.showMessageDialog(parent,"Please check the file.\n or send this exception to the Auhtor :"+e.toString(),"Error",JOptionPane.WARNING_MESSAGE);
		            }
	            }
	            else//if didn't select file
				{
				JOptionPane.showMessageDialog(parent,"You didn't select file.","Error",JOptionPane.ERROR_MESSAGE);
				}
	        }//end if if (n == JOptionPane.YES_OPTION)  
		}//end if(this.numberOfOpenedSeq < Fragment.num && this.flag_openStcfile)
        //----------to know the count of fragments
  		if(countOfFragments >= 0)
  		{//this.arrOfFragments.setlength(countOfFragments);
  		arrList.setlength(countOfFragments);
  		if(ext == 1)
  			arrOfFragmentScores = new float[countOfFragments];
  		if(ext == 4)
  		  arrOfRevFragmentScores = new float[countOfFragments]; 
  		
  		if(ext == 2)
  			arrOfCcnScores = new float[countOfFragments];
  		if(ext == 5)
  			arrOfRevCcnScores = new float[countOfFragments];
  		
  		if(ext == 7)
  		{
  			arrOfFragmentChainScores = new float[countOfChaines];
  			startIndexOfChaines = new int[countOfChaines];
  			arrOfFragmentChainID = new int[countOfFragments];
  		}
  		
  		if(ext == 8)
  		{
  			arrOfRevFragmentChainScores = new float[countOfChaines];
  			startIndexOfRevChaines = new int[countOfChaines];
  			arrOfRevFragmentChainID = new int[countOfFragments];
  		}
  		
  		}
  		
  		// --------------------------------------------------------------------------------------------------------------------------------------------------------------
  		//create a buffered reader to read the sequence file specified by File Chooser Dialog 
		// using memory mapping
  		int firstLine = 0;
  		int fileSize = (int)openedFile.length();
  		FileInputStream fis = new FileInputStream(openedFile);
         readMap= new byte[sizeOfBuffer];
         
        int lineCounter = 0;
        int n;
        float score=0;
        int chainIdCounter = 0;
    	int[] index1=new int[parent.num];//index of [
		int[] index2=new int[parent.num];//index of ,
		int[] index3 = new int[parent.num];//index of ]
		int counter1 =0,counter2=0,counter3=0;
        startTime =  System.currentTimeMillis();
        n = fis.read(readMap);
        do  {
        	int readMapIndex =0;
          // to read first line....
        	if(firstLine == 0)
        	{
        		firstLine++;
        	for (  readMapIndex = 0; readMapIndex < n; readMapIndex++) 
        	{
            if (readMap[readMapIndex] == '\n')
            {
              readMapIndex++;
            	break;
            }
        	}//end loop for line
        	}//end of if firstLine
        ////////////////////////////////////////////////////////////////
        	for (; readMapIndex < n; readMapIndex++) 
        	{
            if (readMap[readMapIndex] != '\n')
            {
            	c = (char)readMap[readMapIndex];
            	myString[lineCounter] = c;
            	if(c == '[')
            		{index1[counter1]=lineCounter;
            		counter1++;
            		}
            	if(c == ',')
            	{index2[counter2]=lineCounter;
        		counter2++;
        		}
            	if(c == ']')
            	{index3[counter3]=lineCounter;
        		counter3++;
        		}
            	lineCounter++;
            }
            else
            {
            	Fragment f=new Fragment();
            	f.fragmentsPos.setlength(parent.num);
            	if(myString[0] =='#')
            	{
            		score= Float.parseFloat(new String(myString,1,lineCounter-1));
            		if(ext == 7)
            		{
            			arrOfFragmentChainScores[chainIdCounter] = score;
            			startIndexOfChaines[chainIdCounter] = arrList.size();
            			chainIdCounter++;
            		}
            		if(ext == 8)
            		{
            			arrOfRevFragmentChainScores[chainIdCounter] = score;
            			startIndexOfRevChaines[chainIdCounter] = arrList.size();
            			chainIdCounter++;
            		}
            	
            	}
            	else
            	{
            		// ----------------------- to read line from file ---------------------------------------------
        			//------------------------------------------------------------------------------------------------
            		for(int i=0;i<parent.num;i++)
                	{
                		int[] d_frpos1=new int[2];
          				int[] d_frposN=new int[2];// for te fragments in the genomes "not first one"
                		
	                	//to convert the s_frpos---the string contian the fragment postion to double 
	                	//then passs thiis to the fragment object in the fragments postion array list
	                	if(i == 0)
	                {	d_frpos1[0] = Integer.parseInt(new String(myString,index1[i]+1,index2[i]-index1[i]-1));
	                	d_frpos1[1] = Integer.parseInt(new String(myString,index2[i]+1,index3[i]-index2[i]-1));
	                	
	                	//--to get the max
	                	if(parent.maxEndInFragments.get(0)<d_frpos1[1])
	                		parent.maxEndInFragments.set(0,d_frpos1[1]);
	                	f.fragmentsPos.add(d_frpos1);
	                }
	                
	                	if(i > 0)
	                {	d_frposN[0] = Integer.parseInt(new String(myString,index1[i]+1,index2[i]-index1[i]-1));
	                	d_frposN[1] = Integer.parseInt(new String(myString,index2[i]+1,index3[i]-index2[i]-1));
	                	
	                	//-------------
	                	if(ext == 4 || ext==5 || ext == 6 || ext ==8)
	                	{
	                	//to make transformation only for the reverse genomes in this file....
	                	//	if(transformString.charAt(i)=='m')
	                		{
	                		int t = d_frposN[0];
	                		d_frposN[0] = (int)parent.logFile.get(i)- d_frposN[1]-1;
	                		d_frposN[1] = (int)parent.logFile.get(i) - t - 1;}
	                	}
	                	//System.out.println("the fragment pos 2  "+d_frpos2[0]+"   "+d_frpos2[1]+"\n");
	                	//---to get the max 
	                	if(parent.maxEndInFragments.get(i)<d_frposN[1])
	                		parent.maxEndInFragments.set(i,d_frposN[1]);
	                	
	                	f.fragmentsPos.add(d_frposN);
	                }
	                	
	                }//end of for(int i=0;i<f.num;i++)
                	
	            //add the fragment
	            if(ext != 3 && ext != 6)
	            f.score=score;
	            
	            
	           // this.arrOfFragments.add(f);
	            arrList.add(f.fragmentsPos);
	            
	            if(ext == 1)
	    		this.arrOfFragmentScores[arrList.size()-1] = f.score;
	            
	            if(ext == 2)
	      			arrOfCcnScores[arrList.size()-1] = f.score;
	            if(ext == 5)
	      			arrOfRevCcnScores[arrList.size()-1] = f.score;
	            
	    		if(ext == 4)
	    		this.arrOfRevFragmentScores[arrList.size()-1]= f.score;
	            if(ext == 7)
	            	arrOfFragmentChainID[arrList.size()-1] = chainIdCounter;
	            if(ext == 8)
	            	arrOfRevFragmentChainID[arrList.size()-1] = chainIdCounter;
            	}//end for not # line
            	lineCounter =0;
            	counter1=0;
            	counter2=0;
            	counter3=0;
            }//end of else for finishing line
            
        	}//end loop for line
        	
        }while ((n = fis.read(readMap)) != -1);//end loop for file
        fis.close();
        
        parent.toWriteInTheConsoleList("Finished");
       
   
	
	
      //	this.arrOfFragments = null;
	//System.gc();
	 elapsedTime = (float)( System.currentTimeMillis() -startTime)/1000f;
	 parent.toWriteInTheConsoleList("  \n the file opned in  "+elapsedTime+"sec");
		return true;
      }//end of try read line
    catch(Exception e)
    {
    	JOptionPane.showMessageDialog(parent,"Please check the file.\n or send this exception to the Auhtor :"+e.toString(),"Error",JOptionPane.WARNING_MESSAGE);
    	return false;
    }
	}
//-----------------------------------------------------------------------------------------------------------------------------------------------------------------
	/*
	 * openLogFile
	 * to open the log file and fill the array list and get the pathes of the multiple genomes files
	 */
public boolean openLogFileForMultipleGenomes()
{
	parent.pathesOfFragmentFilesForMultipleGenomes = new ArrayList();
	fc.setDialogTitle("Open Log File  ");
	
	fc.setCurrentDirectory(new File(parent.pathDir));
	int returnVal = fc.showOpenDialog(parent);
	//fc.setFileFilter(new MyFilter(".log"));
	if (returnVal == JFileChooser.APPROVE_OPTION) 
	{  
		parent.pathDir = fc.getCurrentDirectory().getPath();
	   //------------------------------------------- open log file----------------------------------------------------------
		BufferedReader br = null;
		try 
		{  
			//create a buffered reader to read the sequence file specified by File Chooser Dialog
			File openedFile= fc.getSelectedFile();
			br = new BufferedReader(new FileReader(openedFile));
		   //repalce the arraylist of tabs by useing string tokenizer
		   StringTokenizer dataFirstLine = new StringTokenizer(br.readLine());
		
		  // if not open Fragment file or sequences
		  int k=0;
		  //if(parent.num==0)
		  k=Integer.parseInt(dataFirstLine.nextToken());
		  //else k = parent.num;
		  
		  //here set the legth of the logfile araylist and it same as number  of fragments
		  parent.logFile.setlength(k);
		
		  
		  for(int i = 0; i< k ; i++)
		   {	
			  parent.logFile.add(Integer.parseInt(dataFirstLine.nextToken()));	
			  parent.toWriteInTheConsoleList("\n the length of genome "+(i+1)+" is "+parent.logFile.get(i));
		   }
		 
		//-----to intialize the max end fragment list
	 	     //this list will be also check and may be  get values when reading file 
	 	     //because it usless to make another for loop agian on the fragment array 
	 	     //to get max.
	 	     if(parent.flagForMaxEndArr)
	 	     {
	 	    	 parent.flagForMaxEndArr= false;
	 	     	//will set legth only for one time ......here not in open stc file because this happen first and then see if the stc file will open or not
	 	     	//and if it has not opened ,the array already has been fill with zeros and then with max length from the comparison between the intervals
	 	    	 parent.maxEndInFragments.setlength(k);
	 	     	for(int hh =0 ; hh< k ; hh++ )
	 	     	{
	 	     		parent.maxEndInFragments.add((int)parent.logFile.get(hh));
	 	     	}
	 	 	}
	 	    String lineString="";
			lineString = br.readLine(); 
			  do
			  {
				  lineString =lineString.substring(lineString.lastIndexOf("/")+1);
				  lineString =lineString.substring(lineString.lastIndexOf("\\")+1); 
				  if(lineString != "" || lineString != null)
				  parent.pathesOfFragmentFilesForMultipleGenomes.add((String)(openedFile.getParent()+parent.parent.fileDash+lineString));
				  lineString = br.readLine();	  
			  }while(lineString != null);
		    br.close();
		
	    parent.saveSessionArr_.add("0,"+openedFile.getPath());
	    //parent.saveSessionArr_.add("2,"+openedFile.getParentFile());
	    return true;
	    }//end of try read line
	    catch(Exception e)
	    {
	    	JOptionPane.showMessageDialog(parent,"Please check the file.\n or send this exception to the Auhtor :"+e.toString(),"Error",JOptionPane.WARNING_MESSAGE);
	    return false;
	    }     
	   //---------------------------------------------------------------------------------------------------
   }
   else
   {
   	JOptionPane.showMessageDialog(parent,"You don't select any files");
   	return false;
   }
}//end of function

/**
 * open log file call in open session function
 */
void openLogForopensessionMethod(String path)
{
	parent.pathesOfFragmentFilesForMultipleGenomes = new ArrayList();
	BufferedReader br = null;
	try 
	{  
		//create a buffered reader to read the sequence file specified by File Chooser Dialog
		File openedFile= new File(path);
		br = new BufferedReader(new FileReader(openedFile));
	   //repalce the arraylist of tabs by useing string tokenizer
	   StringTokenizer dataFirstLine = new StringTokenizer(br.readLine());
	
	// if not open Fragment file or sequences
		  int k=0;
		  //if(parent.num==0)
		  k=Integer.parseInt(dataFirstLine.nextToken());
		  //else k = parent.num;
		  
		  //here set the legth of the logfile araylist and it same as number  of fragments
		  parent.logFile.setlength(k);
		
		  
		  for(int i = 0; i< k ; i++)
		   {	
			  parent.logFile.add(Integer.parseInt(dataFirstLine.nextToken()));	
			  parent.toWriteInTheConsoleList("\n the length of genome "+(i+1)+" is "+parent.logFile.get(i));
		   }
		 
		//-----to intialize the max end fragment list
	 	     //this list will be also check and may be  get values when reading file 
	 	     //because it usless to make another for loop agian on the fragment array 
	 	     //to get max.
	 	     if(parent.flagForMaxEndArr)
	 	     {
	 	    	 parent.flagForMaxEndArr= false;
	 	     	//will set legth only for one time ......here not in open stc file because this happen first and then see if the stc file will open or not
	 	     	//and if it has not opened ,the array already has been fill with zeros and then with max length from the comparison between the intervals
	 	    	 parent.maxEndInFragments.setlength(k);
	 	     	for(int hh =0 ; hh< k ; hh++ )
	 	     	{
	 	     		parent.maxEndInFragments.add((int)parent.logFile.get(hh));
	 	     	}
	 	 	}
	 	    String lineString="";
			lineString = br.readLine(); 
			  do
			  {
				  lineString =lineString.substring(lineString.lastIndexOf("/")+1);
				  lineString =lineString.substring(lineString.lastIndexOf("\\")+1); 
				  if(lineString != "" || lineString != null)
				  parent.pathesOfFragmentFilesForMultipleGenomes.add((String)(openedFile.getParent()+parent.parent.fileDash+lineString));
				  lineString = br.readLine();	  
			  }while(lineString != null);
		    br.close();
    parent.saveSessionArr_.add("0,"+openedFile.getPath());
    //parent.saveSessionArr_.add("2,"+openedFile.getParentFile());
    
    }//end of try read line
    catch(Exception e)
    {
    	JOptionPane.showMessageDialog(parent,"Please check the file.\n or send this exception to the Auhtor :"+e.toString(),"Error",JOptionPane.WARNING_MESSAGE);
    }     
   //---------------------------------------------------------------------------------------------------

}//end of function

//----------------------------------------------------------------------------------
/*
 * open Files Of MultipleGenomes To SetLength
 * param>the extension to know the type of the file so it set length the right arraylist
 */
boolean openFileOfMultipleGenomesToSetLength(String extension ,String extension2)
{
	String lineString="";
	BufferedReader br0;
	//arrOfFragments = new MyFragmentTempArrayList();
	int countOfFragments = 0 ;
	int countOfChaines = 0;
	String FilePath ="";
	String transformString="";
	MyFragmentPosArrayListToDraw arrToDraw = new MyFragmentPosArrayListToDraw();
	if(extension.equalsIgnoreCase(""))
		arrToDraw = arrToDrawTheFragments;
	if(extension.equalsIgnoreCase(".chn"))
		arrToDraw=arrToDrawTheChainesFile;
	if(extension.equalsIgnoreCase(".ccn"))
		arrToDraw=arrToDrawTheChaines;
	if(extension.equalsIgnoreCase(".cst"))
		arrToDraw= arrToDrawTheClusters;
		
	 try 
     { 
 	
	long  startTime =System.currentTimeMillis();
 	
 	for(int j = 0; j< parent.pathesOfFragmentFilesForMultipleGenomes.size();j++)
 	{
 		FilePath = parent.pathesOfFragmentFilesForMultipleGenomes.get(j).toString();
 		
 	//---------------------- to count the count of the fragment in file to set the length of the array
 	// create a buffered reader to read the sequence file specified by File Chooser Dialog 
		br0 = new BufferedReader(new FileReader(FilePath+extension2));
//	------------------------------------------------------------------------------------------------
		//System.out.println("Reading"+lineString+"\n");
		lineString = br0.readLine();
		
		if(parent.num == 0  || this.arrOfReverseLocations.size()==0 )
		{//if not cluster file
         // to read the number of genomes from-----> #CHA 'num'
         //System.out.println("Reading number"+lineString+"\n");
			parent.num=Integer.parseInt(lineString.substring(lineString.indexOf("A")+2));
         for(int i=0;i<parent.num;i++)
    		{
    			this.arrOfReverseLocations.add(new ArrayList());
    		}
          lineString = br0.readLine();
          
          if(lineString == null)
        	  continue;//////////if the file empty
          //JOptionPane.showMessageDialog(null,"The number of Genomes :"+Fragment.num+"");
        
         }//end if the file not cluster file
		//	---------- to know the reverse "the start location" -------------------
 		int index = FilePath.lastIndexOf('.');
 		int[] location = new int[2];
 		if (index > 0 &&  index < FilePath.length() - 1)
 			 transformString = FilePath.substring(index+1).toLowerCase();
 		for(int h=0;h<parent.num;h++)
 		{
 			if(transformString.charAt(h)=='m')
 			{
 				location[0] = countOfFragments;
 			}
 		}
 		//-----------------------------------------------------------------------
		do
		{
			if(lineString.charAt(0)=='[')
				countOfFragments++;
			if(lineString.charAt(0)=='#')
			countOfChaines++;
			lineString = br0.readLine();
     }while(lineString != null);//end of while
		br0.close();
      //---------- to know the reverse "the end location" -------------------
 		for(int h=0;h<parent.num;h++)
 		{
 			if(transformString.charAt(h)=='m')
 			{
 				location[1]= countOfFragments;
 				ArrayList  arr =(ArrayList) this.arrOfReverseLocations.get(h);
 				
 				if(location[0] != location[1])
 				{
 					location[0] ++;
 				    arr.add(location);
 				}
 				this.arrOfReverseLocations.set(h, arr);
 			}
 		}
 		//-----------------------------------------------------------------------
	
 		
     //---------------------------------
     //---------------------------------
     //----- to open the statistic file if it doesn't open before and the sequences have didn't opened
     
     if(parent.numberOfOpenedSeq < parent.num && parent.flag_openStcfile)
		{
    	    parent.flag_openStcfile = false;
			int n = JOptionPane.showConfirmDialog(
					parent, "You didn't open Sequence Would you like to open Statistic File? ",
	            "Question",
	            JOptionPane.YES_NO_OPTION);
	            
	        if (n == JOptionPane.YES_OPTION) 
	        {
	        	JFileChooser fc2 = new JFileChooser();
	        	  fc2.setDialogTitle("Open  Stc File  ");
	        	  fc2.setCurrentDirectory(new File(parent.pathDir));
	        	int returnVal0 = fc2.showOpenDialog(parent);
		        if(returnVal0 == JFileChooser.APPROVE_OPTION)
	            {
		        	parent.pathDir = fc2.getCurrentDirectory().getName();
	            	//--------------------------------------------- oprn Stc file -------------------------------------------------------
		        	BufferedReader br = null;
		            try 
		            {  
		        			//create a buffered reader to read the sequence file specified by File Chooser Dialog 

		        		br = new BufferedReader(new FileReader(fc2.getSelectedFile()));
		        		//repalce the arraylist of tabs by useing string tokenizer
		        		StringTokenizer dataFirstLine = new StringTokenizer(br.readLine());
		        		
		        		int numOfGenomes=Integer.parseInt(dataFirstLine.nextToken());
		        		
		        		if(parent.num != numOfGenomes)
		        		{	
		        			int n2 = JOptionPane.showConfirmDialog(
		        					parent, "The number of genomes in the statistic file is different"+parent.num+"  "+numOfGenomes+" \n from which has been in Fragment file. Do wnat to replace it? ",
		                  	"Question",
		                  	JOptionPane.YES_NO_OPTION);
		                    
		                	if (n2 == JOptionPane.YES_OPTION) 
		                	{
		                		parent.num = numOfGenomes;
		                	}
		              }
		        		
		        		//maxEndInFragments.setlength(num);--length will set here , it will be set in open fragment file method in profiles ,,,,,,,because it " openStcFile" call after it
		        		parent.numOfFragments=Integer.parseInt(dataFirstLine.nextToken());
		        		parent.maxLengthOfInterval=Integer.parseInt(dataFirstLine.nextToken());
		        		parent.minLengthOfInterval=Integer.parseInt(dataFirstLine.nextToken());
		        		//-- to get the max end of fragments 
		        		StringTokenizer dataSecondLine = new StringTokenizer(br.readLine());
		        		for(int i = 0; i< parent.num ; i++)
		        		{
		        			parent.maxEndInFragments.set(i,Integer.parseInt(dataSecondLine.nextToken()));	
		        		}
		        			
		        	    br.close();
		        	    parent.saveSessionArr_.add("1,"+fc2.getSelectedFile().getPath());
		            }//end of try read line
		            catch(Exception e)
		            {
		            	JOptionPane.showMessageDialog(parent,"Please check the file.\n or send this exception to the Auhtor :"+e.toString(),"Error",JOptionPane.WARNING_MESSAGE);
		            }
	            }
	            else//if didn't select file
				{
				JOptionPane.showMessageDialog(parent,"You didn't select file.","Error",JOptionPane.ERROR_MESSAGE);
				}
	            
	        }//end if if (n == JOptionPane.YES_OPTION)  
		}//end if(this.numberOfOpenedSeq < Fragment.num && this.flag_openStcfile)
     //-----------------------------------------------------------------------------------------------------------
 	}//end for(int j = 0; j< pathesOfFragmentFilesForMultipleGenomes.size();j++)
     if(countOfFragments > 0)
		{
			//this.arrOfFragments.setlength(countOfFragments);
			arrToDraw.setlength(countOfFragments);
			if(extension.equalsIgnoreCase(""))
      			arrOfFragmentScores = new float[countOfFragments];
			
			if(extension.equalsIgnoreCase(".ccn"))
      			arrOfCcnScores = new float[countOfFragments];
			
			if(extension.equalsIgnoreCase(".chn"))
      		{
      			arrOfFragmentChainScores = new float[countOfChaines];
      			startIndexOfChaines = new int[countOfChaines];
      			arrOfFragmentChainID = new int[countOfFragments];
      		}
			parent.toWriteInTheConsoleList("  the number of fragments in the file  "+countOfFragments);
			float elapsedTime = (float)( System.currentTimeMillis() -startTime)/1000F;
			parent.toWriteInTheConsoleList("  \n the file has been opened in "+elapsedTime+"sec");
			return true;
			
		}
     return true;
     }//end of try read file
     catch(Exception e)
     {
    	 JOptionPane.showMessageDialog(parent,"Please check the file.\n or send this exception to the Auhtor :"+e.toString(),"Error",JOptionPane.WARNING_MESSAGE);
     	return false;
     }
}//end of function

//----------------------------------------------------------------------------
/*
 * it is same as the function set length but now it will parse the file not only count the fragments
 */
public boolean openFragmentsOfMultipleGenomes(String extension,String extension2)
{
	
	byte[] readMap;
	char c;
	char[] myString = new char[1500];
	String transformString="";
	MyFragmentPosArrayListToDraw arrToDraw = new MyFragmentPosArrayListToDraw();
	if(extension.equalsIgnoreCase(""))
		arrToDraw = arrToDrawTheFragments;
	if(extension.equalsIgnoreCase(".chn"))
		arrToDraw=arrToDrawTheChainesFile;
	if(extension.equalsIgnoreCase(".ccn"))
		arrToDraw=arrToDrawTheChaines;
	if(extension.equalsIgnoreCase(".cst"))
		arrToDraw= arrToDrawTheClusters;
	
try{
	for(int j=0;j<parent.pathesOfFragmentFilesForMultipleGenomes.size();j++)
	  {
//	 --------------------------------------------------------------------------------------------------------------------------------------------------------------
		//create a buffered reader to read the sequence file specified by File Chooser Dialog 
	// using memory mapping
		int firstLine = 0;
		String FilePath = parent.pathesOfFragmentFilesForMultipleGenomes.get(j).toString();
		//int fileSize = (int)new File(FilePath+extension).length();
		//FilePath = parent.pathesOfFragmentFilesForMultipleGenomes.get(j).toString();
 		
		BufferedReader br0 = new BufferedReader(new FileReader(FilePath+extension2));
		
		String lineStringtotest = br0.readLine();
		
		lineStringtotest = br0.readLine();
		
		if(lineStringtotest == null)
			continue;
		FileInputStream fis = new FileInputStream(FilePath+extension2);
     readMap= new byte[sizeOfBuffer];//4194304
     
     int index = FilePath.lastIndexOf('.');
	    if (index > 0 &&  index < FilePath.length() - 1)
	       transformString = FilePath.substring(index+1).toLowerCase();
	 //--------------------------------------------------   
    int lineCounter = 0;
    int n;
    float score=0;
    
	int[] index1=new int[parent.num];//index of [
	int[] index2=new int[parent.num];//index of ,
	int[] index3 = new int[parent.num];//index of ]
	//these counter , to know the places of the '[ ',' ,' ,']'
	int counter1 =0,counter2=0,counter3=0;
   long  startTime =  System.currentTimeMillis();
   n = fis.read(readMap);
   do {
    	int readMapIndex =0;
      // to read first line....
    	if(firstLine == 0)
    	{
    		firstLine++;
    	for (  readMapIndex = 0; readMapIndex < n; readMapIndex++) 
    	{
        if (readMap[readMapIndex] == '\n')
        {
          readMapIndex++;
        	break;
        }
    	}//end loop for line
    	}//end of if firstLine
    ////////////////////////////////////////////////////////////////
    	for (; readMapIndex < n; readMapIndex++) 
    	{
        if (readMap[readMapIndex] != '\n')
        {
        	c = (char)readMap[readMapIndex];
        	myString[lineCounter] = c;
        	if(c == '[')
        		{index1[counter1]=lineCounter;
        		counter1++;
        		}
        	if(c == ',')
        	{index2[counter2]=lineCounter;
    		counter2++;
    		}
        	if(c == ']')
        	{index3[counter3]=lineCounter;
    		counter3++;
    		}
        	lineCounter++;
        }
        else
        {
        	Fragment f=new Fragment();
        	f.fragmentsPos.setlength(parent.num);
        	if(myString[0] =='#')
        	{
        		score= Float.parseFloat(new String(myString,1,lineCounter-1));
        		if(extension.equalsIgnoreCase(".chn"))
        		{
        			arrOfFragmentChainScores[chainIdCounterForMultipleGenomes] = score;
        			startIndexOfChaines[chainIdCounterForMultipleGenomes]=arrToDraw.size();
        			chainIdCounterForMultipleGenomes++;
        		}
        	}
        	else
        	{
        		// ----------------------- to read line from file ---------------------------------------------
    			//------------------------------------------------------------------------------------------------
        		for(int i=0;i<parent.num;i++)
            	{
            		int[] d_frpos1=new int[2];
      				int[] d_frposN=new int[2];// for te fragments in the genomes "not first one"
                	//to convert the s_frpos---the string contian the fragment postion to double 
                	//then passs thiis to the fragment object in the fragments postion array list
                	if(i == 0)
                {	d_frpos1[0] = Integer.parseInt(new String(myString,index1[i]+1,index2[i]-index1[i]-1));
                	d_frpos1[1] = Integer.parseInt(new String(myString,index2[i]+1,index3[i]-index2[i]-1));
                	//System.out.println("the fragment pos 1 "+d_frpos1[0]+"   "+d_frpos1[1]+"\n");
                	//--to get the max
                	//if(parent.maxEndInFragments.get(0)<d_frpos1[1])
                	//	parent.maxEndInFragments.set(0,d_frpos1[1]);
                	f.fragmentsPos.add(d_frpos1);
                }
                	if(i > 0)
                {	d_frposN[0] = Integer.parseInt(new String(myString,index1[i]+1,index2[i]-index1[i]-1));
                	d_frposN[1] = Integer.parseInt(new String(myString,index2[i]+1,index3[i]-index2[i]-1));
                	
                	if(transformString.charAt(i)=='m')
                	{
                		int t = d_frposN[0];
                		d_frposN[0] = (int)parent.logFile.get(i)- d_frposN[1]-1;
                		d_frposN[1] = (int)parent.logFile.get(i) - t-1;
                	}
                	//System.out.println("the fragment pos 2  "+d_frpos2[0]+"   "+d_frpos2[1]+"\n");
                	//---to get the max 
                	//if(parent.maxEndInFragments.get(i)<d_frposN[1])
                	//	parent.maxEndInFragments.set(i,d_frposN[1]);
                	
                	f.fragmentsPos.add(d_frposN);
                }
                }//end of for(int i=0;i<f.num;i++)
            //add the fragment
            f.score=score;
          //  this.arrOfFragments.add(f);
            arrToDraw.add(f.fragmentsPos);
            if(extension.equalsIgnoreCase(""))
	    		this.arrOfFragmentScores[arrToDraw.size()-1] = f.score;
            
            if(extension.equalsIgnoreCase(".ccn"))
	    		this.arrOfCcnScores[arrToDraw.size()-1] = f.score;
            
            if(extension.equalsIgnoreCase(".chn"))
 	            	arrOfFragmentChainID[arrToDraw.size()-1] = chainIdCounterForMultipleGenomes;
        	}//end for not # line
        	lineCounter =0;
        	counter1=0;
        	counter2=0;
        	counter3=0;
        }//end of else for finishing line
    	}//end loop for line
    } while ((n = fis.read(readMap)) != -1);//end loop for file
    fis.close();
  	float elapsedTime = (float)( System.currentTimeMillis() -startTime)/1000f;
  	parent.toWriteInTheConsoleList("  \n Time "+elapsedTime);
	  }//end of for(int j=0;j<pathesOfFragmentFilesForMultipleGenomes.size();j++)
  	return true;
  
	 }//end of try read line
		catch(Exception e)
		{
			JOptionPane.showMessageDialog(parent,""+e.toString(),"Error",JOptionPane.ERROR_MESSAGE);
			return false;
		}
	 
}//end of functions
//-------------------------------------------------------------------------------
/*
 *To Sort the fragment ...but it will only save the fragment index  after sort operation
//It use QuickSort Algorithm 
 */

void sort(int[]a,int genomeNum,MyFragmentPosArrayListToDraw arr)
{
    sort(a, 0, a.length-1,genomeNum,arr);
}
void sort(int[] a, int lo0, int hi0,int genomeNum,MyFragmentPosArrayListToDraw arr)
{
    int lo = lo0;
    int hi = hi0;
    
    if (lo >= hi) {
        return;
    }
    else if( lo == hi - 1 ) {
        /*
         *  sort a two element list by swapping if necessary 
         */
        if (getValue(a[lo], genomeNum, arr) > getValue(a[hi], genomeNum, arr)) {
            int T = a[lo];
          
            a[lo] = a[hi];
            
            a[hi] = T;
        }
        return;
    }
    /*
     *  Pick a pivot and move it out of the way
     */
    int pivot = a[(lo + hi) / 2];
    a[(lo + hi) / 2]= a[hi];
    a[hi]= pivot;
    while( lo < hi ) {
        /*
         *  Search forward from a[lo] until an element is found that
         *  is greater than the pivot or lo &gt;= hi 
         */
        while (getValue(a[lo], genomeNum, arr) <= getValue(pivot, genomeNum, arr) && lo < hi) {
            lo++;
        }

        /*
         *  Search backward from a[hi] until element is found that
         *  is less than the pivot, or lo &gt;= hi
         */
        while (getValue(pivot, genomeNum, arr) <= getValue(a[hi], genomeNum, arr)&&  lo < hi ) {
            hi--;
        }

        /*
         *  Swap elements a[lo] and a[hi]
         */
        if( lo < hi ) {
            int T= a[lo];    
            a[lo]= a[hi];
            a[hi]= T;
            
        }
    }

    /*
     *  Put the median in the "center" of the list
     */
    a[hi0] = a[hi];
    
    a[hi]= pivot;

    /*
     *  Recursive calls, elements a[lo0] to a[lo-1] are less than or
     *  equal to pivot, elements a[hi+1] to a[hi0] are greater than
     *  pivot.
     */
    sort(a, lo0, lo-1,genomeNum,arr);
    sort(a, hi+1, hi0,genomeNum,arr);
}
int getValue(int index,int genomeNum,MyFragmentPosArrayListToDraw arr)
{
	FragmentPosArrayList fragmentPos = arr.get(index);
	int[] d =(int[])fragmentPos.get(genomeNum);
	
	return Math.min(d[0], d[1]);
}
/**
 * Filtration
 * @param arr
 * @param thershold
 * @return
 */
//boolean filterFragments(int index  ,float threshold , float[] arr)
//{
//	 if(arr[index] > threshold )
//	 return true;
//	 else 
//		 return false;
//}


/****
 * index ->>>>>>> index in the array which will draw 
 * threshold -->>>> score
 * arr----->>>>>
 * 
 * 
 * 
 */
boolean filterFragments(int index  ,float threshold , float[] arr,MyFragmentPosArrayListToDraw arrListToDraw,int length_threshold,boolean flag)
{


	if(arr[index]< parent.minScore)
		parent.minScore = arr[index];
	if(arr[index] > parent.maxScore)
		parent.maxScore = arr[index];
	
	
	
	 if(arr[index] < threshold )
	  return false;
	 
	int x = length_threshold;

	int[] arrToDraw = new int[2];
	
	if(flag)
	{
	    int startOfthisChain = startIndexOfChaines[arrOfFragmentChainID[index]-1];
	    FragmentPosArrayList  starPoints = arrToDrawTheChainesFile.get(startOfthisChain);
	    //to get the last fragment in the chain
	    int endOfthisChain;
	    if(arrOfFragmentChainID[index] >= startIndexOfChaines.length)
	    {
		endOfthisChain = arrToDrawTheChainesFile.size()-1;
	    }
	    else
		endOfthisChain = startIndexOfChaines[arrOfFragmentChainID[index]]-1;
	    
	    FragmentPosArrayList  endPoints = arrToDrawTheChainesFile.get(endOfthisChain);
	    
	    for(int g=0;g< parent.num;g++)
	    {
		
		int[] d =(int[])starPoints.get(g);
		
		int[] d2 =(int[])endPoints.get(g);
		
		int length;
		
		if(d[0] >= d2[0])//start > end
		{
		    length = (int)Math.abs(d2[0]-d[1]);//start is the end
		    //if(g==1)
		    //System.out.println("rev "+arrOfFragmentChainID[index]+"    s "+d[0]+" s "+d[1] +" e "+d2[0]+" e "+d2[1]+"   "+length);
		}
		else
		{
		    length = (int)Math.abs(d[0]-d2[1]);
		    //if(g==1)
		    //System.out.println("right"+arrOfFragmentChainID[index]+"  s "+d[0]+" s "+d[1] +" e "+d2[0]+" e "+d2[1]+"   "+length);
		}
		
		if(length< parent.minLength)
		    parent.minLength = length;
		if(length > parent.maxLength)
		    parent.maxLength = length;
		
		///////////////////////////////////////////////////////////////////////////
//	try
//	{
//	File file = new File("C:\\filtered.txt");
//	File file2 = new File("C:\\non-filtered.txt");
//	FileWriter fw = new FileWriter(file,true);
//	BufferedWriter bw = new BufferedWriter(fw);
//	FileWriter fw2 = new FileWriter(file2,true);
//	BufferedWriter bw2 = new BufferedWriter(fw2);
//	if(length < length_threshold)
//	{bw.append("index---"+index+"length--->"+length+"\n");
//	bw.flush();
//	}
//	else
//	{
//		bw2.append("index---"+index+"length--->"+length+"\n");
//		bw2.flush();
//	}
//	
//	
//	bw.close();
//	fw.close();
//	bw2.close();
//	fw2.close();
//	}
//	catch(Exception ex)
//	{
//	JOptionPane.showMessageDialog(null,"save file erroe","Errr",JOptionPane.ERROR_MESSAGE);
//	}

	///////////////////////////////////////////////////////////////////////////
		if(length < length_threshold)
		    return false;
		
	    }
	    
	}//if(flag == 0)
	else
	{
	    
	    int length=0;
	    for(int g=0;g< parent.num;g++)
	    {
		FragmentPosArrayList fragmentPos = arrListToDraw.get(index);
		int[] d =(int[])fragmentPos.get(g);
		arrToDraw[0] = d[0];
		arrToDraw[1] = d[1];
		
		length = (int)Math.abs(arrToDraw[0]-arrToDraw[1]);
		
		if(length < length_threshold)
		    return false;
		
	    }//end of for
	    	if(length< parent.minLength)
		    parent.minLength = length;
		if(length > parent.maxLength)
		    parent.maxLength = length;
	}//end of else
	
	return true;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
}//end of class
