/*
*FragmentFrame.java
*
*Open the frame for selected frgments and show the sequence
*in the 2 genomes
*
*
*
*
*
*Asem A. Othman
**/

import java.awt.*;
import java.util.*;
import java.awt.event.*;
import java.io.*;

import javax.swing.*;

import org.biojava.bio.gui.sequence.*;
import org.biojava.bio.seq.*;
import org.biojava.bio.symbol.*;
import org.biojava.bio.seq.io.*;


class FragmentFrame extends JDialog
{

	JList list;

	JSplitPane splitPane;
	
	SequencePanel panel;

	JToolBar buttonBar;

	JButton saveFragments;

	JButton saveSubSequences;

	JButton close;
	
	JLabel command;

	JTextField commandTextFiled;

	JFileChooser fc = new JFileChooser();
	
	VisChainerPanel parent1;

	JInternalFrame parent;

	VisChainerMain mainParent;
	
	DrawPanel parentPanel;
	
	
	/**
	 * the array used to save the begin "the smallest num" and the end "the max." to save subsequences
	 */
	int[] begindIndexarr;
	int[] endIndexarr;
	
	/**
	 * 
	 * @param arr : the array list contians the stirngs write in the list
	 * @param p : the projection form 
	 * @param panel : the drawing panel
	 */

	FragmentFrame(Object[] arr,VisChainerPanel p,DrawPanel panel)//take the arr which will appear in list
	{
		super(p.parent.parent,"The Selected Fragments");
		parent1 =p;
		parent = parent1;
		mainParent = parent1.parent;
		
		parentPanel = panel;
		addWindowListener(new WindowAdapter() 
		{
            public void windowClosing(WindowEvent e) 
            {
            	dispose();
            	System.gc();
            }
        });
        
        init(arr);
        this.setSize(500,200);
    }
	FragmentFrame(Object[] arr,VisChainerLinealMode p,DrawLinealModePanel panel)//take the arr which will appear in list
	{
		super(p.parent.parent,"The Selected Fragments");
		parent1 =p;
		parent = parent1;
		mainParent = parent1.parent;
		
		parentPanel = panel;
		
		addWindowListener(new WindowAdapter() 
		{
            public void windowClosing(WindowEvent e) 
            {
            	dispose();
            	System.gc();
            }
        });
        
        init(arr);
        this.setSize(500,200);
    }
    
    void init(Object[] arr)
    {
		//Create the list of selected fragments and put it in a scroll pane
        list = new JList(arr);
        list.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        list.setSelectedIndex(0);
        
        list.addMouseListener( new MouseAdapter()
		{
			public void mouseClicked(MouseEvent e) 
			{
              if (e.getClickCount() == 2) 
              {
               int index = list.locationToIndex(e.getPoint());
               showSelectedFragment(list.getModel(),index);
               setTitle((String)list.getSelectedValue());
              }
            }
        });
        
        JScrollPane listScrollPane = new JScrollPane(list);
        
        
        //the panel where the fragments will draw
        panel = new SequencePanel();
        JScrollPane fragmentsScrollPane = new JScrollPane();
        
        fragmentsScrollPane.getViewport().setView(panel);
        
        //Create a split pane with the two scroll panes in it
        splitPane = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT,
                                   listScrollPane, fragmentsScrollPane);
        splitPane.setOneTouchExpandable(true);
        splitPane.setDividerLocation(150);
        
        
        //Provide minimum sizes for the two components in the split pane
        Dimension minimumSize = new Dimension(100, 50);
        listScrollPane.setMinimumSize(minimumSize);
        fragmentsScrollPane.setMinimumSize(minimumSize);

        //Provide a preferred size for the split pane
        splitPane.setPreferredSize(new Dimension(400, 200));
        
        buttonBar = new JToolBar(); 
    	saveFragments = new JButton("Save Fragments");
    	saveSubSequences = new JButton("Save SubSequences");
    	
    	close = new JButton("Close");
    	
    	command=new JLabel("System Commands");
    	commandTextFiled=new JTextField();
        //------------------ Actions ------------------------
    	close.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) 
            { 
            	FragmentFrame.this.dispose();
            }
    	});
    	saveFragments.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) 
            { 
            	//Show dialog; this method does not return until dialog is closed
            	fc.setDialogTitle("Choose the Directory....... ");
            	fc.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
            	int returnVal =  fc.showSaveDialog(FragmentFrame.this);

                String s="";
                if (returnVal == JFileChooser.APPROVE_OPTION) 
         	   {  
                 try 
                     { 
                	 s = (String)JOptionPane.showInputDialog(parent,"Write The Name of file : ","Save As........ ",JOptionPane.QUESTION_MESSAGE,
         	                    null,
         	                    null,
         	                    null);	 
                	 
                	 if(parentPanel.selectedFragmentsIndex.size() > 0) 
                	 {
                		saveTheFilesFromSelectedVector(s,parentPanel.selectedFragmentsIndex,1);
                	 }//end of if(selectedFragmentsIndex.size() > 0)

                	 if(parentPanel.selectedCcnIndex.size() > 0) 
                	 {
                		saveTheFilesFromSelectedVector(s,parentPanel.selectedCcnIndex,2);
                	 }//end of  if(parentPanel.selectedCcnIndex.size() > 0) 
                	 
                	 if(parentPanel.selectedChainFileIndex.size() > 0) 
                	 {
                		saveTheFilesFromSelectedVector(s,parentPanel.selectedChainFileIndex,7);
                	 }//end of  if
                	 
                	 if(parentPanel.selectedClusterIndex.size() > 0) 
                	 {
                		saveTheFilesFromSelectedVector(s,parentPanel.selectedClusterIndex,3);
                	 }//end of  if
                	 
                	 
                	 if(parentPanel.selectedRevFragmentsIndex.size() > 0) 
                	 {
                		 saveTheFilesFromSelectedVector(s, parentPanel.selectedRevFragmentsIndex,4);
                	 }//end of if(parentPanel.selectedRevFragmentsIndex.size() > 0) 
                	 
                	 if(parentPanel.selectedRevCcnIndex.size() > 0) 
                	 {
                		 saveTheFilesFromSelectedVector(s, parentPanel.selectedRevCcnIndex,5);
                	 }//end of if
                	 
                	 if(parentPanel.selectedRevChainFileIndex.size() > 0) 
                	 {
                		 saveTheFilesFromSelectedVector(s, parentPanel.selectedRevChainFileIndex,8);
                	 }//end of if
                	 
                	 if(parentPanel.selectedRevClusterIndex.size() > 0) 
                	 {
                		 saveTheFilesFromSelectedVector(s, parentPanel.selectedRevClusterIndex,6);
                	 }//end of if
                	 
                     }//end try
                 catch(Exception ex)
         	    {
         	    JOptionPane.showMessageDialog(parent,""+ex.toString(),"Error",JOptionPane.ERROR_MESSAGE);
         	    }     
         	   //---------------------------------------------------------------------------------------------------
            }
            else
            {
            	JOptionPane.showMessageDialog(parent,"You don't select any files");
            }
                // Get the selected file
                  
            }
        });
    	
    	saveSubSequences.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) 
            { 
            	
            	if(mainParent.numberOfOpenedSeq > 0)
        		{
            	begindIndexarr=new int[mainParent.num];
        		endIndexarr=new int[mainParent.num];
            	
 
        		//to intialize the arrays
        		 for(int h=0;h<mainParent.num;h++)
        		 {
        			 begindIndexarr[h]=Integer.parseInt(""+mainParent.maxEndInFragments.get(h)+"");
        		 }
        		 for(int h=0;h<mainParent.num;h++)
        		 {
        			 endIndexarr[h]=0;
        		 }
        		 
            	for(int i = 0 ; i<parentPanel.selectedFragmentsIndex.size();i++)
                {
            			 StringTokenizer st = new StringTokenizer((String)parentPanel.selectedFragmentsIndex.get(i));
            			 int indexOfFragment = Integer.parseInt(st.nextToken());
            			 ProcessingFiles proFiles =(ProcessingFiles)parentPanel.proFilesArr.get(Integer.parseInt(st.nextToken()));
            			
           				 FragmentPosArrayList fragmentsPos = proFiles.arrToDrawTheFragments.get(indexOfFragment);
            			 for(int h=0;h<mainParent.num;h++)
            			 {
            				 int[] d = fragmentsPos.get(h);
            				 if(begindIndexarr[h] > d[0])
            					 begindIndexarr[h] = d[0];
            				 if(endIndexarr[h] < d[1])
            					 endIndexarr[h] = d[1];
            			 }
                	 }//end of for
        		
        		
            		 for(int i = 0 ; i<parentPanel.selectedRevFragmentsIndex.size();i++)
                	 {
            			 StringTokenizer st = new StringTokenizer((String)parentPanel.selectedRevFragmentsIndex.get(i));
            			 int indexOfFragment = Integer.parseInt(st.nextToken());
            			 ProcessingFiles proFiles =(ProcessingFiles)parentPanel.proFilesArr.get(Integer.parseInt(st.nextToken()));
            			 FragmentPosArrayList fragmentsPos;
            			 if(proFiles.arrOfReverseLocations.size() > 0)
            				 fragmentsPos = proFiles.arrToDrawTheFragments.get(indexOfFragment);
            			 else
            				 fragmentsPos = proFiles.arrToDrawTheRevFragments.get(indexOfFragment);
            			
            			 for(int h=0;h<mainParent.num;h++)
            			 {
            				 int[] d = fragmentsPos.get(h);
            				 if(begindIndexarr[h] > d[0])
            					 begindIndexarr[h] = d[0];
            				 if(endIndexarr[h] < d[1])
            					 endIndexarr[h] = d[1];
            			 }
                	 }//end of for
            	 
        		//---------------------------------------------
            		 for(int i = 0 ; i<parentPanel.selectedChainFileIndex.size();i++)
                     {
                 			 StringTokenizer st = new StringTokenizer((String)parentPanel.selectedChainFileIndex.get(i));
                 			 int indexOfFragment = Integer.parseInt(st.nextToken());
                 			 ProcessingFiles proFiles =(ProcessingFiles)parentPanel.proFilesArr.get(Integer.parseInt(st.nextToken()));
                 			
                				 FragmentPosArrayList fragmentsPos = proFiles.arrToDrawTheChainesFile.get(indexOfFragment);
                 			 for(int h=0;h<mainParent.num;h++)
                 			 {
                 				 int[] d = fragmentsPos.get(h);
                 				 if(begindIndexarr[h] > d[0])
                 					 begindIndexarr[h] = d[0];
                 				 if(endIndexarr[h] < d[1])
                 					 endIndexarr[h] = d[1];
                 			 }
                     	 }//end of for
             		
             		
                 		 for(int i = 0 ; i<parentPanel.selectedRevChainFileIndex.size();i++)
                     	 {
                 			 StringTokenizer st = new StringTokenizer((String)parentPanel.selectedRevChainFileIndex.get(i));
                 			 int indexOfFragment = Integer.parseInt(st.nextToken());
                 			 ProcessingFiles proFiles =(ProcessingFiles)parentPanel.proFilesArr.get(Integer.parseInt(st.nextToken()));
                 			 FragmentPosArrayList fragmentsPos;
                 			 if(proFiles.arrOfReverseLocations.size() > 0)
                 				 fragmentsPos = proFiles.arrToDrawTheChainesFile.get(indexOfFragment);
                 			 else
                 				 fragmentsPos = proFiles.arrToDrawTheRevChainesFile.get(indexOfFragment);
                 			
                 			 for(int h=0;h<mainParent.num;h++)
                 			 {
                 				 int[] d = fragmentsPos.get(h);
                 				 if(begindIndexarr[h] > d[0])
                 					 begindIndexarr[h] = d[0];
                 				 if(endIndexarr[h] < d[1])
                 					 endIndexarr[h] = d[1];
                 			 }
                     	 }//end of for
                 	 
            	//---------------------------------------------
                 		 //---------------------------------------------
                		 for(int i = 0 ; i<parentPanel.selectedCcnIndex.size();i++)
                         {
                     			 StringTokenizer st = new StringTokenizer((String)parentPanel.selectedCcnIndex.get(i));
                     			 int indexOfFragment = Integer.parseInt(st.nextToken());
                     			 ProcessingFiles proFiles =(ProcessingFiles)parentPanel.proFilesArr.get(Integer.parseInt(st.nextToken()));
                     			
                    				 FragmentPosArrayList fragmentsPos = proFiles.arrToDrawTheChaines.get(indexOfFragment);
                     			 for(int h=0;h<mainParent.num;h++)
                     			 {
                     				 int[] d = fragmentsPos.get(h);
                     				 if(begindIndexarr[h] > d[0])
                     					 begindIndexarr[h] = d[0];
                     				 if(endIndexarr[h] < d[1])
                     					 endIndexarr[h] = d[1];
                     			 }
                         	 }//end of for
                 		
                     		 for(int i = 0 ; i<parentPanel.selectedRevCcnIndex.size();i++)
                         	 {
                     			 StringTokenizer st = new StringTokenizer((String)parentPanel.selectedRevCcnIndex.get(i));
                     			 int indexOfFragment = Integer.parseInt(st.nextToken());
                     			 ProcessingFiles proFiles =(ProcessingFiles)parentPanel.proFilesArr.get(Integer.parseInt(st.nextToken()));
                     			 FragmentPosArrayList fragmentsPos;
                     			 if(proFiles.arrOfReverseLocations.size() > 0)
                     				 fragmentsPos = proFiles.arrToDrawTheChaines.get(indexOfFragment);
                     			 else
                     				 fragmentsPos = proFiles.arrToDrawTheRevChaines.get(indexOfFragment);
                     			
                     			 for(int h=0;h<mainParent.num;h++)
                     			 {
                     				 int[] d = fragmentsPos.get(h);
                     				 if(begindIndexarr[h] > d[0])
                     					 begindIndexarr[h] = d[0];
                     				 if(endIndexarr[h] < d[1])
                     					 endIndexarr[h] = d[1];
                     			 }
                         	 }//end of for
                     		 
                 //--------------------------------------------------
                  //---------------------------------------------
                    		 for(int i = 0 ; i<parentPanel.selectedClusterIndex.size();i++)
                             {
                         			 StringTokenizer st = new StringTokenizer((String)parentPanel.selectedClusterIndex.get(i));
                         			 int indexOfFragment = Integer.parseInt(st.nextToken());
                         			 ProcessingFiles proFiles =(ProcessingFiles)parentPanel.proFilesArr.get(Integer.parseInt(st.nextToken()));
                         			
                        				 FragmentPosArrayList fragmentsPos = proFiles.arrToDrawTheClusters.get(indexOfFragment);
                         			 for(int h=0;h<mainParent.num;h++)
                         			 {
                         				 int[] d = fragmentsPos.get(h);
                         				 if(begindIndexarr[h] > d[0])
                         					 begindIndexarr[h] = d[0];
                         				 if(endIndexarr[h] < d[1])
                         					 endIndexarr[h] = d[1];
                         			 }
                             	 }//end of for
                     		
                     		
                         		 for(int i = 0 ; i<parentPanel.selectedRevClusterIndex.size();i++)
                             	 {
                         			 StringTokenizer st = new StringTokenizer((String)parentPanel.selectedRevClusterIndex.get(i));
                         			 int indexOfFragment = Integer.parseInt(st.nextToken());
                         			 ProcessingFiles proFiles =(ProcessingFiles)parentPanel.proFilesArr.get(Integer.parseInt(st.nextToken()));
                         			 FragmentPosArrayList fragmentsPos;
                         			 if(proFiles.arrOfReverseLocations.size() > 0)
                         				 fragmentsPos = proFiles.arrToDrawTheClusters.get(indexOfFragment);
                         			 else
                         				 fragmentsPos = proFiles.arrToDrawTheRevClusters.get(indexOfFragment);
                         			
                         			 for(int h=0;h<mainParent.num;h++)
                         			 {
                         				 int[] d = fragmentsPos.get(h);
                         				 if(begindIndexarr[h] > d[0])
                         					 begindIndexarr[h] = d[0];
                         				 if(endIndexarr[h] < d[1])
                         					 endIndexarr[h] = d[1];
                         			 }
                             	 }//end of for
        		//--------------------------------------------------------
                 //to create sub sequences
        		//Show dialog; this method does not return until dialog is closed
                	fc.setDialogTitle("Choose the Directory....... ");
                	fc.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
                	int returnVal =  fc.showSaveDialog(parent);
                	
                    String s="";
                    if (returnVal == JFileChooser.APPROVE_OPTION) 
             	   {  
                     
                    	
                    		  s = (String)JOptionPane.showInputDialog(parent,"Write The Name of file : ","Save As........ ",JOptionPane.QUESTION_MESSAGE,
             	                    null,
             	                    null,
             	                    null); 
        			for(int h=0; h< mainParent.numberOfOpenedSeq;h++)
        			{
        				try
        				{
        					Sequence originalSeq =(Sequence) mainParent.arrOfSequences.get(h);
        					Sequence seq1 = DNATools.createDNASequence(originalSeq.subStr(begindIndexarr[h],endIndexarr[h]),originalSeq.getName()+"	The saved Range is:["+begindIndexarr[h]+","+endIndexarr[h]+"]");
        					SeqIOTools.biojavaToFile("fasta","dna",new FileOutputStream(new File(fc.getSelectedFile()+ ((VisChainerMain)parent).parent.fileDash+s+"_seq "+(h+1)+"fna")),seq1);
        				}
        				catch(Exception ex){JOptionPane.showMessageDialog(parent,"there are some sequences,its file doesn't open ","Warning",JOptionPane.WARNING_MESSAGE);}
        			}
                     
              	   //---------------------------------------------------------------------------------------------------
                 }
                 else
                 {
                 	JOptionPane.showMessageDialog(parent,"You don't select any files");
                 }
        		}//end of if(mainParent.numberOfOpenedSeq > 0)
            	else
            	{
            		JOptionPane.showMessageDialog(parent,"There is no opened sequences","Warning",JOptionPane.WARNING_MESSAGE);
            	}
            }
        });
    	
    	commandTextFiled.addKeyListener(new KeyAdapter()
 	   {
 	       public void keyTyped (KeyEvent e) 
 	        { 
 	            char c = e.getKeyChar() ;
 	                
 	            if ((c== KeyEvent.VK_ENTER)) 
 	            {
 	            	try{
 	            	Process p = Runtime.getRuntime().exec(commandTextFiled.getText());
 	            		String s="";
 	            		//Process p = Runtime.getRuntime().exec("ps -ef");
 	                   
 	                   BufferedReader stdInput = new BufferedReader(new 
 	                        InputStreamReader(p.getInputStream()));

 	                   BufferedReader stdError = new BufferedReader(new 
 	                        InputStreamReader(p.getErrorStream()));

 	                   // read the output from the command
 	                   
 	                   mainParent.toWriteInTheConsoleList("Here is the standard output of the command:\n");
 	                   while ((s = stdInput.readLine()) != null) {
 	                	  mainParent.toWriteInTheConsoleList(s);
 	                   }
 	                   
 	                   // read any errors from the attempted command

 	                  mainParent.toWriteInTheConsoleList("Here is the standard error of the command (if any):\n");
 	                   while ((s = stdError.readLine()) != null) {
 	                	  mainParent.toWriteInTheConsoleList(s);
 	                   }
 	                   
 	                  
 	            	}catch(Exception ex){}
 	           } 
 	        } 
 	    });
    	
    	//-------------------------------------
    	buttonBar.add(saveFragments);
    	buttonBar.add(saveSubSequences);
    	buttonBar.add(command);
    	buttonBar.add(commandTextFiled);
    	buttonBar.add(close);
    	
    	 this.getContentPane().add(buttonBar,BorderLayout.NORTH);
        getContentPane().add(splitPane);
        pack();
        
		
	}
	
	//-------------------------------------------
	//to get the selected fragment from the Vischainer or from itself
	//and draw the sequences in two genomes
	public void showSelectedFragment(ListModel arr,int selectedIndex)
	{
		
		if(selectedIndex < parentPanel.offset && parentPanel.selectedFragmentsIndex.size() > 0)
		{// to draw  the forward
		
			// to get the fragmnet --
			int h= selectedIndex;
			StringTokenizer st = new StringTokenizer((String)parentPanel.selectedFragmentsIndex.get(h));
			int indexOfFragment = Integer.parseInt(st.nextToken());
			ProcessingFiles proFiles =(ProcessingFiles)parentPanel.proFilesArr.get(Integer.parseInt(st.nextToken()));
			
			FragmentPosArrayList  arrf = proFiles.arrToDrawTheFragments.get(indexOfFragment);
			
			showSequencesInPanel(arrf);
			
		}//end if
		//--------------//--to draw the reverse ---------------------------
		if(selectedIndex >= parentPanel.offset && selectedIndex < parentPanel.offsetForChainFile && parentPanel.selectedRevFragmentsIndex.size() > 0)
		{//--to draw the reverse 
			int h = selectedIndex - parentPanel.offset ;
			StringTokenizer st = new StringTokenizer((String)parentPanel.selectedRevFragmentsIndex.get(h));
			int indexOfFragment = Integer.parseInt(st.nextToken());
			ProcessingFiles proFiles =(ProcessingFiles)parentPanel.proFilesArr.get(Integer.parseInt(st.nextToken()));
			
			FragmentPosArrayList  arrf;
			
			if(proFiles.arrOfReverseLocations.size()<=0)
				arrf = proFiles.arrToDrawTheFragments.get(indexOfFragment);
			else
				arrf = proFiles.arrToDrawTheRevFragments.get(indexOfFragment);
			
			showSequencesInPanel(arrf);
			
		}// end of if (> offset) to draw the reverse
		
		//---------
		if(selectedIndex >= parentPanel.offsetForChainFile && selectedIndex < parentPanel.offsetForRevChainFile  && parentPanel.selectedChainFileIndex.size() > 0)
		{// to draw  the forward
		
			// to get the fragmnet --
			int h= selectedIndex - parentPanel.offsetForChainFile;
			StringTokenizer st = new StringTokenizer((String)parentPanel.selectedChainFileIndex.get(h));
			int indexOfFragment = Integer.parseInt(st.nextToken());
			ProcessingFiles proFiles =(ProcessingFiles)parentPanel.proFilesArr.get(Integer.parseInt(st.nextToken()));
			
			FragmentPosArrayList  arrf = proFiles.arrToDrawTheChainesFile.get(indexOfFragment);
			
			showSequencesInPanel(arrf);
			
		}//end if
		//--------------//--to draw the reverse ---------------------------
		if(selectedIndex >= parentPanel.offsetForRevChainFile && selectedIndex < parentPanel.offsetForCcn &&parentPanel.selectedRevChainFileIndex.size() > 0)
		{//--to draw the reverse 
			int h = selectedIndex - parentPanel.offsetForRevChainFile ;
			StringTokenizer st = new StringTokenizer((String)parentPanel.selectedRevChainFileIndex.get(h));
			int indexOfFragment = Integer.parseInt(st.nextToken());
			ProcessingFiles proFiles =(ProcessingFiles)parentPanel.proFilesArr.get(Integer.parseInt(st.nextToken()));
			
			FragmentPosArrayList  arrf;
			
			if(proFiles.arrOfReverseLocations.size()<=0)
				arrf = proFiles.arrToDrawTheChainesFile.get(indexOfFragment);
			else
				arrf = proFiles.arrToDrawTheRevChainesFile.get(indexOfFragment);
			
			showSequencesInPanel(arrf);
			
		}// end of if (> offset) to draw the reverse
		
		//--------------------------
		if(selectedIndex >= parentPanel.offsetForCcn && selectedIndex < parentPanel.offsetForRevCcn  && parentPanel.selectedCcnIndex.size() > 0)
		{// to draw  the forward
		
			// to get the fragmnet --
			int h= selectedIndex - parentPanel.offsetForCcn;
			StringTokenizer st = new StringTokenizer((String)parentPanel.selectedCcnIndex.get(h));
			int indexOfFragment = Integer.parseInt(st.nextToken());
			ProcessingFiles proFiles =(ProcessingFiles)parentPanel.proFilesArr.get(Integer.parseInt(st.nextToken()));
			
			FragmentPosArrayList  arrf = proFiles.arrToDrawTheChaines.get(indexOfFragment);
			
			showSequencesInPanel(arrf);
			
		}//end if
		//--------------//--to draw the reverse ---------------------------
		if(selectedIndex >= parentPanel.offsetForRevCcn && selectedIndex < parentPanel.offsetForCluster &&parentPanel.selectedRevCcnIndex.size() > 0)
		{//--to draw the reverse 
			int h = selectedIndex - parentPanel.offsetForRevCcn ;
			StringTokenizer st = new StringTokenizer((String)parentPanel.selectedRevCcnIndex.get(h));
			int indexOfFragment = Integer.parseInt(st.nextToken());
			ProcessingFiles proFiles =(ProcessingFiles)parentPanel.proFilesArr.get(Integer.parseInt(st.nextToken()));
			
			FragmentPosArrayList  arrf;
			
			if(proFiles.arrOfReverseLocations.size()<=0)
				arrf = proFiles.arrToDrawTheChaines.get(indexOfFragment);
			else
				arrf = proFiles.arrToDrawTheRevChaines.get(indexOfFragment);
			
			showSequencesInPanel(arrf);
			
		}// end of if (> offset) to draw the reverse
		//------------------------------
		if(selectedIndex >= parentPanel.offsetForCluster && selectedIndex < parentPanel.offsetForRevCluster  && parentPanel.selectedClusterIndex.size() > 0)
		{// to draw  the forward
		
			// to get the fragmnet --
			int h= selectedIndex - parentPanel.offsetForCluster;
			StringTokenizer st = new StringTokenizer((String)parentPanel.selectedClusterIndex.get(h));
			int indexOfFragment = Integer.parseInt(st.nextToken());
			ProcessingFiles proFiles =(ProcessingFiles)parentPanel.proFilesArr.get(Integer.parseInt(st.nextToken()));
			
			FragmentPosArrayList  arrf = proFiles.arrToDrawTheClusters.get(indexOfFragment);
			
			showSequencesInPanel(arrf);
			
		}//end if
		//--------------//--to draw the reverse ---------------------------
		if(selectedIndex >= parentPanel.offsetForRevCluster &&parentPanel.selectedRevClusterIndex.size() > 0)
		{//--to draw the reverse 
			int h = selectedIndex - parentPanel.offsetForRevCluster ;
			StringTokenizer st = new StringTokenizer((String)parentPanel.selectedRevClusterIndex.get(h));
			int indexOfFragment = Integer.parseInt(st.nextToken());
			ProcessingFiles proFiles =(ProcessingFiles)parentPanel.proFilesArr.get(Integer.parseInt(st.nextToken()));
			
			FragmentPosArrayList  arrf;
			
			if(proFiles.arrOfReverseLocations.size()<=0)
				arrf = proFiles.arrToDrawTheClusters.get(indexOfFragment);
			else
				arrf = proFiles.arrToDrawTheRevClusters.get(indexOfFragment);
			
			showSequencesInPanel(arrf);
			
		}// end of if (> offset) to draw the reverse
		//----------------------------------------
	}//end of Method showSelectedFragment()
	//-------------------------------------------
	
	void showSequencesInPanel(FragmentPosArrayList  arrf)
	{
		
		MultiLineRenderer mlr = new MultiLineRenderer();	
  		SequenceRenderer seqR = new SymbolSequenceRenderer();
  		
		int[] fragmentPosIng1 = arrf.get(this.parentPanel.firstGenomeNum);	
		
		try
		{
		//-- for 1st genome
		
		Sequence seq1 = DNATools.createDNASequence(parentPanel.seqArr[0].subStr(Integer.parseInt(""+fragmentPosIng1[0]+""),Integer.parseInt(""+fragmentPosIng1[1]+"")),parentPanel.seqArr[0].getName());
	   	 
	
		
		 //set the Sequence to Render
		panel.setSequence(seq1);
		
//		display the whole Sequence
		panel.setRange(new RangeLocation(1,seq1.length()));
	      
	     
	      
	    mlr.addRenderer(seqR);
	    
	   
	 
	    }
	    catch(Exception ex)
	    {
	    	JOptionPane.showMessageDialog(parent,"U didn't open sequence File","Error",JOptionPane.ERROR_MESSAGE);
	    	
	    }

	    
		//-- for 2nd genome
		int[] fragmentPosIng2 = (int[])arrf.get(this.parentPanel.secondGenomeNum);	
		
		try
		{
		//-- for 1st genome
		
		Sequence seq2 = DNATools.createDNASequence(parentPanel.seqArr[1].subStr(Integer.parseInt(""+fragmentPosIng2[0]+""),Integer.parseInt(""+fragmentPosIng2[1]+"")),parentPanel.seqArr[1].getName());
  	
	    //set the Sequence to Render
		panel.setSequence(seq2);

	    //add Renderers to the MultiLineRenderer
	    
	    mlr.addRenderer(seqR);
	 
	    }
	    catch(Exception ex)
	    {
	    	JOptionPane.showMessageDialog(parent,"U didn't open sequence File","Error",JOptionPane.ERROR_MESSAGE);
	    	
	    }
		
		//----------------------------------------------------------------
		//set the MultiLineRenderer as the SequencePanels renderer
		try{
	    panel.setRenderer(mlr);
	  }catch(Exception ex){JOptionPane.showMessageDialog(parent,ex,"Error",JOptionPane.ERROR_MESSAGE);}
	}
	
	/**
	 * to save the selected fragments 
	 */
	void saveTheFilesFromSelectedVector(String s,Vector selectedArr,int ext) throws Exception
	{
		 BufferedWriter output;
		 
		 //to know the extension of the saved file
		 String extension = "";
		 
		 float[] arrOfScores = new float[1];
		 MyFragmentPosArrayListToDraw arrToDraw = new MyFragmentPosArrayListToDraw();
		 int[] chainId = new int[1];
		 float previousScore = -1;
		for(int i = 0 ; i<selectedArr.size();i++)
		{
   			StringTokenizer st = new StringTokenizer((String)selectedArr.get(i));
   			int indexOfFragment = Integer.parseInt(st.nextToken());
   			ProcessingFiles proFiles =(ProcessingFiles)parentPanel.proFilesArr.get(Integer.parseInt(st.nextToken()));
   			
   			
   			
      		if(proFiles.arrOfReverseLocations.size()>0)
   			{
      			if(ext == 1 || ext ==4)
          		{
       			arrOfScores = proFiles.arrOfFragmentScores;
       			arrToDraw = proFiles.arrToDrawTheFragments;
       			extension = "";
          		}
          	
          		
          		if(ext == 2 || ext ==5)
          		{
          		arrOfScores = proFiles.arrOfCcnScores ;
          		arrToDraw = proFiles.arrToDrawTheChaines;
          		extension = ".ccn";
          		}
          		
          		
          		if(ext == 7 || ext ==8)
          		{
          		arrOfScores = proFiles.arrOfFragmentChainScores;
          		arrToDraw = proFiles.arrToDrawTheChainesFile;
          		chainId = proFiles.arrOfFragmentChainID;
          		extension = ".chn";
          		}
          		
          		
          		if(ext == 3|| ext ==6)
          		{
          		arrToDraw = proFiles.arrToDrawTheClusters;
          		extension = ".cst";
          		}
          		
   				String transformString="";
   				for(int h=0; h<mainParent.num;h++)
   				{
   					boolean flagism=false;
   					ArrayList arr = (ArrayList)proFiles.arrOfReverseLocations.get(h);
   					
   					for(int hh=0;hh<arr.size();hh++)
   					{
   						int[] locations = (int[])arr.get(hh);
   						if(indexOfFragment>=locations[0] && indexOfFragment<=locations[1])
   							flagism = true;
   					}
   					if(flagism)
   						transformString +='m';
   					else
   						transformString +='p';
   				}//end of for(int h=0; h< ProcessingFiles.num;h++)
   				
   				 boolean exists = (new File(fc.getSelectedFile().getCanonicalFile()+((VisChainerMain)parent).parent.fileDash+s+"."+transformString+extension)).exists();
   				 String sLine1 ="" ,sLine2 ="";   
   				 if (exists) 
   				    {
   				        // File exists
   				    	BufferedReader br = new BufferedReader(new FileReader(fc.getSelectedFile().getCanonicalFile()+((VisChainerMain)parent).parent.fileDash+s+"."+transformString+extension));
   				    	do
   				    	{
   				    		sLine1 = br.readLine();
   				    		if(sLine1 != null)
   				    			sLine2+=sLine1+"\n";
   				    	}while(sLine1 != null);
   				    	output= new BufferedWriter( new FileWriter(fc.getSelectedFile().getCanonicalFile()+((VisChainerMain)parent).parent.fileDash+s+"."+transformString+extension) );
           		 		output.write(sLine2);
   				    } 
   				    else 
   				    {
   				        // File  does not exist
   				    	output= new BufferedWriter( new FileWriter(fc.getSelectedFile().getCanonicalFile()+((VisChainerMain)parent).parent.fileDash+s+"."+transformString+extension) );
           		 		if(ext != 3 && ext != 6)
   				    	output.write(">CHA "+mainParent.num+"\n");
           		 		
   				    }
   				
   				if(ext != 3 && ext != 6 && ext != 7 && ext != 8)
   				{
   				 float score = arrOfScores[indexOfFragment]; 
      				 output.write("#"+score+"\n");
      
   				}
   				if(ext == 7 || ext == 8)
   				{
   					float score = arrOfScores[chainId[indexOfFragment]-1];
   					if(previousScore != score)
     				 output.write("#"+score+"\n");	 
   					previousScore = score;
   				}
   				if(ext ==  3 || ext == 6)
   				{
   				output.write("#cluster"+"\n");
   				}
   				FragmentPosArrayList fragmentPos = arrToDraw.get(indexOfFragment);
       			int[] d = fragmentPos.get(0);	
       			String writingLine ="";
       			
   		 		for(int h=0;h<mainParent.num;h++)
   		 		{
   		 			d = fragmentPos.get(h);	
   		 			if(transformString.charAt(h)=='m')
   		 			{
   		 				if(mainParent.openNewLog){
   		 					JOptionPane.showMessageDialog(mainParent, "You must open info/log file , there is reverse fragments","Open Log File....",JOptionPane.INFORMATION_MESSAGE);
   		 					ProcessingFiles proFiles1 = new ProcessingFiles(mainParent);
   		 					boolean openNewLog1  = proFiles1.openLogFileForMultipleGenomes();
   		 					if(openNewLog1)
   		 					{
   		 						//here add the profiles object which contian the information of the log file
   		 						//mainParent.proFilesArr.add(proFiles1);
   		 						mainParent.openNewLog = false;
   		 					}
   		 				}//end of if(openNewLog)
   		 				if(!mainParent.openNewLog)
   		 				writingLine +="["+(mainParent.logFile.get(h)-d[1])+","+(mainParent.logFile.get(h)-d[0])+"]";
   		 				
   		 			}
   		 			else
   		 			{
   		 				writingLine +="["+d[0]+","+d[1]+"]";
   		 			}
   		 		}
   		 		output.write(writingLine+"\n");
       			output.close();
   			}//end of 	if(proFiles.arrOfReverseLocations.size()>0)
   			else
   			{
   				if(ext == 1)
   	      		{
   	   			arrOfScores = proFiles.arrOfFragmentScores;
   	   			arrToDraw = proFiles.arrToDrawTheFragments;
   	   			extension = "";
   	      		}
   	      		if(ext == 4)
   	      		{
   	      		arrOfScores = proFiles.arrOfRevFragmentScores;
   	      		arrToDraw = proFiles.arrToDrawTheRevFragments;
   	      		extension = "";
   	      		}
   	      		
   	      		if(ext == 2)
   	      		{
   	      		arrOfScores = proFiles.arrOfCcnScores ;
   	      		arrToDraw = proFiles.arrToDrawTheChaines;
   	      		extension = ".ccn";
   	      		}
   	      		if(ext == 5)
   	      		{
   	      		arrOfScores = proFiles.arrOfRevCcnScores;
   	      		arrToDraw = proFiles.arrToDrawTheRevChaines;
   	      		extension = ".ccn";
   	      		}
   	      		
   	      		if(ext == 7)
   	      		{
   	      		arrOfScores = proFiles.arrOfFragmentChainScores;
   	      		arrToDraw = proFiles.arrToDrawTheChainesFile;
   	      		chainId = proFiles.arrOfFragmentChainID;
   	      		extension = ".chn";
   	      		}
   	      		
   	      		if(ext == 8)
   	      		{
   	      		arrOfScores = proFiles.arrOfRevFragmentChainScores;
   	      		arrToDraw = proFiles.arrToDrawTheRevChainesFile;
   	      		chainId= proFiles.arrOfRevFragmentChainID;
   	      		extension = ".chn";
   	      		}
   	      		if(ext == 3)
   	      		{
   	      		arrToDraw = proFiles.arrToDrawTheClusters;
   	      		extension = ".cst";
   	      		}
   	      		if(ext == 6)
   	      		{
   	      		arrToDraw = proFiles.arrToDrawTheRevClusters;
   	      		extension = ".cst";
   	      		}
   	      		
   				String transformString="";
   				int index1 = proFiles.filePath.lastIndexOf('.');
   		 		int index = index1;
   				//in case of file format not fragment the end of the file name contians the .ccn , .chn or.cst
   				
   				if(!(ext ==1 || ext == 4))
   					{
   					index = proFiles.filePath.lastIndexOf('.', index1-1);
   					if (index > 0 &&  index < proFiles.filePath.length() - 1)
   						transformString = proFiles.filePath.substring(index+1,index1).toLowerCase();
   					}
   				else
   				{
   					if (index > 0 &&  index < proFiles.filePath.length() - 1)
   						transformString = proFiles.filePath.substring(index+1).toLowerCase();
   				}
   		 		 boolean exists = (new File(fc.getSelectedFile().getCanonicalFile()+((VisChainerMain)parent).parent.fileDash+s+"."+transformString+extension)).exists();
   				 String sLine1 ="" ,sLine2 ="";   
   				 if (exists) 
   				    {
   				        // File exists
   				    	BufferedReader br = new BufferedReader(new FileReader(fc.getSelectedFile().getCanonicalFile()+((VisChainerMain)parent).parent.fileDash+s+"."+transformString+extension));
   				    	do
   				    	{
   				    		sLine1 = br.readLine();
   				    		if(sLine1 != null)
   				    			sLine2+=sLine1+"\n";
   				    	}while(sLine1 != null);
   				    	output= new BufferedWriter( new FileWriter(fc.getSelectedFile().getCanonicalFile()+((VisChainerMain)parent).parent.fileDash+s+"."+transformString+extension) );
           		 		output.write(sLine2);
   				    } 
   				    else 
   				    {
   				        // File  does not exist
   				    	output= new BufferedWriter( new FileWriter(fc.getSelectedFile().getCanonicalFile()+((VisChainerMain)parent).parent.fileDash+s+"."+transformString+extension) );
   				    	
   				    	if(ext != 3 && ext != 6)
   				    	output.write(">CHA "+mainParent.num+"\n");
   				    }
   				 
   				if(ext != 3 && ext != 6 && ext != 7 && ext != 8)
   				{
   				 float score = arrOfScores[indexOfFragment]; 
      				 output.write("#"+score+"\n");
      
   				}
   				if(ext == 7 || ext == 8)
   				{
   					float score = arrOfScores[chainId[indexOfFragment]-1];
   					if(previousScore != score)
     				 output.write("#"+score+"\n");	 
   					previousScore = score;
   				}
   				if(ext ==  3 || ext == 6)
   				{
   				output.write("#cluster"+"\n");
   				}
           		FragmentPosArrayList fragmentPos =arrToDraw.get(indexOfFragment);
       			int[] d = fragmentPos.get(0);	
       			String writingLine ="";
       			
   		 		for(int h=0;h<mainParent.num;h++)
   		 		{
   		 			d = fragmentPos.get(h);	
   		 			if(transformString.charAt(h)=='m')
   		 			{
   		 			if(mainParent.openNewLog){
		 					JOptionPane.showMessageDialog(mainParent, "You must open info/log file , there is reverse fragments","Open Log File....",JOptionPane.INFORMATION_MESSAGE);
		 					ProcessingFiles proFiles1 = new ProcessingFiles(mainParent);
		 					boolean openNewLog1  = proFiles1.openLogFileForMultipleGenomes();
		 					if(openNewLog1)
		 					{
		 						//here add the profiles object which contian the information of the log file
		 						//mainParent.proFilesArr.add(proFiles1);
		 						mainParent.openNewLog = false;
		 					}
		 				}//end of if(openNewLog)
		 				if(!mainParent.openNewLog)
   		 				writingLine +="["+(mainParent.logFile.get(h)-d[1])+","+(mainParent.logFile.get(h)-d[0])+"]";
   		 			}
   		 			else
   		 			{
   		 				writingLine +="["+d[0]+","+d[1]+"]";
   		 			}
   		 		}
   		 		output.write(writingLine+"\n");
       			output.close();
   			}//end else

   	 }//end of for(int i = 0 ; i<selectedArr.size();i++)
	}//end of the method
	
	
} //end of class
