/*
*Draw Panel.java 
*
*
*the working panel where the plotting is done
*
*the panel where the projection draw,
*the selection function [binary search]
*the zoom function
*the color options and all drawing options
*
*Asem A. Othman
*/
import java.awt.*;
import java.awt.image.*;
import java.util.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.imageio.*;
import java.io.*;
import java.text.*;
import org.biojava.bio.seq.*;
import org.biojava.bio.seq.io.SeqIOTools;
import org.biojava.bio.gui.sequence.*;

import com.jgoodies.looks.BorderStyle;

public class DrawPanel extends JPanel
{
	//->Variables
	//to get the length of genomes,which will draw in this panel
	//and there scale happen to the drawing point according to these values
	//and they update when read any file or sequence file, which contian the real length of the genome
	public int firstEnd = 0;
	public int secondEnd =0;
	
	//To know what it will take from the profile object
	public int firstGenomeNum=-1;//the index of the first genome here in the array of the genomes
	public int secondGenomeNum=-1;

	
	public ArrayList proFilesArr = new ArrayList();

	
    //falges to know what will appear in the plot
	//these flages update in the action listener of the check box
    public boolean drawFrag = false;
    public boolean drawChain = false;
    public boolean drawChainFile = false;
    public boolean drawCluster = false;
    
    public boolean drawRevFrag = false;
    public boolean drawRevChain = false;
    public boolean drawRevChainFile = false;
    public boolean drawRevCluster = false;
    
    public boolean drawChainConnection = false;
    
    //the colors of the lines
    public Color drawFragColor = new Color(255,100,100);
    public Color drawChainColor = new Color(255,50,255);
    public Color drawChainFileColor = new Color(0,128,128);
    public Color drawClusterColor = new Color(0,205,0);
    
    public Color drawRevFragColor = new Color(0,0,0);
    public Color drawRevChainColor = new Color(255,0,0);
    public Color drawRevChainFileColor = new Color(255,250,0);
    public Color drawRevClusterColor = new Color(128,0,128);
    
    //the points of the drawn axis
    Point p1 = new Point(10,518);//		    |p2
    Point p2 = new Point(10,10);//		    | 
    Point p3 = new Point(10,518);//		    |
    Point p4 = new Point(519,518);//    	|-------- p4
    
    
    //for zoom  reset
//  the points of the drawn axis
    Point p1_old = new Point(10,518);//		    |p2
    Point p2_old = new Point(10,10);//		    | 
    Point p3_old = new Point(10,518);//		    |
    Point p4_old = new Point(519,518);//    	|-------- p4

	/**
	 * 
	 * @uml.property name="seqArr"
	 * @uml.associationEnd multiplicity="(0 -1)"
	 */
	//---------------------------//		             p3,p1	
	//the variables of 2 genomes
	//->the sequences
	Sequence[] seqArr = new Sequence[2];

	/**
	 * 
	 * @uml.property name="panelMouseListener"
	 * @uml.associationEnd multiplicity="(1 1)" inverse="this$0:DrawPanel$PanelMouseListener"
	 */
	//the listener to the mouse[select and zoom]
	PanelMouseListener panelMouseListener = new PanelMouseListener();

    
    //to draw rectangle when select from the panel 
    Rectangle selectRect= new Rectangle(0,0,0,0); 
    //flag for the selection mode, to capture image and draw the rectangle
    boolean selectFlag = false;
    
    
	

	/**
	 * 
	 * @uml.property name="selectedRevFragmentsIndex"
	 * @uml.associationEnd multiplicity="(0 -1)" elementType="java.lang.String"
	 */
    //to store the index of selected fragments
    //the decleration in the selection function
    Vector selectedFragmentsIndex ;
	Vector selectedRevFragmentsIndex;
    Vector selectedChainFileIndex;
    Vector selectedRevChainFileIndex;
    Vector selectedCcnIndex;
    Vector selectedRevCcnIndex;
    Vector selectedClusterIndex;
    Vector selectedRevClusterIndex;
	
    //For the selection method.....
    //when showing the selected fragments in the list there are offset
	//in indecies with respect to its arrange in its array
	int offset;//for there the reverse fragments
	int offsetForChainFile;
	int offsetForRevChainFile;
	int offsetForCcn;
	int offsetForRevCcn;
	int offsetForCluster;
	int offsetForRevCluster;
    
	//- to draw with specific pen
	BasicStroke stroke2f = new BasicStroke(2f);
	BasicStroke stroke1f = new BasicStroke(1f);
	float dash1[] = {10.0f};
	float dash2[] = {5.0f};
	BasicStroke selectStroke = new BasicStroke(2.0f, 
                                                      BasicStroke.CAP_BUTT, 
                                                      BasicStroke.JOIN_MITER, 
                                                      10.0f, dash1, 0.0f);
	

	//Stroke for the coneection in the chain
	BasicStroke chainStroke = new BasicStroke(1.0f, 
            BasicStroke.CAP_SQUARE, 
            BasicStroke.JOIN_MITER, 
            10.0f, dash2, 0.0f);

	//array lists contain  elements ,which arethe array of the sorted indecies of the fragments,
	//for each object in the profiles Arr.
	ArrayList SortedIndeciesOfFragments = new ArrayList();
	ArrayList SortedIndeciesOfRevFragments = new ArrayList();
	
	ArrayList SortedIndeciesOfChainFile = new ArrayList();
	ArrayList SortedIndeciesOfRevChainFile = new ArrayList();

	ArrayList SortedIndeciesOfCcn = new ArrayList();
	ArrayList SortedIndeciesOfRevCcn = new ArrayList();
	
	ArrayList SortedIndeciesOfCluster = new ArrayList();
	ArrayList SortedIndeciesOfRevCluster = new ArrayList();
	
	
	//-  the image buffer to capture the screen
	BufferedImage backGroundImage;  // declare the image
	Graphics2D g;
	int widthOfImage= 0;
	int heightOfImage =0;
	//------------------
	
	//-[flag]this panel have array of all the objects of the files..so if it will darw only one file in new window, the flag become true
	public boolean  forNewWindow = false;
	int forNewWindowIndex =-1;

	//the refrence to the window on it this panel
	VisChainerPanel parent;

	JScrollPane scrollPane;

	//-------------------------------------------
	
	
	//---- To Zoom
	double  zoomFactorX = 1;
	double  zoomFactorY = 1;
	Point centerForZooming = new Point(0,0);
	
	
	//---the charcter font size
	int charcterFontSize = 10 ;
	int rulerStep = 50;//for the step between the step in the ruler--and size of the row headear will equal it..which take the 5 character
	int sizeOfXruler = 25;//for the size of the column header in y..but it x ruler
	
	//--object from the system to capture the image
	private Robot robot ;
	
	float threshold = (float)0;
	
	int length_threshold = 0;
	
	
	
	/*
	 * the constractoe
	 * param>the parent window
	 * param>the scroll pane that will add to it the ruler and move it after make zooming
	 */
	DrawPanel(VisChainerPanel p,JScrollPane scp)
	{
		super();
		parent = p;
		scrollPane = scp;
		
		
		setBackground(Color.white);
		//--add the listener
		this.addMouseListener(this.panelMouseListener);
		this.addMouseMotionListener(this.panelMouseListener);
		//--creat the object of the robot
		try {
		      robot = new Robot();
		    } catch (AWTException awte) {
		      awte.printStackTrace();} 
		 //--make the ruler in the begining
		    makeRuler();   
	}
	
	/*
	 * capture 
	 * this method will capture image form the window opened 
	 * return>buffered image ...to draw or to export as file
	 */
	 BufferedImage capture() 
	 {
	      Rectangle screen = scrollPane.getViewport().getViewRect();
	      Point loc = screen.getLocation();
	      SwingUtilities.convertPointToScreen(loc,DrawPanel.this);
	      screen.setLocation(loc);
	      return robot.createScreenCapture(screen);
	  }
	 
	 ///---------- set ruler mode
	 /*
	  * setrulerMode
	  * param> range which will draw in the panel, in the ruler
	  * and return the number of the mode
	  * 1> normal
	  * 2>skip
	  * 3>write expontional number
	  * this mode according the ruler step and the character font size..
	  */
	 int setRulerMode(int range)
	 {
		 int rulerDrawingMode=1;
		 String temp = ""+range+"";
	     if((float)rulerStep/(float)charcterFontSize  > (temp.length()-2) )
	     {
	    	 rulerDrawingMode =1;//draw normally
	     }
	     else
	    	 if((float)rulerStep/(float)charcterFontSize  > (temp.length()*2-2))
	    	 {
		    	 rulerDrawingMode =2;//skip
		     }
	    	 else
	    	 {
	    		 rulerDrawingMode =3;//exponential mode
	    	 }
	     return rulerDrawingMode;
	 }
	 
	 /*
	  * draw the ruler
	  */
	 void makeRuler()
	 {
		 JLabel[] corners = new JLabel[4];
	     for (int i = 0; i < 4; i++) {
	       corners[i] = new JLabel();
	       corners[i].setBackground(Color.white);
	       corners[i].setOpaque(true);
	     }

	        
	     JLabel rowheader = new JLabel() {
	       public void paintComponent(Graphics g) {
	         super.paintComponent(g);
	         g.setColor(Color.black);
	         Rectangle rect = g.getClipBounds();
	         int rulerDrawingMode = setRulerMode( (int)(((rect.getY())-p1.y)*-1*((float)secondEnd/(float)Math.abs(p1.y-p2.y))));
	         if(rulerDrawingMode==1 || rulerDrawingMode==2 ){
	         for (int i = rulerStep - (rect.y % rulerStep); i < rect.height; i += rulerStep) {
	           g.drawLine(rulerStep-3, rect.y + i, rulerStep, rect.y + i);
	           
	           int newY = (int)(((rect.y+i)-p1.y)*-1*((float)secondEnd/(float)Math.abs(p1.y-p2.y)));
	           
	           g.drawString("" + (newY), 6, rect.y + i + 3);
	         }//end of for
	         }//end of if
	        
	         if(rulerDrawingMode==3){
	        	 
	        	 DecimalFormat formatter = new DecimalFormat("###E0");  // exponent must be multiple of 3;
	        	 String s;
		         for (int i = rulerStep - (rect.y % rulerStep); i < rect.height; i += rulerStep) {
		           g.drawLine(rulerStep-3, rect.y + i, rulerStep, rect.y + i); 
		           int newY = (int)(((rect.y+i)-p1.y)*-1*((float)secondEnd/(float)Math.abs(p1.y-p2.y)));
		           s = formatter.format(newY); 
		           g.drawString("" + (s), 6, rect.y + i + 3);
		         }//end of for
		         }//end of if
	       }

	       public Dimension getPreferredSize() {
	         return new Dimension(rulerStep, (int) DrawPanel.this.getPreferredSize()
	             .getHeight());
	       }
	     };
	     rowheader.setBackground(Color.white);
	     rowheader.setOpaque(true);

	     
	     
	    	JLabel columnheader = new JLabel() {
	       public void paintComponent(Graphics g) {
	         super.paintComponent(g);
	         g.setColor(Color.black);
	         Rectangle r = g.getClipBounds();
	        int rulerDrawingMode = setRulerMode( (int)(((r.getMaxX())-p1.x)*((float)firstEnd/(float)Math.abs(p4.x-p3.x))));
	         if(rulerDrawingMode==1){
	         for (int i = rulerStep - (r.x % rulerStep); i < r.width; i += rulerStep) {
	           g.drawLine(r.x + i,sizeOfXruler-3, r.x + i, sizeOfXruler);
	           int newX = (int)(((r.x + i)-p1.x)*((float)firstEnd/(float)Math.abs(p4.x-p3.x)));
	           g.drawString("" +newX , r.x + i - 10, 16);
	         }//end of for
	         }//end of if
	         if(rulerDrawingMode==2){
		         for (int i = rulerStep - (r.x % rulerStep); i < r.width; i += (rulerStep*2)) {
		           g.drawLine(r.x + i, sizeOfXruler-3, r.x + i, sizeOfXruler);
		           int newX = (int)(((r.x + i)-p1.x)*((float)firstEnd/(float)Math.abs(p4.x-p3.x)));
		           g.drawString("" +newX , r.x + i - 10, 16);
		         }//end of for
		         }//end of if
	         if(rulerDrawingMode==3){
	        	 DecimalFormat formatter = new DecimalFormat("###E0");  // exponent must be multiple of 3;
	        	 String s;
		         for (int i = rulerStep - (r.x % rulerStep); i < r.width; i += rulerStep) {
		           g.drawLine(r.x + i, sizeOfXruler-3, r.x + i, sizeOfXruler);
		           int newX = (int)(((r.x + i)-p1.x)*((float)firstEnd/(float)Math.abs(p4.x-p3.x)));
		            s = formatter.format(newX); 
		           g.drawString("" +s , r.x + i - 10, 16);
		         }//end of for
		         }//end of if
	       }

	       public Dimension getPreferredSize() {
	         return new Dimension((int) DrawPanel.this.getPreferredSize().getWidth(),
	        		 sizeOfXruler);
	       }
	     };
	     columnheader.setBackground(Color.white);
	     columnheader.setOpaque(true);

	    scrollPane.setRowHeaderView(rowheader);
	    scrollPane.setColumnHeaderView(columnheader);
	    scrollPane.setCorner(JScrollPane.LOWER_LEFT_CORNER, corners[0]);
	    scrollPane.setCorner(JScrollPane.LOWER_RIGHT_CORNER, corners[1]);
	    scrollPane.setCorner(JScrollPane.UPPER_LEFT_CORNER, corners[2]);
	    scrollPane.setCorner(JScrollPane.UPPER_RIGHT_CORNER, corners[3]);
	     
	    
	 }
	 
	//paint function
	 /*
	  * paint function of the panel
	  * override on the paint function in the super class
	  */
	public void paint(Graphics g1) 
	{
		super.paint(g1);
		if(selectFlag)
		{	
			
		if(backGroundImage == null)
			backGroundImage = capture();
		
		Graphics2D gc = (Graphics2D)g1;

		Rectangle screen = scrollPane.getViewport().getViewRect();
        gc.drawImage(backGroundImage,screen.x,screen.y,null);
		gc.setStroke(selectStroke);
		
		//to draw select rectangle 
		gc.setColor(new Color(0,128,200));
		gc.drawRect(this.selectRect.x,this.selectRect.y,this.selectRect.width,this.selectRect.height);
		
		}
		else
		{
			backGroundImage=null;
			Graphics2D g = (Graphics2D)g1;
			toDraw(g);
		}
	}
	//----------------------------------------------------------------------
	/*
	 * to draw
	 * this the method which will draw the axis and then pass on all the file objects in the 
	 * profiles arr and draw the file according to the flag and the color
	 * the points will draw in another method,this method send the array list of the fragment postion to it
	 */
	void toDraw(Graphics2D g)
	{
		
//		 to darw axis
        this.drawAxis(g);
        for(int i =0 ; i< proFilesArr.size();i++)
		{
		ProcessingFiles proFiles =(ProcessingFiles)proFilesArr.get(i);
		
		//to check if this panel in new wendow so no overlay
		//to check if the object of the file is for new window not for overlay
		if( this.forNewWindow != proFiles.forNewWindow)
			continue;
		if(this.forNewWindow && i != forNewWindowIndex)
			continue;
		
		g.setStroke(stroke2f);
		
		//g.setColor(drawChainFileColor);
		if(drawChainFile && ! (proFiles.arrOfReverseLocations.size() > 0))
		this.drawChaines(g,proFiles.arrToDrawTheChainesFile,proFiles,3);
		
		if((drawChainFile || drawRevChainFile) &&  (proFiles.arrOfReverseLocations.size() > 0))
		this.drawChainesForMultiple(g,proFiles.arrToDrawTheChainesFile , proFiles,3,drawChainFile,drawRevChainFile);
	
		//g.setColor(drawChainColor);
		if(drawChain && ! (proFiles.arrOfReverseLocations.size() > 0))
		this.drawChaines(g,proFiles.arrToDrawTheChaines,proFiles,4);
		
		if((drawChain || drawRevChain) &&  (proFiles.arrOfReverseLocations.size() > 0))
		this.drawChainesForMultiple(g,proFiles.arrToDrawTheChaines, proFiles,4,drawChain, drawRevChain);
		
		//g.setColor(drawClusterColor);
		if(drawCluster&& ! (proFiles.arrOfReverseLocations.size() > 0))
		this.drawChaines(g,proFiles.arrToDrawTheClusters,proFiles,5);
		
		if((drawCluster || drawRevCluster) &&  (proFiles.arrOfReverseLocations.size() > 0))
		this.drawChainesForMultiple(g,proFiles.arrToDrawTheClusters,proFiles,5,drawCluster,drawRevCluster);
		
		//g.setColor(drawRevChainFileColor);
		if(drawRevChainFile&& ! (proFiles.arrOfReverseLocations.size() > 0))
		this.drawChaines(g,proFiles.arrToDrawTheRevChainesFile,proFiles,6);
		
		//g.setColor(drawRevChainColor);
		if(drawRevChain && ! (proFiles.arrOfReverseLocations.size() > 0))
		this.drawChaines(g,proFiles.arrToDrawTheRevChaines,proFiles,7);
		
		//g.setColor(drawRevClusterColor);
		if(drawRevCluster && ! (proFiles.arrOfReverseLocations.size() > 0))
		this.drawChaines(g,proFiles.arrToDrawTheRevClusters,proFiles,8);
		
		g.setStroke(stroke1f);
		//--------- to draw the forward ------
		//g.setColor(drawFragColor);
		if(drawFrag && ! (proFiles.arrOfReverseLocations.size() > 0))
		this.drawChaines(g,proFiles.arrToDrawTheFragments,proFiles,1);
		if((drawFrag || drawRevFrag) &&  (proFiles.arrOfReverseLocations.size() > 0))
		this.drawChainesForMultiple(g,proFiles.arrToDrawTheFragments , proFiles,1,drawFrag , drawRevFrag);
		
		//--------- to draw Reverse --------
		//g.setColor(drawRevFragColor);
		if(drawRevFrag && ! (proFiles.arrOfReverseLocations.size() > 0))
		this.drawChaines(g,proFiles.arrToDrawTheRevFragments,proFiles,2);
		
		
		
		}//end of loop on proFilesArr
	}
	//-----------------------------------------------------------------------
	//---------- Draw Axis -------------
	void drawAxis(Graphics g)
	{
		//to draw the box
		g.setColor(new Color(0,0,0));
		g.drawRect(2,2,p4.x+10,p4.y+10);
	}
	
	//----------------------------------------------------------------------
	// DARW THE FRAGMENTS in 2D plot 
	//// DARW THE CHIANES in 2D plot
	//// DARW THE Clusters in 2D plot
	/////////////////////------------------------------------------------
	//				TO DRAW THE REVRSE FILE.
	//-------------------------------------------------------------------
	// DARW THE FRAGMENTS in 2D plot 
	//// DARW THE CHIANES in 2D plot 
	//// DARW THE Clusters in 2D plot   
	/*
	 * drawChaines method
	 * param>the graphics object
	 * param>arrListToDraw is array of the fragment postion , which should draw
	 * param>extension to know the kind of the file , to set the color for the spesific fragments..if read from multiple genomes...file....
	 * all the fragments from all file are in same array array..so this function will search for the reverse in this array by another array contians the reverse loction for each 
	 * genomes in this file ............
	 */
	public  void drawChaines(Graphics g, MyFragmentPosArrayListToDraw arrListToDraw,ProcessingFiles proFiles,int extension)
	 {
		float forG1 = (float)Math.abs(p4.x-p1.x)/(float)firstEnd;
		float forG2 = (float)Math.abs(p1.y-p2.y)/(float)secondEnd;
//		 to know which genomes are reverse if exit,,,to make transformation only to reverse
  		String transformString="";
  		
  		if(extension ==1 || extension ==2)
	 	{
	     if(proFiles.filePath.length() > 0) 
			  {String s = proFiles.filePath.substring(0,proFiles.filePath.length());
			  int index = s.lastIndexOf('.');	
			  if (index > 0 &&  index < s.length() - 1)
				  	transformString = s.substring(index+1).toLowerCase();
			  }
	 	}
  		else
		 	{
		     if(proFiles.filePath.length() > 0) 
  			  {String s = proFiles.filePath.substring(0,proFiles.filePath.length()-4);
  			  int index = s.lastIndexOf('.');	
  			  if (index > 0 &&  index < s.length() - 1)
  				  	transformString = s.substring(index+1).toLowerCase();
  			  }
		 	}
  		// ---------------------------------------------------------------------------------------------
 		 Color color1 = this.drawFragColor;
		 Color color2 = this.drawRevFragColor;
		 
		 /**
		  * to draw the line connect between the fragments in the chain
		  */
		 int[] previousPoint = new int[2];
		 int[] chainID = new int[1];
		 
		 
		 if(extension ==3 || extension ==6)
			{
				 color1 = this.drawChainFileColor;
				 color2 = this.drawRevChainFileColor;
					
				if(extension == 3 )
					chainID = proFiles.arrOfFragmentChainID;
				if(extension == 6)
					chainID = proFiles.arrOfRevFragmentChainID;
						
			 }
		 if(extension ==4 || extension ==7)
			{
				 color1 = this.drawChainColor;
				 color2 = this.drawRevChainColor;
			 }
		 if(extension ==5 || extension ==8)
			{
				 color1 = this.drawClusterColor;
				 color2 = this.drawRevClusterColor;
			 }
		 
		 
		 for(int i=0; i< arrListToDraw.size();i++)
		 	{
		
			 /***********************************************************************
			  * Filteration
			  * *********************************************************************
			  */
			 if(extension == 1)
			 {
			 if(!proFiles.filterFragments(i, threshold, proFiles.arrOfFragmentScores,arrListToDraw,length_threshold,false))
				 continue;
			 }
			 if(extension == 2)
			 {
			 if(!proFiles.filterFragments(i, threshold, proFiles.arrOfRevFragmentScores,arrListToDraw,length_threshold,false))
				 continue;
			 }
			 if(extension == 4)
			 {
			 if(!proFiles.filterFragments(i, threshold, proFiles.arrOfCcnScores,arrListToDraw,length_threshold,false))
				 continue;
			 }
			 if(extension == 7)
			 {
			 if(!proFiles.filterFragments(i, threshold, proFiles.arrOfRevCcnScores,arrListToDraw,length_threshold,false))
				 continue;
			 }
			 if(extension == 3)
			 {
			 if(!proFiles.filterFragments(proFiles.arrOfFragmentChainID[i]-1, threshold, proFiles.arrOfFragmentChainScores,arrListToDraw,length_threshold,true))
			 continue;
			 }
			 if(extension ==6 )	 
			 {
			 if(!proFiles.filterFragments(proFiles.arrOfRevFragmentChainID[i]-1, threshold, proFiles.arrOfRevFragmentChainScores,arrListToDraw,length_threshold,true))
			 continue;
			 }
		/*************************************************************************************************/
		 
			  int[] arrToDraw = new int[4];
				
			    FragmentPosArrayList fragmentPos = arrListToDraw.get(i);
				int[] d =(int[])fragmentPos.get( this.firstGenomeNum);
				arrToDraw[0] = d[0];
				arrToDraw[1] = d[1];
				d =(int[])fragmentPos.get( this.secondGenomeNum);
				arrToDraw[2] = d[0];
				arrToDraw[3] = d[1];
				if(transformString.charAt(this.firstGenomeNum)=='m')//if first genome m
				{
					if(transformString.charAt(this.secondGenomeNum)=='m')//if second genome m
					{
						//nothing happen
						g.setColor(color1);//and draw the same color of forward
					}
					else//if second genome m
					{//it will swap
						int  t = arrToDraw[2];
						 arrToDraw[2] = arrToDraw[3];
						 arrToDraw[3] =  t;
						 g.setColor(color2);//the color of reverse
					}
				}
				else//if first genome p
				{
					if(transformString.charAt(this.secondGenomeNum)=='m')//only if second genome is m 
					{//the swap happen
					 int  t = arrToDraw[2];
					 arrToDraw[2] = arrToDraw[3];
					 arrToDraw[3] =  t;
					 g.setColor(color2);//the color of reverse
					}
					else
					{
						g.setColor(color1);
					}
				}
//				--------------------------------------------------------------
		 		int[] p = drawingPoints(arrToDraw,forG1,forG2);			
		 		//----------------------------------------------------------------
		 		//[0]-->s1 , [1]-->e1,[2]-->s2  ,[3]-->e2
				// to draw line in 2D plot for fragments p1=s1,s2  and p2= e1,e2
				g.drawLine(p[0],p[2],p[1],p[3]);
				/**
				 * To Draw line between fragments in the same chain
				 */
				if((extension ==  3 || extension == 6) && drawChainConnection )
				{
					if(i == 0)
					{
						previousPoint[0] = p[0];
						previousPoint[1] = p[2];
					}
					else
					{
						if( chainID[i] ==  chainID[i-1])
						{
							Graphics2D g1 = (Graphics2D)g;
							
							Color c = g1.getColor();
							g1.setColor(Color.MAGENTA);
							
							Stroke st = g1.getStroke();
							g1.setStroke(chainStroke);
							g1.drawLine(p[1], p[3],previousPoint[0], previousPoint[1]);
							g1.setColor(c);
							g1.setStroke(st);
							
						}
						previousPoint[0] = p[0];
						previousPoint[1] = p[2];
					}
						
				}//end of if (extension ==  3 || extension == 6 )
		 	}//end of for loop
	 }//end of method
	 //----------------------------------
	/*
	 * drawChaines method for multiple genomes
	 * param>the graphics object
	 * param>arrListToDraw is array of the fragment postion , which should draw
	 * param>extension to know the kind of the file , to set the color for the spesific fragments..if read from multiple genomes...file....
	 * all the fragments from all file are in same array array..so this function will search for the reverse in this array by another array contians the reverse loction for each 
	 * genomes in this file ............
	 */
	public void drawChainesForMultiple(Graphics g, MyFragmentPosArrayListToDraw arrListToDraw,ProcessingFiles proFiles,int extension,boolean forwardFlag,boolean revFlag)
	 {
		float forG1 = (float)Math.abs(p4.x-p1.x)/(float)firstEnd;
		float forG2 = (float)Math.abs(p1.y-p2.y)/(float)secondEnd;
  		
//  	 ---------------------------------------------------------------------------------------------
		 Color color1 = this.drawFragColor;
		 Color color2 = this.drawRevFragColor;
		 
		 
		
		 /**
		  * to draw the line connect between the fragments in the chain
		  */
		 int[] previousPoint = new int[2];
		 int[] chainID = new int[1];
		 
		 
		 if(extension ==3 || extension ==6)
			{
				 color1 = this.drawChainFileColor;
				 color2 = this.drawRevChainFileColor;
					
				if(extension == 3 )
					chainID = proFiles.arrOfFragmentChainID;
				if(extension == 6)
					chainID = proFiles.arrOfRevFragmentChainID;
						
			 }
		 if(extension ==4 || extension ==7)
			{
				 color1 = this.drawChainColor;
				 color2 = this.drawRevChainColor;
			 }
		 if(extension ==5 || extension ==8)
			{
				 color1 = this.drawClusterColor;
				 color2 = this.drawRevClusterColor;
			 }
		 
		 
		 
			int startOfRevG1=10000000 ,endOfRevG1=-100 ,counterG1 = 0;
			 int startOfRevG2=10000000,endOfRevG2=-100,counterG2 = 0;
			
			 
			 ArrayList arr1 = (ArrayList)proFiles.arrOfReverseLocations.get(firstGenomeNum);
			 ArrayList arr2 = (ArrayList)proFiles.arrOfReverseLocations.get(secondGenomeNum); 
			 
			
			 
			 for(int i=0; i< arrListToDraw.size();i++)
		 	{
				
				 g.setColor(color1);
				 int toKnowTheDirOFLine = 1;//by default 1 = forward
				 
				 
				 if(arr1.size() > counterG1)
				 { int[] locations1= (int[])arr1.get(counterG1);
				 startOfRevG1 = locations1[0];
				 endOfRevG1= locations1[1];
				 }
				 
				 if(arr2.size() > counterG2)
				 {
					 
					 int[] locations2= (int[])arr2.get(counterG2);
					 startOfRevG2 = locations2[0];
					 endOfRevG2 = locations2[1];
				 }
				    int[] arrToDraw = new int[4];
				 
				    
				    /*****************************************************************************
				     * FILTERATION
				     */
				    if(extension == 1)
					 {
					 if(!proFiles.filterFragments(i, threshold, proFiles.arrOfFragmentScores,arrListToDraw,length_threshold,false))
						 continue;
					 }
				    if(extension == 4)
					 {
					 if(!proFiles.filterFragments(i, threshold, proFiles.arrOfCcnScores,arrListToDraw,length_threshold,false))
						 continue;
					 }
				    if(extension == 3)
				    {
				    if(!proFiles.filterFragments(proFiles.arrOfFragmentChainID[i]-1, threshold, proFiles.arrOfFragmentChainScores,arrListToDraw,length_threshold,true))
					 continue;
				    }
				    /****************************************************************************/
				 
				 
				    FragmentPosArrayList fragmentPos = arrListToDraw.get(i);
					int[] d =(int[])fragmentPos.get( this.firstGenomeNum);
					arrToDraw[0] = d[0];
					arrToDraw[1] = d[1];
					d =(int[])fragmentPos.get( this.secondGenomeNum);
					arrToDraw[2] = d[0];
					arrToDraw[3] = d[1];
				//i>= start  is right because ,,,assign (counter of fragments +1) to location 0
				 if(i>=startOfRevG1 && i<=endOfRevG1)//if first g is m
				 {
					 if(i == endOfRevG1)
						 counterG1++;
					 
					 if(i>=startOfRevG2 && i<=endOfRevG2)//if the second g is also m
					 {
						
						 if(i == endOfRevG2)
							 counterG2++;
					 }
					 else
					 {
						 g.setColor(color2);
						 toKnowTheDirOFLine  =0;
						 int t = arrToDraw[2];
						 arrToDraw[2] = arrToDraw[3];
						 arrToDraw[3] =  t;
						 
					 }
				 	
				 }	
				 else//if first g is p
				 {
					 if(i>=startOfRevG2 && i<=endOfRevG2   )//if second g is m
					 {
						 g.setColor(color2);
						 toKnowTheDirOFLine = 0;
						int  t = arrToDraw[2];
						 arrToDraw[2] = arrToDraw[3];
						 arrToDraw[3] =  t;
						 if(i == endOfRevG2)
							 counterG2++;
					 }
				}
				 
				 if( (toKnowTheDirOFLine == 1 && forwardFlag ) || (toKnowTheDirOFLine ==0 && revFlag))
				 {
		 		//--------------------------------------------------------------
		 		int[] p = drawingPoints(arrToDraw,forG1,forG2);			
		 		//----------------------------------------------------------------
		 		//[0]-->s1 , [1]-->e1,[2]-->s2  ,[3]-->e2
				// to draw line in 2D plot for fragments p1=s1,s2  and p2= e1,e2
				g.drawLine(p[0],p[2],p[1],p[3]);
				
				/**
				 * To Draw line between fragments in the same chain
				 */
				if((extension ==  3 || extension == 6 ) && drawChainConnection)
				{
					if(i == 0)
					{
						previousPoint[0] = p[0];
						previousPoint[1] = p[2];
					}
					else
					{
						if( chainID[i] ==  chainID[i-1])
						{
							Graphics2D g1 = (Graphics2D)g;
							
							Color c = g1.getColor();
							g1.setColor(Color.MAGENTA);
							Stroke st = g1.getStroke();
							g1.setStroke(chainStroke);
							g1.drawLine(p[1], p[3],previousPoint[0], previousPoint[1]);
							g1.setColor(c);
							g1.setStroke(st);
							
						}
						previousPoint[0] = p[0];
						previousPoint[1] = p[2];
					}
						
				}//end of if (extension ==  3 || extension == 6 )
				 }//end if 
			 }//end of for loop 

	 }//end method

	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// return the drawing points after make the calculation
	//with respect to the legth of the genomes and the axis
	 int[] drawingPoints(int[] arrToDraw, float forG1 ,float forG2)
	 {
	 		int[] p = new int[4];
	 			
			p[0]=(int)(arrToDraw[0]*forG1)+p1.x;//'+p1.x' because the origin is translate
		
			p[1]=(int)(arrToDraw[1]*forG1)+p1.x;
			
			p[2]=-(int)(arrToDraw[2]* forG2 )+p1.y;//'+p1.y' because the origin is translate
	
			p[3]=-(int)( arrToDraw[3]* forG2 )+p1.y;
			
			return p;
	 }

	//------------------------------------------------------------------------
	 /*
	  * reverse Transformation
	  * param> the pixel location
	  * return>the corsponding location in the projection with resprct to the real coordinates"genome cordinates"
	  */
	 double[] reverseTransformation(int[] x)
	 {
		 	double [] p = new double[2];
			p[0] = (x[0]-p1.x)*((float)firstEnd/(float)Math.abs(p4.x-p3.x));
			p[1] = (x[1]-p1.y)*-1*((float)secondEnd/(float)Math.abs(p1.y-p2.y));
			
			return p;
	 }
	 
	 ////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//-- getFragmentFromSelectRect== 
	//--will return array list contians the stirng of the selected fragments
	/* getFragmentFromSelectRect== 
	 *will return array list contians the stirng of the selected fragments
	 * param-------->notselect will be 1 if the user choose select not zoom
	 */
	 public ArrayList getFragmentFromSelectRect(int notSelect)
	{
		 //to store the indeices of the selected fragments..in the array which draw the file
			this.selectedFragmentsIndex = new Vector();
			this.selectedRevFragmentsIndex = new Vector();
			 
			this.selectedChainFileIndex = new Vector();
			this.selectedRevChainFileIndex = new Vector();
			
			this.selectedCcnIndex = new Vector();
			this.selectedRevCcnIndex  = new Vector();
			
			this.selectedClusterIndex = new Vector();
			this.selectedRevClusterIndex  = new Vector();
			
			//to know the array index offset in the shown list
			offset = 0;
			offsetForChainFile =0;
			offsetForRevChainFile=0;
			offsetForCcn = 0;
			offsetForRevCcn = 0;
			offsetForCluster  = 0;
			
			//to store all information of the fragment as string 
			//and send then to the return array
			//and not use only one arrayList to show every category alone
			//espicaily when open multiple genomes file 
			//and it contian rev. and forward records in the same array
			
			ArrayList arrF=new ArrayList();
			ArrayList arrR=new ArrayList();
			
			ArrayList arrChainFile = new ArrayList();
			ArrayList arrRevChainFile = new ArrayList();

			ArrayList arrCcn = new ArrayList();
			ArrayList arrRevCcn = new ArrayList();

			ArrayList arrCluster = new ArrayList();
			ArrayList arrRevCluster = new ArrayList();

			
			
			//----- to know the range in other projections,if it entered by the message box
			int[] begindIndexarr=new int[parent.parent.num];
			int[] endIndexarr=new int[parent.parent.num];
			
			for(int j =0; j<parent.parent.num;j++)
			{
				begindIndexarr[j] = 0;
				endIndexarr[j] =(int) parent.parent.maxEndInFragments.get(j);
			}//end of for(int j =0; j<ProcessingFiles.num;j++)
			//to show the funcction in case if the user choose selestion not zoom from the popup menu
			if(parent.parent.num > 2 && notSelect ==1 )
			{
				//show the message box and make the check in the action of ok button
				MsgBox msg=new MsgBox("Enter the Range in Genome",true,begindIndexarr,endIndexarr);
			}//if if(ProcessingFiles.num > 2)
			
			//--------------------------------------------------------------------------
			long StarTime = System.currentTimeMillis();
			
			//to get the min and max point in the select rectangle 
			int[] p1= {selectRect.x,selectRect.y};
			int[] p2= {selectRect.x+selectRect.width,selectRect.y+selectRect.height};
			double[]  temp =reverseTransformation(p1);
			p1[0]=(int)temp[0];
			p1[1]=(int)temp[1];
			temp = reverseTransformation(p2);
			p2[0]=(int)temp[0];
			p2[1]=(int)temp[1];
			
			int tmin = Math.min(p1[1], p2[1]);
			int tmax = Math.max(p1[1], p2[1]);
			
			p1[1] = tmin;
			p2[1] = tmax;
			
			/*
			 * the selection happened on the sorted array of the index
			 * binary search used only to find the start point to search in the sorted index array
			 */
			/**
			 * Fragment Selection
			 */
			if(this.drawFrag || this.drawRevFrag)
			{
			
			for(int h=0;h<SortedIndeciesOfFragments.size();h++)
			{
			ProcessingFiles proFiles = (ProcessingFiles)proFilesArr.get(h);
			
			//to check if this panel in new wendow so no overlay
			//to check if the object of the file is for new window not for overlay
			if( this.forNewWindow != proFiles.forNewWindow)
				continue;
			if(this.forNewWindow && h != forNewWindowIndex)
				continue;
			
			
			
			int[] SortedIndeciesOfFragmentsArr = (int[])SortedIndeciesOfFragments.get(h);
			
			for(int i=BinarySearch(SortedIndeciesOfFragmentsArr,0,SortedIndeciesOfFragmentsArr.length-1, proFiles.arrToDrawTheFragments,p1[0])
					;i< SortedIndeciesOfFragmentsArr.length
					;i++)
			{
				
				 if(!proFiles.filterFragments(SortedIndeciesOfFragmentsArr[i], threshold, proFiles.arrOfFragmentScores,proFiles.arrToDrawTheFragments,length_threshold,false))
					 continue;
				 
				FragmentPosArrayList fragmentPos = proFiles.arrToDrawTheFragments.get(SortedIndeciesOfFragmentsArr[i]);
				int[] arrToDraw = new int[4];
				
				int[] d =(int[])fragmentPos.get( this.firstGenomeNum);
				arrToDraw[0] = d[0];
				arrToDraw[1] = d[1];
				d =(int[])fragmentPos.get( this.secondGenomeNum);
				arrToDraw[2] = d[0];
				arrToDraw[3] = d[1];
			
				//[0]-->s1 , [1]-->e1,[2]-->s2  ,[3]-->e2
				
				boolean rangeFlag = true;
				for(int jj =0; jj<parent.parent.num;jj++)
				{
					if(jj != this.firstGenomeNum && jj != this.secondGenomeNum)
					{
						int[] dfp =(int[])fragmentPos.get(jj);
						if( !(begindIndexarr[jj] <= dfp[0] &&  endIndexarr[jj] >= dfp[1]))
							rangeFlag=false;
					}//end ofif(j != this.firstGenomeNum && j != this.secondGenomeNum)
				}//end of for(int j =0; j<ProcessingFiles.num;j++)
				
				if(p1[0]<= arrToDraw[0] && p2[0] >= arrToDraw[1] && p1[1]<= arrToDraw[2]&& p2[1]>=arrToDraw[3]&& rangeFlag)
					{
						boolean flagF=false;
						
						String s = "#"+ proFiles.arrOfFragmentScores[SortedIndeciesOfFragmentsArr[i]];	
						// for All fragment postion
						for(int g=0;g<parent.parent.num;g++)
						{int[] posOfFragment = (int[])fragmentPos.get(g);
							
						s += " ["+posOfFragment[0]+","+posOfFragment[1]+"]"+"  ";
						}
						
						//--------------------------------------------------------------------------------------
						if(proFiles.arrOfReverseLocations.size() > 0)
						{
							ArrayList arr1= (ArrayList)proFiles.arrOfReverseLocations.get(firstGenomeNum);//for first genome
							ArrayList arr2= (ArrayList)proFiles.arrOfReverseLocations.get(secondGenomeNum);//for second genome
							boolean flagifg1ism = false;
							if(arr1.size()>0)//so there is some of reverse index in genome 1
							{
								for(int k=0;k<arr1.size();k++)
								{
									int[] locations1=(int[])arr1.get(k);
									if(SortedIndeciesOfFragmentsArr[i] >= locations1[0] && SortedIndeciesOfFragmentsArr[i]<=locations1[1])//if g1 is m
									{
										flagifg1ism = true;
										for(int kk=0;kk<arr2.size();kk++)
										{
											int[] locations2=(int[])arr2.get(kk);
											if(SortedIndeciesOfFragmentsArr[i] >= locations2[0] && SortedIndeciesOfFragmentsArr[i]<=locations2[1])//if g2 is m
											{
												flagF=true;
												break;
											}//end of if g2 is m
										}//end of for for(int kk=0;kk<arr2.size();kk++)
									}//end of if(SortedIndeciesOfFragmentsArr[i] >= locations1[0] && SortedIndeciesOfFragmentsArr[i]<=locations1[1])//if g1 is m
								}//end of for
							}//if there is some reverse index in genome 1
							if(!flagifg1ism)
							{
								flagF=true;
								for(int kk=0;kk<arr2.size();kk++)
								{
									int[] locations2=(int[])arr2.get(kk);
									if(SortedIndeciesOfFragmentsArr[i] >= locations2[0] && SortedIndeciesOfFragmentsArr[i]<=locations2[1])//if g2 is m
									{
										flagF=false;
										break;
									}//end of if g2 is m
								}//end of for for(int kk=0;kk<arr2.size();kk++)
							}
						}//end of if(proFiles.arrOfReverseLocations.size() > 0)
						else//there is no reverse locations
						{
							flagF=true;
						}
						
				         //-----------------------------------------------------------------------------
						if(flagF)
						{
							if(drawFrag)
							{arrF.add("F. Frag."+"File ID:"+h+" "+s);
							selectedFragmentsIndex.add(""+SortedIndeciesOfFragmentsArr[i]+"\t"+h);}
						}
						
						if(!flagF)
						{
							if(drawRevFrag)
							{arrR.add("R. Frag."+"File ID:"+h+" "+s);
							selectedRevFragmentsIndex.add(""+SortedIndeciesOfFragmentsArr[i]+"\t"+h);}
						}
					}//endof if(p1[0]<= arrToDraw[0] && p2[0] >= arrToDraw[1] && p1[1]<= arrToDraw[2]&& p2[1]>=arrToDraw[3]&& rangeFlag)	
				if(p2[0] < arrToDraw[1])
					break;
			}//end of for(int i=0;i< SortedIndeciesOfFragments.length;i++)
			}//end of for(int h=0;h<SortedIndeciesOfFragments.size();h++)
			
			}//end of if drawFragment
			///////////////////////////////////////////////////////
			
			/**
			 * Rev Fragment Selection
			 */
			//to get the reverse fragment
			//////////----------------------------------------------
			if (this.drawRevFrag)
			{
				
			for(int j=0;j<SortedIndeciesOfRevFragments.size();j++)
			{
			ProcessingFiles proFiles = (ProcessingFiles)proFilesArr.get(j);
			
//			to check if this panel in new wendow so no overlay
			//to check if the object of the file is for new window not for overlay
			if( this.forNewWindow != proFiles.forNewWindow)
				continue;
			if(this.forNewWindow && j != forNewWindowIndex)
				continue;
			
			int[] SortedIndeciesOfFragmentsArr = (int[])SortedIndeciesOfRevFragments.get(j);
			
			for(int i=
		BinarySearch(SortedIndeciesOfFragmentsArr,0,SortedIndeciesOfFragmentsArr.length-1,proFiles.arrToDrawTheRevFragments,p1[0])
					;i< SortedIndeciesOfFragmentsArr.length
					;i++)
			{
				FragmentPosArrayList fragmentPos = proFiles.arrToDrawTheRevFragments.get(SortedIndeciesOfFragmentsArr[i]);
				int[] arrToDraw = new int[4];
			
				int[] d =(int[])fragmentPos.get( this.firstGenomeNum);
				arrToDraw[0] = d[0];
				arrToDraw[1] = d[1];
				d =(int[])fragmentPos.get( this.secondGenomeNum);
				arrToDraw[2] = d[0];
				arrToDraw[3] = d[1];
				
				boolean rangeFlag = true;
				for(int jj =0; jj<parent.parent.num;jj++)
				{
					if(jj != this.firstGenomeNum && jj != this.secondGenomeNum)
					{
						int[] dfp =(int[])fragmentPos.get(jj);
						if( !(begindIndexarr[jj] <= dfp[0] &&  endIndexarr[jj] >= dfp[1]))
							rangeFlag=false;
					}//end ofif(j != this.firstGenomeNum && j != this.secondGenomeNum)
				}//end of for(int j =0; j<ProcessingFiles.num;j++)
				
				if(p1[0]<= arrToDraw[0] && p2[0] >= arrToDraw[1] && p1[1]<= arrToDraw[2]&& p2[1]>=arrToDraw[3]&& rangeFlag)
				{
					//FragmentPosArrayList  arr = proFiles.arrToDrawTheRevFragments.get(i);
					String s = "#"+ proFiles.arrOfRevFragmentScores[SortedIndeciesOfFragmentsArr[i]];	
					
					//for All genomes fragment postion
					for(int g=0;g<parent.parent.num;g++)
					{int[] posOfFragment = (int[])fragmentPos.get(g);
						
					s += " ["+posOfFragment[0]+","+posOfFragment[1]+"]"+"  ";
					}
					arrR.add("R. Frag."+"File ID:"+j+" "+s);
					selectedRevFragmentsIndex.add(""+SortedIndeciesOfFragmentsArr[i]+"\t"+j);
				}//end of if
				if(p2[0] < arrToDraw[1])
					break;
			}//end of for
			}//end of for
			
			}//end of if (this.drawRevFrag)
			
			/**
			 * Chain selection
			 */
			//to get the Chain File  fragment
			//////////----------------------------------------------
			if (this.drawChainFile || this.drawRevChainFile)
			{
				for(int h=0;h<SortedIndeciesOfChainFile.size();h++)
				{
				ProcessingFiles proFiles = (ProcessingFiles)proFilesArr.get(h);
				
//				to check if this panel in new wendow so no overlay
				//to check if the object of the file is for new window not for overlay
				if( this.forNewWindow != proFiles.forNewWindow)
					continue;
				if(this.forNewWindow && h != forNewWindowIndex)
					continue;
				
				int[] SortedIndeciesOfFragmentsArr = (int[])SortedIndeciesOfChainFile.get(h);
				
				for(int i=BinarySearch(SortedIndeciesOfFragmentsArr,0,SortedIndeciesOfFragmentsArr.length-1, proFiles.arrToDrawTheChainesFile,p1[0])
						;i< SortedIndeciesOfFragmentsArr.length
						;i++)
				{
					//to applay filter for make selection.....it same as the filter in the drawing
					if(!proFiles.filterFragments(proFiles.arrOfFragmentChainID[i]-1, threshold, proFiles.arrOfFragmentChainScores,proFiles.arrToDrawTheFragments,length_threshold,true))
						 continue;
					 
					FragmentPosArrayList fragmentPos = proFiles.arrToDrawTheChainesFile.get(SortedIndeciesOfFragmentsArr[i]);
					int[] arrToDraw = new int[4];
					
					int[] d =(int[])fragmentPos.get( this.firstGenomeNum);
					arrToDraw[0] = d[0];
					arrToDraw[1] = d[1];
					d =(int[])fragmentPos.get( this.secondGenomeNum);
					arrToDraw[2] = d[0];
					arrToDraw[3] = d[1];
				
					//if the file is multiple genomes file...test if the fragments in the selected range in the other projections
					
					boolean rangeFlag = true;
					for(int jj =0; jj<parent.parent.num;jj++)
					{
						if(jj != this.firstGenomeNum && jj != this.secondGenomeNum)
						{
							int[] dfp =(int[])fragmentPos.get(jj);
							if( !(begindIndexarr[jj] <= dfp[0] &&  endIndexarr[jj] >= dfp[1]))
								rangeFlag=false;
						}//end ofif(j != this.firstGenomeNum && j != this.secondGenomeNum)
					}//end of for(int j =0; j<ProcessingFiles.num;j++)
					
					if(p1[0]<= arrToDraw[0] && p2[0] >= arrToDraw[1] && p1[1]<= arrToDraw[2]&& p2[1]>=arrToDraw[3]&& rangeFlag)
						{
							boolean flagF=false;
							/**
							 * decision if the fragment take according to its id
							 */
							//to get the index and the points of the first fragment in the chain
							int startOfthisChain = proFiles.startIndexOfChaines[proFiles.arrOfFragmentChainID[SortedIndeciesOfFragmentsArr[i]]-1];
							FragmentPosArrayList  starPoints = proFiles.arrToDrawTheChainesFile.get(startOfthisChain);
							int[] arrToDraw2 = new int[4];			
							int[] d2 =(int[])starPoints.get( this.firstGenomeNum);
							arrToDraw2[0] = d2[0];
							arrToDraw2[1] = d2[1];
							d2 =(int[])starPoints.get( this.secondGenomeNum);
							arrToDraw2[2] = d2[0];
							arrToDraw2[3] = d2[1];

//							if the file is multiple genomes file...test if the fragments in the selected range in the other projections
							
							boolean rangeFlagForStartPoint = true;
							for(int jj =0; jj<parent.parent.num;jj++)
							{
								if(jj != this.firstGenomeNum && jj != this.secondGenomeNum)
								{
									int[] dfp =(int[])starPoints.get(jj);
									if( !(begindIndexarr[jj] <= dfp[0] &&  endIndexarr[jj] >= dfp[1]))
										rangeFlagForStartPoint=false;
								}//end ofif(j != this.firstGenomeNum && j != this.secondGenomeNum)
							}//end of for(int j =0; j<ProcessingFiles.num;j++)
							if(!(rangeFlagForStartPoint && p1[0]<= arrToDraw2[0] && p2[0] >= arrToDraw2[1] && p1[1]<= arrToDraw2[2]&& p2[1]>=arrToDraw2[3]))
							{
								continue;
							}
							
							//to get the last fragment in the chain
							int endOfthisChain;
							if(proFiles.arrOfFragmentChainID[SortedIndeciesOfFragmentsArr[i]] >= proFiles.startIndexOfChaines.length)
							{
								endOfthisChain = proFiles.arrToDrawTheChainesFile.size()-1;
							}
							else
							 endOfthisChain = proFiles.startIndexOfChaines[proFiles.arrOfFragmentChainID[SortedIndeciesOfFragmentsArr[i]]]-1;
							
							FragmentPosArrayList  endPoints = proFiles.arrToDrawTheChainesFile.get(endOfthisChain);
							int[] arrToDraw3 = new int[4];			
							int[] d3 =(int[])endPoints.get( this.firstGenomeNum);
							arrToDraw3[0] = d3[0];
							arrToDraw3[1] = d3[1];
							d3 =(int[])endPoints.get( this.secondGenomeNum);
							arrToDraw3[2] = d3[0];
							arrToDraw3[3] = d3[1];

//							if the file is multiple genomes file...test if the fragments in the selected range in the other projections
							
							boolean rangeFlagForEndPoint = true;
							for(int jj =0; jj<parent.parent.num;jj++)
							{
								if(jj != this.firstGenomeNum && jj != this.secondGenomeNum)
								{
									int[] dfp =(int[])endPoints.get(jj);
									if( !(begindIndexarr[jj] <= dfp[0] &&  endIndexarr[jj] >= dfp[1]))
										rangeFlagForEndPoint=false;
								}//end ofif(j != this.firstGenomeNum && j != this.secondGenomeNum)
							}//end of for(int j =0; j<ProcessingFiles.num;j++)
							if(!(rangeFlagForEndPoint && p1[0]<= arrToDraw3[0] && p2[0] >= arrToDraw3[1] && p1[1]<= arrToDraw3[2]&& p2[1]>=arrToDraw3[3]))
							{
								continue;
							}
							
							String s = "#"+ proFiles.arrOfFragmentChainScores[proFiles.arrOfFragmentChainID[SortedIndeciesOfFragmentsArr[i]]-1];
							for(int g=0;g<parent.parent.num;g++)
							{int[] posOfFragment = (int[])fragmentPos.get(g);
								
							s += " ["+posOfFragment[0]+","+posOfFragment[1]+"]"+"  ";
							}
							s +="Chain ID   "+(proFiles.arrOfFragmentChainID[SortedIndeciesOfFragmentsArr[i]]);
							
							//--------------------------------------------------------------------------------------
							if(proFiles.arrOfReverseLocations.size() > 0)
							{
								ArrayList arr1= (ArrayList)proFiles.arrOfReverseLocations.get(firstGenomeNum);//for first genome
								ArrayList arr2= (ArrayList)proFiles.arrOfReverseLocations.get(secondGenomeNum);//for second genome
								boolean flagifg1ism = false;
								if(arr1.size()>0)//so there is some of reverse index in genome 1
								{
									for(int k=0;k<arr1.size();k++)
									{
										int[] locations1=(int[])arr1.get(k);
										if(SortedIndeciesOfFragmentsArr[i] >= locations1[0] && SortedIndeciesOfFragmentsArr[i]<=locations1[1])//if g1 is m
										{
											flagifg1ism = true;
											for(int kk=0;kk<arr2.size();kk++)
											{
												int[] locations2=(int[])arr2.get(kk);
												if(SortedIndeciesOfFragmentsArr[i] >= locations2[0] && SortedIndeciesOfFragmentsArr[i]<=locations2[1])//if g2 is m
												{
													flagF=true;
													break;
												}//end of if g2 is m
											}//end of for for(int kk=0;kk<arr2.size();kk++)
										}//end of if(SortedIndeciesOfFragmentsArr[i] >= locations1[0] && SortedIndeciesOfFragmentsArr[i]<=locations1[1])//if g1 is m
									}//end of for
								}//if there is some reverse index in genome 1
								if(!flagifg1ism)
								{
									flagF=true;
									for(int kk=0;kk<arr2.size();kk++)
									{
										int[] locations2=(int[])arr2.get(kk);
										if(SortedIndeciesOfFragmentsArr[i] >= locations2[0] && SortedIndeciesOfFragmentsArr[i]<=locations2[1])//if g2 is m
										{
											flagF=false;
											break;
										}//end of if g2 is m
									}//end of for for(int kk=0;kk<arr2.size();kk++)
								}
							}//end of if(proFiles.arrOfReverseLocations.size() > 0)
							else{
								flagF=true;
							}
							
					         //-----------------------------------------------------------------------------
							if(flagF)
							{
								if(drawChainFile)
								{arrChainFile.add("F. Chn."+"File ID:"+h+" "+s);
								selectedChainFileIndex.add(""+SortedIndeciesOfFragmentsArr[i]+"\t"+h);}
							}
							
							if(!flagF)
							{
								if(drawRevChainFile)
								{arrRevChainFile.add("R. Chn."+"File ID:"+h+" "+s);
								selectedRevChainFileIndex.add(""+SortedIndeciesOfFragmentsArr[i]+"\t"+h);}
							}
						}//endof if(p1[0]<= arrToDraw[0] && p2[0] >= arrToDraw[1] && p1[1]<= arrToDraw[2]&& p2[1]>=arrToDraw[3]&& rangeFlag)	
					if(p2[0] < arrToDraw[1])
						break;
				}//end of for(int i=0;i< SortedIndeciesOfFragments.length;i++)
				}//end of for(int h=0;h<SortedIndeciesOfFragments.size();h++)
				
			
			}//end of if draw chain file
			
			/**
			 * Rev Chain selection
			 */
			if (this.drawRevChainFile)
			{
				for(int j=0;j<SortedIndeciesOfRevChainFile.size();j++)
				{
				ProcessingFiles proFiles = (ProcessingFiles)proFilesArr.get(j);
				

//				to check if this panel in new wendow so no overlay
				//to check if the object of the file is for new window not for overlay
				if( this.forNewWindow != proFiles.forNewWindow)
					continue;
				if(this.forNewWindow && j != forNewWindowIndex)
					continue;
				
				
				int[] SortedIndeciesOfFragmentsArr = (int[])SortedIndeciesOfRevChainFile.get(j);
				
				for(int i=
			BinarySearch(SortedIndeciesOfFragmentsArr,0,SortedIndeciesOfFragmentsArr.length-1,proFiles.arrToDrawTheRevChainesFile,p1[0])
						;i< SortedIndeciesOfFragmentsArr.length
						;i++)
				{
					//to applay filter for make selection.....it same as the filter in the drawing
					if(!proFiles.filterFragments(proFiles.arrOfRevFragmentChainID[i]-1, threshold, proFiles.arrOfRevFragmentChainScores,proFiles.arrToDrawTheFragments,length_threshold,true))
						 continue;
					 
					FragmentPosArrayList fragmentPos = proFiles.arrToDrawTheRevChainesFile.get(SortedIndeciesOfFragmentsArr[i]);
					int[] arrToDraw = new int[4];
					
					int[] d =(int[])fragmentPos.get( this.firstGenomeNum);
					arrToDraw[0] = d[0];
					arrToDraw[1] = d[1];
					d =(int[])fragmentPos.get( this.secondGenomeNum);
					arrToDraw[2] = d[0];
					arrToDraw[3] = d[1];
				
					//if the file is multiple genomes file...test if the fragments in the selected range in the other projections
					
					boolean rangeFlag = true;
					for(int jj =0; jj<parent.parent.num;jj++)
					{
						if(jj != this.firstGenomeNum && jj != this.secondGenomeNum)
						{
							int[] dfp =(int[])fragmentPos.get(jj);
							if( !(begindIndexarr[jj] <= dfp[0] &&  endIndexarr[jj] >= dfp[1]))
								rangeFlag=false;
						}//end ofif(j != this.firstGenomeNum && j != this.secondGenomeNum)
					}//end of for(int j =0; j<ProcessingFiles.num;j++)
					
					if(p1[0]<= arrToDraw[0] && p2[0] >= arrToDraw[1] && p1[1]<= arrToDraw[2]&& p2[1]>=arrToDraw[3]&& rangeFlag)
						{
							/**
							 * decision if the fragment take according to its id
							 */
							//to get the index and the points of the first fragment in the chain
							int startOfthisChain = proFiles.startIndexOfRevChaines[proFiles.arrOfRevFragmentChainID[SortedIndeciesOfFragmentsArr[i]]-1];
							FragmentPosArrayList  starPoints = proFiles.arrToDrawTheRevChainesFile.get(startOfthisChain);
							int[] arrToDraw2 = new int[4];			
							int[] d2 =(int[])starPoints.get( this.firstGenomeNum);
							arrToDraw2[0] = d2[0];
							arrToDraw2[1] = d2[1];
							d2 =(int[])starPoints.get( this.secondGenomeNum);
							arrToDraw2[2] = d2[0];
							arrToDraw2[3] = d2[1];

//							if the file is multiple genomes file...test if the fragments in the selected range in the other projections
							
							boolean rangeFlagForStartPoint = true;
							for(int jj =0; jj<parent.parent.num;jj++)
							{
								if(jj != this.firstGenomeNum && jj != this.secondGenomeNum)
								{
									int[] dfp =(int[])starPoints.get(jj);
									if( !(begindIndexarr[jj] <= dfp[0] &&  endIndexarr[jj] >= dfp[1]))
										rangeFlagForStartPoint=false;
								}//end ofif(j != this.firstGenomeNum && j != this.secondGenomeNum)
							}//end of for(int j =0; j<ProcessingFiles.num;j++)
							if(!(rangeFlagForStartPoint && p1[0]<= arrToDraw2[0] && p2[0] >= arrToDraw2[1] && p1[1]<= arrToDraw2[2]&& p2[1]>=arrToDraw2[3]))
							{
								continue;
							}
							
							//to get the last fragment in the chain
							int endOfthisChain;
							if(proFiles.arrOfRevFragmentChainID[SortedIndeciesOfFragmentsArr[i]] >= proFiles.startIndexOfRevChaines.length)
							{
								endOfthisChain = proFiles.arrToDrawTheRevChainesFile.size()-1;
							}
							else
							 endOfthisChain = proFiles.startIndexOfRevChaines[proFiles.arrOfRevFragmentChainID[SortedIndeciesOfFragmentsArr[i]]]-1;
							
							FragmentPosArrayList  endPoints = proFiles.arrToDrawTheRevChainesFile.get(endOfthisChain);
							int[] arrToDraw3 = new int[4];			
							int[] d3 =(int[])endPoints.get( this.firstGenomeNum);
							arrToDraw3[0] = d3[0];
							arrToDraw3[1] = d3[1];
							d3 =(int[])endPoints.get( this.secondGenomeNum);
							arrToDraw3[2] = d3[0];
							arrToDraw3[3] = d3[1];

//							if the file is multiple genomes file...test if the fragments in the selected range in the other projections
							
							boolean rangeFlagForEndPoint = true;
							for(int jj =0; jj<parent.parent.num;jj++)
							{
								if(jj != this.firstGenomeNum && jj != this.secondGenomeNum)
								{
									int[] dfp =(int[])endPoints.get(jj);
									if( !(begindIndexarr[jj] <= dfp[0] &&  endIndexarr[jj] >= dfp[1]))
										rangeFlagForEndPoint=false;
								}//end ofif(j != this.firstGenomeNum && j != this.secondGenomeNum)
							}//end of for(int j =0; j<ProcessingFiles.num;j++)
							if(!(rangeFlagForEndPoint && p1[0]<= arrToDraw2[0] && p2[0] >= arrToDraw2[1] && p1[1]<= arrToDraw2[2]&& p2[1]>=arrToDraw2[3]))
							{
								continue;
							}
							
							String s = "#"+ proFiles.arrOfRevFragmentChainScores[proFiles.arrOfRevFragmentChainID[SortedIndeciesOfFragmentsArr[i]]-1];
							for(int g=0;g<parent.parent.num;g++)
							{int[] posOfFragment = (int[])fragmentPos.get(g);
								
							s += " ["+posOfFragment[0]+","+posOfFragment[1]+"]"+"  ";
							}
							s +="Chain ID   "+(proFiles.arrOfRevFragmentChainID[SortedIndeciesOfFragmentsArr[i]]);
							
							arrRevChainFile.add("R. Chn."+"File ID:"+j+" "+s);
							selectedRevChainFileIndex.add(""+SortedIndeciesOfFragmentsArr[i]+"\t"+j);
						}
					if(p2[0] < arrToDraw[1])
						break;
				}//end of for
				}//end of for
			}//end of if draw Rev chain file		
			
			/**
			 * Compact Chain selection
			 */
			//----------------for compact chain file 
			if(this.drawChain || this.drawRevChain)
			{
			
			for(int h=0;h<SortedIndeciesOfCcn.size();h++)
			{
			ProcessingFiles proFiles = (ProcessingFiles)proFilesArr.get(h);
			

//			to check if this panel in new wendow so no overlay
			//to check if the object of the file is for new window not for overlay
			if( this.forNewWindow != proFiles.forNewWindow)
				continue;
			if(this.forNewWindow && h != forNewWindowIndex)
				continue;
			
			int[] SortedIndeciesOfFragmentsArr = (int[])SortedIndeciesOfCcn.get(h);
			
			for(int i=BinarySearch(SortedIndeciesOfFragmentsArr,0,SortedIndeciesOfFragmentsArr.length-1, proFiles.arrToDrawTheChaines,p1[0])
					;i< SortedIndeciesOfFragmentsArr.length
					;i++)
			{
				
				 if(!proFiles.filterFragments(SortedIndeciesOfFragmentsArr[i], threshold, proFiles.arrOfCcnScores,proFiles.arrToDrawTheFragments,length_threshold,false))
					 continue;
				 
				FragmentPosArrayList fragmentPos = proFiles.arrToDrawTheChaines.get(SortedIndeciesOfFragmentsArr[i]);
				int[] arrToDraw = new int[4];
				
				int[] d =(int[])fragmentPos.get( this.firstGenomeNum);
				arrToDraw[0] = d[0];
				arrToDraw[1] = d[1];
				d =(int[])fragmentPos.get( this.secondGenomeNum);
				arrToDraw[2] = d[0];
				arrToDraw[3] = d[1];
			
				//[0]-->s1 , [1]-->e1,[2]-->s2  ,[3]-->e2
				
				boolean rangeFlag = true;
				for(int jj =0; jj<parent.parent.num;jj++)
				{
					if(jj != this.firstGenomeNum && jj != this.secondGenomeNum)
					{
						int[] dfp =(int[])fragmentPos.get(jj);
						if( !(begindIndexarr[jj] <= dfp[0] &&  endIndexarr[jj] >= dfp[1]))
							rangeFlag=false;
					}//end ofif(j != this.firstGenomeNum && j != this.secondGenomeNum)
				}//end of for(int j =0; j<ProcessingFiles.num;j++)
				
				if(p1[0]<= arrToDraw[0] && p2[0] >= arrToDraw[1] && p1[1]<= arrToDraw[2]&& p2[1]>=arrToDraw[3]&& rangeFlag)
					{
						boolean flagF=false;
						
						String s = "#"+ proFiles.arrOfCcnScores[SortedIndeciesOfFragmentsArr[i]];	
						// for All fragment postion
						for(int g=0;g<parent.parent.num;g++)
						{int[] posOfFragment = (int[])fragmentPos.get(g);
							
						s += " ["+posOfFragment[0]+","+posOfFragment[1]+"]"+"  ";
						}
						
						//--------------------------------------------------------------------------------------
						if(proFiles.arrOfReverseLocations.size() > 0)
						{
							ArrayList arr1= (ArrayList)proFiles.arrOfReverseLocations.get(firstGenomeNum);//for first genome
							ArrayList arr2= (ArrayList)proFiles.arrOfReverseLocations.get(secondGenomeNum);//for second genome
							boolean flagifg1ism = false;
							if(arr1.size()>0)//so there is some of reverse index in genome 1
							{
								for(int k=0;k<arr1.size();k++)
								{
									int[] locations1=(int[])arr1.get(k);
									if(SortedIndeciesOfFragmentsArr[i] >= locations1[0] && SortedIndeciesOfFragmentsArr[i]<=locations1[1])//if g1 is m
									{
										flagifg1ism = true;
										for(int kk=0;kk<arr2.size();kk++)
										{
											int[] locations2=(int[])arr2.get(kk);
											if(SortedIndeciesOfFragmentsArr[i] >= locations2[0] && SortedIndeciesOfFragmentsArr[i]<=locations2[1])//if g2 is m
											{
												flagF=true;
												break;
											}//end of if g2 is m
										}//end of for for(int kk=0;kk<arr2.size();kk++)
									}//end of if(SortedIndeciesOfFragmentsArr[i] >= locations1[0] && SortedIndeciesOfFragmentsArr[i]<=locations1[1])//if g1 is m
								}//end of for
							}//if there is some reverse index in genome 1
							if(!flagifg1ism)
							{
								flagF=true;
								for(int kk=0;kk<arr2.size();kk++)
								{
									int[] locations2=(int[])arr2.get(kk);
									if(SortedIndeciesOfFragmentsArr[i] >= locations2[0] && SortedIndeciesOfFragmentsArr[i]<=locations2[1])//if g2 is m
									{
										flagF=false;
										break;
									}//end of if g2 is m
								}//end of for for(int kk=0;kk<arr2.size();kk++)
							}
						}//end of if(proFiles.arrOfReverseLocations.size() > 0)
						else//there is no reverse locations
						{
							flagF=true;
						}
						
				         //-----------------------------------------------------------------------------
						if(flagF)
						{
							if(drawChain)
							{arrCcn.add("F. Ccn."+"File ID:"+h+" "+s);
							selectedCcnIndex.add(""+SortedIndeciesOfFragmentsArr[i]+"\t"+h);}
						}
						
						if(!flagF)
						{
							if(drawRevChain)
							{arrRevCcn.add("R. Ccn."+"File ID:"+h+" "+s);
							selectedRevCcnIndex.add(""+SortedIndeciesOfFragmentsArr[i]+"\t"+h);}
						}
					}//endof if(p1[0]<= arrToDraw[0] && p2[0] >= arrToDraw[1] && p1[1]<= arrToDraw[2]&& p2[1]>=arrToDraw[3]&& rangeFlag)	
				if(p2[0] < arrToDraw[1])
					break;
			}//end of for(int i=0;i< SortedIndeciesOfFragments.length;i++)
			}//end of for(int h=0;h<SortedIndeciesOfFragments.size();h++)
			
			}//end of if drawChaines
			///////////////////////////////////////////////////////
			
			/**
			 * Rev compact chain selection
			 */
			//to get the reverse chaines
			//////////----------------------------------------------
			if (this.drawRevChain)
			{
				
			for(int j=0;j<SortedIndeciesOfRevCcn.size();j++)
			{
			ProcessingFiles proFiles = (ProcessingFiles)proFilesArr.get(j);
			

//			to check if this panel in new wendow so no overlay
			//to check if the object of the file is for new window not for overlay
			if( this.forNewWindow != proFiles.forNewWindow)
				continue;
			if(this.forNewWindow && j != forNewWindowIndex)
				continue;
			
			int[] SortedIndeciesOfFragmentsArr = (int[])SortedIndeciesOfRevCcn.get(j);
			
			for(int i=
		BinarySearch(SortedIndeciesOfFragmentsArr,0,SortedIndeciesOfFragmentsArr.length-1,proFiles.arrToDrawTheRevChaines,p1[0])
					;i< SortedIndeciesOfFragmentsArr.length
					;i++)
			{
				FragmentPosArrayList fragmentPos = proFiles.arrToDrawTheRevChaines.get(SortedIndeciesOfFragmentsArr[i]);
				int[] arrToDraw = new int[4];
			
				int[] d =(int[])fragmentPos.get( this.firstGenomeNum);
				arrToDraw[0] = d[0];
				arrToDraw[1] = d[1];
				d =(int[])fragmentPos.get( this.secondGenomeNum);
				arrToDraw[2] = d[0];
				arrToDraw[3] = d[1];
				
				boolean rangeFlag = true;
				for(int jj =0; jj<parent.parent.num;jj++)
				{
					if(jj != this.firstGenomeNum && jj != this.secondGenomeNum)
					{
						int[] dfp =(int[])fragmentPos.get(jj);
						if( !(begindIndexarr[jj] <= dfp[0] &&  endIndexarr[jj] >= dfp[1]))
							rangeFlag=false;
					}//end ofif(j != this.firstGenomeNum && j != this.secondGenomeNum)
				}//end of for(int j =0; j<ProcessingFiles.num;j++)
				
				if(p1[0]<= arrToDraw[0] && p2[0] >= arrToDraw[1] && p1[1]<= arrToDraw[2]&& p2[1]>=arrToDraw[3]&& rangeFlag)
				{
					//FragmentPosArrayList  arr = proFiles.arrToDrawTheRevFragments.get(i);
					String s = "#"+ proFiles.arrOfRevCcnScores[SortedIndeciesOfFragmentsArr[i]];	
					
					//for All genomes fragment postion
					for(int g=0;g<parent.parent.num;g++)
					{int[] posOfFragment = (int[])fragmentPos.get(g);
						
					s += " ["+posOfFragment[0]+","+posOfFragment[1]+"]"+"  ";
					}
					arrRevCcn.add("R. Ccn."+"File ID:"+j+" "+s);
					selectedRevCcnIndex.add(""+SortedIndeciesOfFragmentsArr[i]+"\t"+j);
				}//end of if
				if(p2[0] < arrToDraw[1])
					break;
			}//end of for
			}//end of for
			
			}//end of if (this.drawRevChain)
			
			/**
			 * cluster selection
			 */
			//----for cluster file 
//			----------------for compact chain file 
			if(this.drawCluster || this.drawRevCluster )
			{
			
			for(int h=0;h<SortedIndeciesOfCluster.size();h++)
			{
			ProcessingFiles proFiles = (ProcessingFiles)proFilesArr.get(h);

//			to check if this panel in new wendow so no overlay
			//to check if the object of the file is for new window not for overlay
			if( this.forNewWindow != proFiles.forNewWindow)
				continue;
			if(this.forNewWindow && h != forNewWindowIndex)
				continue;
			
			
			int[] SortedIndeciesOfFragmentsArr = (int[])SortedIndeciesOfCluster.get(h);
			
			for(int i=BinarySearch(SortedIndeciesOfFragmentsArr,0,SortedIndeciesOfFragmentsArr.length-1, proFiles.arrToDrawTheClusters,p1[0])
					;i< SortedIndeciesOfFragmentsArr.length
					;i++)
			{
				
				//there is no score in the cluster file to make ilteration according it
				 //if(!proFiles.filterFragments(SortedIndeciesOfFragmentsArr[i], threshold, proFiles.arrOfCcnScores))
					// continue;
				 
				FragmentPosArrayList fragmentPos = proFiles.arrToDrawTheClusters.get(SortedIndeciesOfFragmentsArr[i]);
				int[] arrToDraw = new int[4];
				
				int[] d =(int[])fragmentPos.get( this.firstGenomeNum);
				arrToDraw[0] = d[0];
				arrToDraw[1] = d[1];
				d =(int[])fragmentPos.get( this.secondGenomeNum);
				arrToDraw[2] = d[0];
				arrToDraw[3] = d[1];
			
				//[0]-->s1 , [1]-->e1,[2]-->s2  ,[3]-->e2
				
				boolean rangeFlag = true;
				for(int jj =0; jj<parent.parent.num;jj++)
				{
					if(jj != this.firstGenomeNum && jj != this.secondGenomeNum)
					{
						int[] dfp =(int[])fragmentPos.get(jj);
						if( !(begindIndexarr[jj] <= dfp[0] &&  endIndexarr[jj] >= dfp[1]))
							rangeFlag=false;
					}//end ofif(j != this.firstGenomeNum && j != this.secondGenomeNum)
				}//end of for(int j =0; j<ProcessingFiles.num;j++)
				
				if(p1[0]<= arrToDraw[0] && p2[0] >= arrToDraw[1] && p1[1]<= arrToDraw[2]&& p2[1]>=arrToDraw[3]&& rangeFlag)
					{
						boolean flagF=false;
						
						String s = "# Cluster";//+ proFiles.arrOfCcnScores[SortedIndeciesOfFragmentsArr[i]];	
						// for All fragment postion
						for(int g=0;g<parent.parent.num;g++)
						{int[] posOfFragment = (int[])fragmentPos.get(g);
							
						s += " ["+posOfFragment[0]+","+posOfFragment[1]+"]"+"  ";
						}
						
						//--------------------------------------------------------------------------------------
						if(proFiles.arrOfReverseLocations.size() > 0)
						{
							ArrayList arr1= (ArrayList)proFiles.arrOfReverseLocations.get(firstGenomeNum);//for first genome
							ArrayList arr2= (ArrayList)proFiles.arrOfReverseLocations.get(secondGenomeNum);//for second genome
							boolean flagifg1ism = false;
							if(arr1.size()>0)//so there is some of reverse index in genome 1
							{
								for(int k=0;k<arr1.size();k++)
								{
									int[] locations1=(int[])arr1.get(k);
									if(SortedIndeciesOfFragmentsArr[i] >= locations1[0] && SortedIndeciesOfFragmentsArr[i]<=locations1[1])//if g1 is m
									{
										flagifg1ism = true;
										for(int kk=0;kk<arr2.size();kk++)
										{
											int[] locations2=(int[])arr2.get(kk);
											if(SortedIndeciesOfFragmentsArr[i] >= locations2[0] && SortedIndeciesOfFragmentsArr[i]<=locations2[1])//if g2 is m
											{
												flagF=true;
												break;
											}//end of if g2 is m
										}//end of for for(int kk=0;kk<arr2.size();kk++)
									}//end of if(SortedIndeciesOfFragmentsArr[i] >= locations1[0] && SortedIndeciesOfFragmentsArr[i]<=locations1[1])//if g1 is m
								}//end of for
							}//if there is some reverse index in genome 1
							if(!flagifg1ism)
							{
								flagF=true;
								for(int kk=0;kk<arr2.size();kk++)
								{
									int[] locations2=(int[])arr2.get(kk);
									if(SortedIndeciesOfFragmentsArr[i] >= locations2[0] && SortedIndeciesOfFragmentsArr[i]<=locations2[1])//if g2 is m
									{
										flagF=false;
										break;
									}//end of if g2 is m
								}//end of for for(int kk=0;kk<arr2.size();kk++)
							}
						}//end of if(proFiles.arrOfReverseLocations.size() > 0)
						else//there is no reverse locations
						{
							flagF=true;
						}
						
				         //-----------------------------------------------------------------------------
						if(flagF)
						{
							if(drawCluster)
							{arrCluster.add("F. Cst."+"File ID:"+h+" "+s);
							selectedClusterIndex.add(""+SortedIndeciesOfFragmentsArr[i]+"\t"+h);}
						}
						
						if(!flagF)
						{
							if(drawRevCluster)
							{arrRevCluster.add("R. Cst."+"File ID:"+h+" "+s);
							selectedRevClusterIndex.add(""+SortedIndeciesOfFragmentsArr[i]+"\t"+h);}
						}
					}//endof if(p1[0]<= arrToDraw[0] && p2[0] >= arrToDraw[1] && p1[1]<= arrToDraw[2]&& p2[1]>=arrToDraw[3]&& rangeFlag)	
				if(p2[0] < arrToDraw[1])
					break;
			}//end of for(int i=0;i< SortedIndeciesOfFragments.length;i++)
			}//end of for(int h=0;h<SortedIndeciesOfFragments.size();h++)
			
			}//end of if drawChaines
			///////////////////////////////////////////////////////
			
			//to get the reverse chaines
			//////////----------------------------------------------
			if (this.drawRevCluster)
			{
				
			for(int j=0;j<SortedIndeciesOfRevCluster.size();j++)
			{
			ProcessingFiles proFiles = (ProcessingFiles)proFilesArr.get(j);
			

//			to check if this panel in new wendow so no overlay
			//to check if the object of the file is for new window not for overlay
			if( this.forNewWindow != proFiles.forNewWindow)
				continue;
			if(this.forNewWindow && j != forNewWindowIndex)
				continue;
			
			int[] SortedIndeciesOfFragmentsArr = (int[])SortedIndeciesOfRevCluster.get(j);
			
			for(int i=
		BinarySearch(SortedIndeciesOfFragmentsArr,0,SortedIndeciesOfFragmentsArr.length-1,proFiles.arrToDrawTheRevClusters,p1[0])
					;i< SortedIndeciesOfFragmentsArr.length
					;i++)
			{
				FragmentPosArrayList fragmentPos = proFiles.arrToDrawTheRevClusters.get(SortedIndeciesOfFragmentsArr[i]);
				int[] arrToDraw = new int[4];
			
				int[] d =(int[])fragmentPos.get( this.firstGenomeNum);
				arrToDraw[0] = d[0];
				arrToDraw[1] = d[1];
				d =(int[])fragmentPos.get( this.secondGenomeNum);
				arrToDraw[2] = d[0];
				arrToDraw[3] = d[1];
				
				boolean rangeFlag = true;
				for(int jj =0; jj<parent.parent.num;jj++)
				{
					if(jj != this.firstGenomeNum && jj != this.secondGenomeNum)
					{
						int[] dfp =(int[])fragmentPos.get(jj);
						if( !(begindIndexarr[jj] <= dfp[0] &&  endIndexarr[jj] >= dfp[1]))
							rangeFlag=false;
					}//end ofif(j != this.firstGenomeNum && j != this.secondGenomeNum)
				}//end of for(int j =0; j<ProcessingFiles.num;j++)
				
				if(p1[0]<= arrToDraw[0] && p2[0] >= arrToDraw[1] && p1[1]<= arrToDraw[2]&& p2[1]>=arrToDraw[3]&& rangeFlag)
				{
					//FragmentPosArrayList  arr = proFiles.arrToDrawTheRevFragments.get(i);
					String s = "# Cluster";//+ proFiles.arrOfRevCcnScores[SortedIndeciesOfFragmentsArr[i]];	
					
					//for All genomes fragment postion
					for(int g=0;g<parent.parent.num;g++)
					{int[] posOfFragment = (int[])fragmentPos.get(g);
						
					s += " ["+posOfFragment[0]+","+posOfFragment[1]+"]"+"  ";
					}
					arrRevCluster.add("R. Cst."+"File ID:"+j+" "+s);
					selectedRevClusterIndex.add(""+SortedIndeciesOfFragmentsArr[i]+"\t"+j);
				}//end of if
				if(p2[0] < arrToDraw[1])
					break;
			}//end of for
			}//end of for
			
			}//end of if (this.drawRevFrag)


			
			//------------------------------ the end of the selection------
			double elapsedTime =(double)(System.currentTimeMillis()-StarTime)/1000;
			parent.parent.toWriteInTheConsoleList("--selection time---"+elapsedTime);
			
			ArrayList arr = new ArrayList();
			
			for(int i = 0; i<arrF.size();i++)
			{
				arr.add(arrF.get(i));
			}
		
			offset = arr.size();
			
			for(int i = 0;i<arrR.size();i++)
			{
				arr.add(arrR.get(i));
			}
		
			offsetForChainFile = arr.size();
			
			for(int i = 0;i<arrChainFile.size();i++)
			{
				arr.add(arrChainFile.get(i));
			}

			offsetForRevChainFile = arr.size();
			
			for(int i = 0;i<arrRevChainFile.size();i++)
			{
				arr.add(arrRevChainFile.get(i));
			}
			
			offsetForCcn = arr.size();
			
			for(int i = 0;i<arrCcn.size();i++)
			{
				arr.add(arrCcn.get(i));
			}
			
			offsetForRevCcn = arr.size();
			
			for(int i = 0;i<arrRevCcn.size();i++)
			{
				arr.add(arrRevCcn.get(i));
			}
			
			
			offsetForCluster = arr.size();
				
			for(int i = 0;i<arrCluster.size();i++)
			{
				arr.add(arrCluster.get(i));
			}
			
			offsetForRevCluster = arr.size();
			for(int i = 0;i<arrRevCluster.size();i++)
			{
				arr.add(arrRevCluster.get(i));
			}
				
			return arr;
}
	 //---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    //	------------------------------------------------------------------------------------
	/*
	 * the binary searh function
	 * param> the array of the index
	 * param>the lower index 
	 * param>the length
	 * param>the index of the file object in the profiles array
	 * param>the value to make comparison"the min mum point in the selected rectangle"
	 */
	 int BinarySearch(int[] arr,int low,int high,MyFragmentPosArrayListToDraw arrOfPoints,int val)
	   {
		   
		int mid;
		while(low<=high){
			 mid = (low + high) / 2;
			 FragmentPosArrayList fragmentPos = arrOfPoints.get(arr[mid]);
			  int[] d =(int[])fragmentPos.get(this.firstGenomeNum);
	         
	          if (val <d[0])
	                 high = mid-1;
	         else if (val>d[0])
	                 low = mid+1;
	         else
	                 return mid;
		}
		return low;
				
	}
	 /**
	  * the binary search function
	  * @param arr:the array list where the search happend
	  * @param low
	  * @param high
	  * @param val
	  * @return the start index where the value will appear in it and the follow it
	  */
	 int BinarySearch(ArrayList arr,int low,int high,int val)
	   {
		
		 int mid;
		while(low<=high){
			 mid = (low + high) / 2;
	         
	          if (val <   Integer.parseInt((String)arr.get(mid))  )
	                 high = mid-1;
	         else if (val>  Integer.parseInt((String)arr.get(mid))   )
	                 low = mid+1;
	         else
	                 return mid;
		}
		return low;
				
	}
	 /*
	  *To Sort the fragment ...but it will only save the fragment index  after sort operation
	//It use QuickSort Algorithm 
	  */

	 void sort(ArrayList a)
	 {
	     sort(a, 0, a.size()-1);
	 }
	 void sort(ArrayList a, int lo0, int hi0)
	 {
	     int lo = lo0;
	     int hi = hi0;
	     
	     if (lo >= hi) {
	         return;
	     }
	     else if( lo == hi - 1 ) {
	         /*
	          *  sort a two element list by swapping if necessary 
	          */
	         if (getValue(a,lo) > getValue(a,hi)) {
	             float  T = getValue(a,lo);
	             a.set(lo, ""+getValue(a,hi)+"") ;
	             a.set(hi,""+ T+"");
	         }
	         return;
	     }
	     /*
	      *  Pick a pivot and move it out of the way
	      */
	     float  pivot = getValue(a,(lo + hi) / 2);
         a.set((lo + hi) / 2, ""+getValue(a,hi)+"") ;
         a.set(hi,""+ pivot+"");
         
	    // int pivot = a[(lo + hi) / 2];
	     //a[(lo + hi) / 2]= a[hi];
	     //a[hi]= pivot;
	     while( lo < hi ) {
	         /*
	          *  Search forward from a[lo] until an element is found that
	          *  is greater than the pivot or lo &gt;= hi 
	          */
	         while (getValue(a,lo) <= pivot && lo < hi) {
	             lo++;
	         }
	         /*
	          *  Search backward from a[hi] until element is found that
	          *  is less than the pivot, or lo &gt;= hi
	          */
	         while (pivot <= getValue(a,hi)&&  lo < hi ) {
	             hi--;
	         }

	         /*
	          *  Swap elements a[lo] and a[hi]
	          */
	         if( lo < hi ) {
	        	 
	        	  float T = getValue(a,lo);
	             a.set(lo, ""+getValue(a,hi)+"") ;
	             a.set(hi,""+ T+"");
	             
	         }
	     }

	     /*
	      *  Put the median in the "center" of the list
	      */
	     a.set(hi0,""+getValue(a,hi)+"");
	     
	     a.set(hi,""+pivot+"");

	     /*
	      *  Recursive calls, elements a[lo0] to a[lo-1] are less than or
	      *  equal to pivot, elements a[hi+1] to a[hi0] are greater than
	      *  pivot.
	      */
	     sort(a, lo0, lo-1);
	     sort(a, hi+1, hi0);
	 }
	 
	 float getValue(ArrayList a , int index)
	 {
		 return Float.parseFloat(  (String)a.get(index)  );
	 }
	 
	
	 /**
	  * 
	  * @param> bb the buffered image
	  * @param s
	  */
	 /*
	  * to export image
	  */
	public void exportImage(BufferedImage bb ,String s)
	{
		try {
            // Save as JPEG
          File  file = new File(s);
            ImageIO.write(bb , "jpg", file);
        } catch (IOException ex) {
        	JOptionPane.showConfirmDialog(null, ""+ex);
        }
	}
//**********************************************************
//  class PanelMouseListener to handle the mouse event     *
//**********************************************************
	class PanelMouseListener extends MouseInputAdapter 
	 {
	 	int xStart = -1;
	 	int yStart = -1;
        public void mousePressed(MouseEvent e) 
        {
            
            
             int x = e.getX();
       		 int y = e.getY();
       		 selectRect.x =x;
       		 selectRect.y= y;
       		 xStart = x;
       		 yStart = y;
       		 selectRect.width= 0;
       		 selectRect.height= 0;
       		 selectFlag= true;
       		// to make sorting in the first time
       		 if(SortedIndeciesOfFragments.size() != proFilesArr.size())
       		 {
       			for(int h = SortedIndeciesOfFragments.size() ;h< proFilesArr.size();h++)
       			{
       				ProcessingFiles proFiles= (ProcessingFiles)proFilesArr.get(h);
       				int[] SortedIndeciesOfFragmentsArr = new int[proFiles.arrToDrawTheFragments.size()];
       				for(int i=0;i<SortedIndeciesOfFragmentsArr.length;i++)
       				{
       					SortedIndeciesOfFragmentsArr[i]=i;
      				 }
       			
       			 proFiles.sort(SortedIndeciesOfFragmentsArr, firstGenomeNum, proFiles.arrToDrawTheFragments);
       			 SortedIndeciesOfFragments.add(SortedIndeciesOfFragmentsArr);
       		 }//end of for(int h = 0;h< proFilesArr.size();h++)
       		 }//end of if(sortFlag || SortedIndeciesOfFragments.size() == proFilesArr.size())
       		 
       		 //to make sorting in the first time
       		 if( SortedIndeciesOfRevFragments.size() != proFilesArr.size())
       		 {
       			 
       			for(int h = SortedIndeciesOfRevFragments.size() ;h< proFilesArr.size();h++)
       			{
       				ProcessingFiles proFiles= (ProcessingFiles)proFilesArr.get(h);
       				int[] SortedIndeciesOfFragmentsArr = new int[proFiles.arrToDrawTheRevFragments.size()];
       				for(int i=0;i<SortedIndeciesOfFragmentsArr.length;i++)
       				{
       					SortedIndeciesOfFragmentsArr[i]=i;
      				 }
       			
       			 proFiles.sort(SortedIndeciesOfFragmentsArr, firstGenomeNum, proFiles.arrToDrawTheRevFragments);
       			 SortedIndeciesOfRevFragments.add(SortedIndeciesOfFragmentsArr);
       		 }//end of for(int h = 0;h< proFilesArr.size();h++)
       		 }//end of if(sortFlag || SortedIndeciesOfFragments.size() == proFilesArr.size())
       		 
//       	 to make sorting in the first time
       		 if(SortedIndeciesOfChainFile.size() != proFilesArr.size())
       		 {
       			
       			for(int h = SortedIndeciesOfChainFile.size() ;h< proFilesArr.size();h++)
       			{
       				ProcessingFiles proFiles= (ProcessingFiles)proFilesArr.get(h);
       				int[] SortedIndeciesOfFragmentsArr = new int[proFiles.arrToDrawTheChainesFile.size()];
       				for(int i=0;i<SortedIndeciesOfFragmentsArr.length;i++)
       				{
       					SortedIndeciesOfFragmentsArr[i]=i;
      				 }
       			
       			 proFiles.sort(SortedIndeciesOfFragmentsArr, firstGenomeNum, proFiles.arrToDrawTheChainesFile);
       			 SortedIndeciesOfChainFile.add(SortedIndeciesOfFragmentsArr);
       		 }//end of for(int h = 0;h< proFilesArr.size();h++)
       		 }//end of if(sortFlag || SortedIndeciesOfFragments.size() == proFilesArr.size())
       		 
//       	 to make sorting in the first time
       		 if(SortedIndeciesOfRevChainFile.size() != proFilesArr.size())
       		 {
       			
       			for(int h = SortedIndeciesOfRevChainFile.size() ;h< proFilesArr.size();h++)
       			{
       				ProcessingFiles proFiles= (ProcessingFiles)proFilesArr.get(h);
       				int[] SortedIndeciesOfFragmentsArr = new int[proFiles.arrToDrawTheRevChainesFile.size()];
       				for(int i=0;i<SortedIndeciesOfFragmentsArr.length;i++)
       				{
       					SortedIndeciesOfFragmentsArr[i]=i;
      				 }
       			
       			 proFiles.sort(SortedIndeciesOfFragmentsArr, firstGenomeNum, proFiles.arrToDrawTheRevChainesFile);
       			 SortedIndeciesOfRevChainFile.add(SortedIndeciesOfFragmentsArr);
       		 }//end of for(int h = 0;h< proFilesArr.size();h++)
       		 }//end of if(sortFlag || SortedIndeciesOfFragments.size() == proFilesArr.size())

//       	 to make sorting in the first time
       		 if(SortedIndeciesOfCcn.size() != proFilesArr.size())
       		 {
       			
       			for(int h = SortedIndeciesOfCcn.size() ;h< proFilesArr.size();h++)
       			{
       				ProcessingFiles proFiles= (ProcessingFiles)proFilesArr.get(h);
       				int[] SortedIndeciesOfFragmentsArr = new int[proFiles.arrToDrawTheChaines.size()];
       				for(int i=0;i<SortedIndeciesOfFragmentsArr.length;i++)
       				{
       					SortedIndeciesOfFragmentsArr[i]=i;
      				 }
       			
       			 proFiles.sort(SortedIndeciesOfFragmentsArr, firstGenomeNum, proFiles.arrToDrawTheChaines);
       			 SortedIndeciesOfCcn.add(SortedIndeciesOfFragmentsArr);
       		 }//end of for(int h = 0;h< proFilesArr.size();h++)
       		 }//end of if(sortFlag || SortedIndeciesOfFragments.size() == proFilesArr.size())
       		 
       		 //to make sorting in the first time
       		 if(SortedIndeciesOfRevCcn.size() != proFilesArr.size())
       		 {
       			for(int h = SortedIndeciesOfRevCcn.size() ;h< proFilesArr.size();h++)
       			{
       				ProcessingFiles proFiles= (ProcessingFiles)proFilesArr.get(h);
       				int[] SortedIndeciesOfFragmentsArr = new int[proFiles.arrToDrawTheRevChaines.size()];
       				for(int i=0;i<SortedIndeciesOfFragmentsArr.length;i++)
       				{
       					SortedIndeciesOfFragmentsArr[i]=i;
      				 }
       			
       			 proFiles.sort(SortedIndeciesOfFragmentsArr, firstGenomeNum, proFiles.arrToDrawTheRevChaines);
       			 SortedIndeciesOfRevCcn.add(SortedIndeciesOfFragmentsArr);
       		 }//end of for(int h = 0;h< proFilesArr.size();h++)
       		 }//end of if(sortFlag || SortedIndeciesOfFragments.size() == proFilesArr.size())

//       	 to make sorting in the first time
       		 if( SortedIndeciesOfCluster.size() != proFilesArr.size())
       		 {
       			for(int h = SortedIndeciesOfCluster.size() ;h< proFilesArr.size();h++)
       			{
       				ProcessingFiles proFiles= (ProcessingFiles)proFilesArr.get(h);
       				int[] SortedIndeciesOfFragmentsArr = new int[proFiles.arrToDrawTheClusters.size()];
       				for(int i=0;i<SortedIndeciesOfFragmentsArr.length;i++)
       				{
       					SortedIndeciesOfFragmentsArr[i]=i;
      				 }
       			
       			 proFiles.sort(SortedIndeciesOfFragmentsArr, firstGenomeNum, proFiles.arrToDrawTheClusters);
       			 SortedIndeciesOfCluster.add(SortedIndeciesOfFragmentsArr);
       		 }//end of for(int h = 0;h< proFilesArr.size();h++)
       		 }//end of if(sortFlag || SortedIndeciesOfFragments.size() == proFilesArr.size())
       		 
       		 //to make sorting in the first time
       		 if(SortedIndeciesOfRevCluster.size() != proFilesArr.size())
       		 {
       			for(int h = SortedIndeciesOfRevCluster.size() ;h< proFilesArr.size();h++)
       			{
       				ProcessingFiles proFiles= (ProcessingFiles)proFilesArr.get(h);
       				int[] SortedIndeciesOfFragmentsArr = new int[proFiles.arrToDrawTheRevClusters.size()];
       				for(int i=0;i<SortedIndeciesOfFragmentsArr.length;i++)
       				{
       					SortedIndeciesOfFragmentsArr[i]=i;
      				 }
       			
       			 proFiles.sort(SortedIndeciesOfFragmentsArr, firstGenomeNum, proFiles.arrToDrawTheRevClusters);
       			 SortedIndeciesOfRevCluster.add(SortedIndeciesOfFragmentsArr);
       		 }//end of for(int h = 0;h< proFilesArr.size();h++)
       		 }//end of if(sortFlag || SortedIndeciesOfFragments.size() == proFilesArr.size())
       		 
        }//end mouse pressed
                
        public void mouseClicked(MouseEvent e) 
        {  
        	if(true) {
        		
        		centerForZooming.x = e.getX();
                centerForZooming.y = e.getY();
        		JPopupMenu popup = createPopupMenu(0);
                popup.show(e.getComponent(),
                           e.getX(), e.getY());     
        	}	
        }
        
        
        public void mouseDragged(MouseEvent e)
        {
            updateSize(e);
            
        }
        
        public void mouseMoved(MouseEvent e)
        {
         int[] x = {e.getX() ,e.getY()};  	
        double[] p = reverseTransformation(x);
        parent.stLabel.setText("   "+p[0]+"   "+p[1]+" ");//+" the mouse "+e.getX()+"   "+e.getY());
        }

		public void mouseReleased(MouseEvent e) 
        {
            updateSize(e);
            //Array list contians the index of select rectangles
           if(selectRect.width > 1 && selectRect.height > 1)
            {
        		JPopupMenu popup = createPopupMenu(1);
                popup.show(e.getComponent(),
                           e.getX(), e.getY());
               
            }
           else
        	   selectFlag = false;
	      //-------------------------------------------------------	
          int[] x = {e.getX() ,e.getY()};
          double[] p = reverseTransformation(x);
			parent.stLabel.setText("   "+p[0]+"   "+p[1]);
       		xStart=-1;
       		yStart=-1;
       		
        }
    
    	void updateSize(MouseEvent e) 
    	{
         int x = e.getX();
         int y = e.getY();
         
       	 int width= x - xStart  ;
       	 int height= y - yStart ;
       	 
       	 //Make the width and height positive, if necessary.
        if (width < 0) 
        {	
            width = 0 - width;
            selectRect.x = xStart - width + 1; 
            if (selectRect.x < 0) 
            {
                width += selectRect.x; 
                selectRect.x = 10;
            }
        }
        if (height < 0) 
        {
            height = 0 - height;
            selectRect.y = yStart - height + 1; 
            if (selectRect.y < 0) 
            {
                height += selectRect.y; 
                selectRect.y = 10;
            }
        }
        
        selectRect.width = width;
        selectRect.height = height;
       	 
        repaint(selectRect.x+50,selectRect.y+50,selectRect.width+20,selectRect.height+20);
        repaint(selectRect.x-50,selectRect.y-50,selectRect.width+20,selectRect.height+20);
        
    	}     
	}//end of inner class for mouse listener
	
	//-------------------------------------------------------------------------------
	
	/**
	 * to create pop menu
	 * param mode: to know if it show selection or not  
	 * param ex and ey: the position of the mouse click
	 */
	JPopupMenu createPopupMenu(int mode)
	{
		JPopupMenu popup = new JPopupMenu();

		JMenu zoom = new JMenu("Zoom");
		JMenuItem zoom1 = new JMenuItem("300%");
		JMenuItem zoom2 = new JMenuItem("200%");
		JMenuItem zoom3 = new JMenuItem("50%");
		JMenuItem zoomMessage = new JMenuItem("Zoom...");
		
		JMenuItem zoomReset = new JMenuItem("Zoom Reset");
		JMenuItem saveSeq = new JMenuItem("Save subSequense");
		
		JMenuItem selectZoom = new JMenuItem("Zoom The Selection Area");
		
		JMenuItem select = new JMenuItem("Select");
		
		zoom1.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent e)
			{
				
				 int [] x ={(int)(centerForZooming.x),(int)(centerForZooming.y)};
				toZoom((double)3,(double)3,x);
			}
		});
		
		zoom2.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent e)
			{
				int [] x ={(int)(centerForZooming.x),(int)(centerForZooming.y)};
				toZoom((double)2,(double)2,x);
			}
		});
		
		zoom3.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent e)
			{
				int [] x ={(int)(centerForZooming.x),(int)(centerForZooming.y)};
				toZoom((double)0.5,(double)0.5,x);
			}
		});
		
		zoomMessage.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent e)
			{
				String inputValue = JOptionPane.showInputDialog(parent.parent,"Please input a value for Zooming(%)","Zoom");
				
				int [] x ={(int)(centerForZooming.x),(int)(centerForZooming.y)};
				
				if( inputValue != null)
				{	if(inputValue.length() > 0 ){
					try{
					float zoomFactor = Float.parseFloat(inputValue);
				    toZoom(zoomFactor/100, zoomFactor/100,x);
					}
				catch(Exception exx)
				{
					JOptionPane.showMessageDialog(parent.parent,"Wrong Format","Error",JOptionPane.ERROR_MESSAGE);
				}//end of catch
				}
				}//end of if
			}
		});
		
		selectZoom.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent e)
			{		
             
				double newZoomFactorX =(float)(scrollPane.getViewport().getVisibleRect().getWidth())/(float)selectRect.width;
				
			    double newZoomFactorY =  (float)(scrollPane.getViewport().getVisibleRect().getHeight())/(float)selectRect.height;
			    
			    int [] x ={(int)( selectRect.getX()),(int)( selectRect.getY())};
			    
			    toZoom(newZoomFactorX, newZoomFactorY,x);
				
			}
		});
		
		select.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent e)
			{
				
				 if(selectFlag)
	                {
	            	ArrayList arrOfFound = getFragmentFromSelectRect(1);
	            
	            //---- the fragment frame where will the fragments will draw its sequences
	            //---------------------------------          
	             FragmentFrame fragmentFrame=new FragmentFrame(arrOfFound.toArray(),parent,DrawPanel.this);
	             fragmentFrame.setLocationRelativeTo(parent); 
	          	 fragmentFrame.setVisible(true);
	          	
	          	   
	            }
				 
				selectRect.width= 0;
	       		selectRect.height= 0;
	       		selectRect.x =-1;
	       		selectRect.y= -1;
	       		selectFlag = false;
			}
		});
		
		zoomReset.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent e)
			{
				int [] x ={(int)(centerForZooming.x),(int)(centerForZooming.y)};
				toZoom(-1,-1,x);
			}
		});
		
		saveSeq.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent e)
			{
				if(parent.parent.numberOfOpenedSeq > 0)
        		{
					
					
					int[] r1 = {(int)selectRect.getMinX(),(int)selectRect.getMinY()};
					
					int[] r2 = {(int)selectRect.getMaxX(),(int)selectRect.getMaxY()};
					
//					the min in drawing coordinates is the max in the real coordinates
					
					double[] rr1 = reverseTransformation(r1);
					double[] rr2 = reverseTransformation(r2);
					
					double[]rangeForG1 = new double[2];
					double[]rangeForG2 = new double[2];
					
					rangeForG1[0] = rr1[0];
					rangeForG1[1] = rr2[0];
					
					rangeForG2[0] = rr2[1];
					rangeForG2[1] = rr1[1];
					//--------------------------------------------------------
	                 //to create sub sequences
	        		//Show dialog; this method does not return until dialog is closed
					JFileChooser fc = new JFileChooser();
	                fc.setDialogTitle("Choose the Directory....... ");
	                fc.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
	                int returnVal =  fc.showSaveDialog(parent);
	                String s="";
	                if (returnVal == JFileChooser.APPROVE_OPTION) 
	             	   {  
	                	s = (String)JOptionPane.showInputDialog(parent,"Write The Name of file : ","Save As........ ",JOptionPane.QUESTION_MESSAGE,
	             	                    null,
	             	                    null,
	             	                    null); 
	        			//for the first genome
	                	if( (firstGenomeNum+1) <= parent.parent.numberOfOpenedSeq )
	        			{
	        				try
	        				{
	        					Sequence originalSeq =(Sequence) parent.parent.arrOfSequences.get(firstGenomeNum);
	        					Sequence seq1 = DNATools.createDNASequence(originalSeq.subStr((int)rangeForG1[0],(int)rangeForG1[1]),originalSeq.getName()+"	The saved Range is:["+(int)rangeForG1[0]+","+(int)rangeForG1[1]+"]");
	        					SeqIOTools.biojavaToFile("fasta","dna",new FileOutputStream(new File(fc.getSelectedFile()+parent.parent.parent.fileDash+s+"_seq "+(firstGenomeNum+1)+"fna")),seq1);
	        				}
	        				catch(Exception ex){JOptionPane.showMessageDialog(parent,"there are some sequences,its file doesn't open ","Warning",JOptionPane.WARNING_MESSAGE);}
	        			}
	        			
	                	//for the second one
	        			if( (secondGenomeNum+1) <= parent.parent.numberOfOpenedSeq )
	        			{
	        				try
	        				{
	        					Sequence originalSeq =(Sequence) parent.parent.arrOfSequences.get(secondGenomeNum);
	        					Sequence seq1 = DNATools.createDNASequence(originalSeq.subStr((int)rangeForG2[0],(int)rangeForG2[1]),originalSeq.getName()+"	The saved Range is:["+(int)rangeForG2[0]+","+(int)rangeForG2[1]+"]");
	        					SeqIOTools.biojavaToFile("fasta","dna",new FileOutputStream(new File(fc.getSelectedFile()+parent.parent.parent.fileDash+s+"_seq "+(secondGenomeNum+1)+"fna")),seq1);
	        				}
	        				catch(Exception ex){JOptionPane.showMessageDialog(parent,"there are some sequences,its file doesn't open ","Warning",JOptionPane.WARNING_MESSAGE);}
	        			}
	                     
	              	   //---------------------------------------------------------------------------------------------------
	                 }
	                 else
	                 {
	                 	JOptionPane.showMessageDialog(parent,"You don't select any files");
	                 }
	        		}//end of if(mainParent.numberOfOpenedSeq > 0)
	            	else
	            	{
	            		JOptionPane.showMessageDialog(parent,"There is no opened sequences","Warning",JOptionPane.WARNING_MESSAGE);
	            	}
				selectFlag = false;
				
			}
		});
		
		
		zoom.add(zoom1);
		zoom.add(zoom2);
		zoom.add(zoom3);
		zoom.add(zoomMessage);
		zoom.addSeparator();
		zoom.add(zoomReset);
		popup.add(zoom);
		if(mode == 0)
		{
			return popup;
		}
		else
		{
			popup.addSeparator();
			popup.add(selectZoom);
			popup.addSeparator();
			popup.add(select);
			popup.addSeparator();
			popup.add(saveSeq);
			return popup;
		}
		
	}
	
	/*
	 * zoomMethod
	 * param>zoom factor in x
	 * param>zoom factor in y
	 * before make zooming the method check if the zoom will be more than the charater size or not
	 * and then make zooming on the axis and the size of the panel...because the points draw with rescpect to the new axis
	 * 
	 * param> x is the point we wnat to make it show in the top left of the window after make the zooming
	 */
	
	void toZoom(double newZoomFactorX , double newZoomFactorY , int[] x)
	{
		
		if(newZoomFactorX == -1 && newZoomFactorY == - 1 )
		{//------------------ ZOOM RESET --------------------
			
			p1.move((int)(p1_old.x),(int)(p1_old.y));
	 		p2.move((int)(p2_old.x),(int)(p2_old.y));
	 		p3.move((int)(p3_old.x),(int)(p3_old.y));
	 		p4.move((int)(p4_old.x),(int)(p4_old.y));
	 		
	 		setPreferredSize(new Dimension((int)(Math.abs(p1.x-p4.x)),(int)(Math.abs(p2.y-p1.y))));
			setSize(new Dimension((int)(Math.abs(p1.x-p4.x)),(int)(Math.abs(p2.y-p1.y))));
			
			
			 scrollPane.getViewport().setViewPosition(p2);
			
			//Listen for value changes in the scroll pane's scrollbars
		     AdjustmentListener listener = new MyAdjustmentListener();
		     scrollPane.getHorizontalScrollBar().addAdjustmentListener(listener);
		     scrollPane.getVerticalScrollBar().addAdjustmentListener(listener);
		     scrollPane.getHorizontalScrollBar().setUnitIncrement( (int) (firstEnd/getSize().getWidth()));
		     scrollPane.getHorizontalScrollBar().setBlockIncrement( 2*(int) (firstEnd/getSize().getWidth()));
		     scrollPane.getVerticalScrollBar().setUnitIncrement((int) (secondEnd/getSize().getHeight()));
		     scrollPane.getVerticalScrollBar().setBlockIncrement(2*(int) (secondEnd/getSize().getHeight())); 
		     makeRuler();
		     //because has been assigned true and the drawing will be the image, so it must be false agian
		     selectFlag = false;
		     
		}
		else{
		if( (  ((float)getSize().getWidth()*newZoomFactorX)/firstEnd) <= charcterFontSize )		
		{
			zoomFactorX =newZoomFactorX;
		}
		else
		{		
			zoomFactorX =    (float)(firstEnd * charcterFontSize)/(float)getSize().getWidth();	
			JOptionPane.showMessageDialog(parent, "max  ZOOM-- "+newZoomFactorX+"   " +"& max is assign which are  "+zoomFactorX);		
		}	
		if( (  ((float)getSize().getHeight()*newZoomFactorY)/secondEnd) <= charcterFontSize )
		{
		    zoomFactorY =  newZoomFactorY;
		}
		else
		{	
		    zoomFactorY = (float)(secondEnd * charcterFontSize)/(float)getSize().getHeight() ; 
		    JOptionPane.showMessageDialog(parent, "max  ZOOM-- "+"   "+ newZoomFactorY+"  & max is assign which are  "+zoomFactorY);
		}

        if(zoomFactorX*firstEnd < 2147483647 && zoomFactorY*secondEnd < 2147483647)
        {
        	//must make the selection of zoom fragments before change the axis
        	//ArrayList arrOfFound = getFragmentFromSelectRect(0);
        //to store thr real coordinates..of the top left of the rectangle
        
	     double[] p = reverseTransformation(x);
	    
	     if(zoomFactorX != 1 || zoomFactorY != 1)
			{
	    	 boolean flag=true;
		 		Point p1old = new Point(p1.x,p1.y);
		 		Point p2old = new Point(p2.x,p2.y);
		 		
		 		
		 		if((int)(Math.round((float)p1.x*(float)zoomFactorX)) > 1 && (int)( Math.round((float)p1.y*(float)zoomFactorY)) > 1)
		 		
		 		
		 		if((int)(Math.round((float)p2.x*(float)zoomFactorX)) > 1 && (int)( Math.round((float)p2.y*(float)zoomFactorY)) > 1)
		 			
		 		
		 		if((int)(Math.round((float)p3.x*(float)zoomFactorX)) > 1 && (int)( Math.round((float)p3.y*(float)zoomFactorY)) > 1)
		 			
		 		
		 		if((int)(Math.round((float)p4.x*(float)zoomFactorX)) > 1 && (int)( Math.round((float)p4.y*(float)zoomFactorY)) > 1)
		 		{
		 			p1.move((int)(Math.round((float)p1.x*(float)zoomFactorX)),(int)( Math.round((float)p1.y*(float)zoomFactorY)));
		 			p2.move((int)(Math.round((float)p2.x*(float)zoomFactorX)),(int)( Math.round((float)p2.y*(float)zoomFactorY)));
			 		p3.move((int)(Math.round((float)p3.x*(float)zoomFactorX)),(int)( Math.round((float)p3.y*(float)zoomFactorY)));
		 			p4.move((int)(Math.round((float)p4.x*(float)zoomFactorX)),(int)( Math.round((float)p4.y*(float)zoomFactorY)));
		 		
		 		
		 		int dx = p1old.x - p1.x;
		 		int dy= p2old.y - p2.y;
		 		
		 		p1.translate(dx, dy);
		 		p2.translate(dx, dy);
		 		p3.translate(dx, dy);
		 		p4.translate(dx, dy);
		 		}
		 		
			}
	     
	 	
	 	setPreferredSize(new Dimension((int)(Math.abs(p1.x-p4.x)),(int)(Math.abs(p2.y-p1.y))));
		setSize(new Dimension((int)(Math.abs(p1.x-p4.x)),(int)(Math.abs(p2.y-p1.y))));		
	     // Listen for value changes in the scroll pane's scrollbars
	     AdjustmentListener listener = new MyAdjustmentListener();
	     scrollPane.getHorizontalScrollBar().addAdjustmentListener(listener);
	     scrollPane.getVerticalScrollBar().addAdjustmentListener(listener);
	     scrollPane.getHorizontalScrollBar().setUnitIncrement( (int) (Math.round((float)firstEnd/(float)getSize().getWidth() )));
	     scrollPane.getHorizontalScrollBar().setBlockIncrement( 2*(int) (Math.round( (float)firstEnd/(float)getSize().getWidth()) ));
	     scrollPane.getVerticalScrollBar().setUnitIncrement((int) (Math.round((float)secondEnd/(float)getSize().getHeight()) ));
	     scrollPane.getVerticalScrollBar().setBlockIncrement(2*(int) (Math.round((float)secondEnd/(float)getSize().getHeight())) );     
	     makeRuler();			     
	     p[0]=(int)(p[0]*   (float) ((float)Math.abs(p4.x-p3.x)/(float)firstEnd))+p1.x;//'+p1.x' because the origin is translate
		 p[1]=(-(int)(p[1]* (float)((float)Math.abs(p1.y-p2.y)/(float)secondEnd))+p1.y);//'+p1.y' because the origin is translate
			
		 scrollPane.getViewport().setViewPosition(new Point((int)p[0],(int)p[1]));
		     
        } //end of  if(zoomFactorX*firstEnd < 2147483647 && zoomFactorY*secondEnd < 2147483647)
        else
        {
        	JOptionPane.showMessageDialog(parent, "no ZOOM-- "+zoomFactorX+"   "+ zoomFactorY);
        }
		selectFlag = false;
	}//end of else "not zoom reset"
	}//end of method
	//---------------------------------------------------------------
	class MsgBox extends JDialog implements ActionListener {
		 boolean id = false;
		 Button ok;
		 Button can;
		 public JTextField startText;
		 public JTextField endText;
		 public boolean flagOfVisibility = false;
		 public int[] begindIndexarr;
		 public int[] endIndexarr;
		 MsgBox(String msg, boolean okcan,int[] arrbegin,int[] endarr){
			 super(parent.parent.parent);
			 begindIndexarr = arrbegin;
			 endIndexarr = endarr;
		  this.setTitle("Message....");
		  this.setModal(true);
		  this.getContentPane().setLayout(new BorderLayout());
		  this.getContentPane(). add(new Label(msg),BorderLayout.NORTH);
		  addRangePanel();
		  addOKCancelPanel(okcan);
		  createFrame();
		  pack();
		  setVisible(true);
		  }

		 void addRangePanel( ) {
			  Panel p = new Panel();
			  p.setLayout(new GridLayout(6,1));
			  JLabel start = new JLabel(" Ranges (e.g., 1000-2000,3500-5600,..) in");
			  JLabel end = new JLabel(" Genomes: (e.g., 1,3,5,..)");
			  JLabel comment1 = new JLabel("Empty 'Ranges' field: adds no constraints w.r.t. the non-projects genomes");
			  JLabel comment2 = new JLabel(" Clicking 'Cancel' ignores all the ranges in the 'Ranges' field");
			  startText = new JTextField();
			  endText=new JTextField();
			  p.add(start);
			  p.add(startText);
			  p.add(end);
			  p.add(endText);
			  p.add(comment1);
			  p.add(comment2);
			  this.getContentPane().add(p,BorderLayout.CENTER);
			  }
		 
		 void addOKCancelPanel( boolean okcan ) {
		  Panel p = new Panel();
		  p.setLayout(new FlowLayout());
		  createOKButton( p );
		  if (okcan == true)
		     createCancelButton( p );
		  this.getContentPane().add(p,BorderLayout.SOUTH);
		  }

		 void createOKButton(Panel p) {
		  p.add(ok = new Button("OK"));
		  ok.addActionListener(this); 
		  }

		 void createCancelButton(Panel p) {
		  p.add(can = new Button("Cancel"));
		  can.addActionListener(this);
		  }

		 void createFrame() {
		  Dimension d = getToolkit().getScreenSize();
		  setLocation(d.width/3,d.height/3);
		  }

		 public void actionPerformed(ActionEvent ae){
		  if(ae.getSource() == ok) {
		    id = true;
		    setVisible(false);
		    
		    //----------------- to know the ranges of the other projections
		    ArrayList genomeIndex = new ArrayList();
		    ArrayList  ranges = new ArrayList();
		    boolean flag = false;
		try{
		
		//--- to take the ranges
		StringTokenizer st1 = new StringTokenizer(startText.getText(),",");
		for(int i = 0; i < st1.countTokens();i++)
		{
			StringTokenizer st2 = new StringTokenizer(startText.getText(),"-");
			int[] range2D = new int[2];
			range2D[0] = Integer.parseInt(st2.nextToken());
			range2D[1] = Integer.parseInt(st2.nextToken());
			ranges.add(range2D);
		}
		
		st1 = new StringTokenizer(endText.getText(),",");
		for(int i = 0; i < st1.countTokens();i++)
		{ 
			genomeIndex.add(st1.nextToken());
			int[] checkranges = (int[])ranges.get(i);
			
			if(checkranges[0]  >= 0 && checkranges[0] <= endIndexarr[Integer.parseInt((String)genomeIndex.get(i))-1]  &&
					checkranges[1]  >= 0 && checkranges[1] <= endIndexarr[Integer.parseInt((String)genomeIndex.get(i))-1] && checkranges[0] < checkranges[1])
			{
				flag = true;
			}
			else
			{
				throw(new Exception());
			}
		}
		for(int i = 0; i <genomeIndex.size()  ;i++)
		{ 
			int[] checkranges = (int[])ranges.get(i);
			if(   flag  &&Integer.parseInt((String)genomeIndex.get(i)) != firstGenomeNum+1 && Integer.parseInt((String)genomeIndex.get(i)) != secondGenomeNum+1  )
			{
				begindIndexarr[ (Integer.parseInt((String)genomeIndex.get(i)) -1 ) ] = checkranges[0];
				endIndexarr[ (Integer.parseInt((String)genomeIndex.get(i))-1) ] = checkranges[1];
				
			}
		}
		if(genomeIndex.size() == 0 && ranges.size() == 0)
		{
			JOptionPane.showMessageDialog(parent.parent, "Empty spaces ,it act as cancel","Information",JOptionPane.INFORMATION_MESSAGE);
		}
		}//end of try   // make parssing
		catch(Exception exx)
		{
			JOptionPane.showMessageDialog(parent.parent, "Non-correct format for Ranges/Geomes","Error",JOptionPane.ERROR_MESSAGE);
			setVisible(true);
		} 
	 }
		  else if(ae.getSource() == can) {
		    setVisible(false);
		    }
		  }
		}
	//-----------------------------------------------------------*-*-**-***************----------------------------------**********
	class MyAdjustmentListener implements AdjustmentListener {
        // This method is called whenever the value of a scrollbar is changed,
        // either by the user or programmatically.
        public void adjustmentValueChanged(AdjustmentEvent evt) {
            Adjustable source = evt.getAdjustable();
    
            // getValueIsAdjusting() returns true if the user is currently
            // dragging the scrollbar's knob and has not picked a final value
            if (evt.getValueIsAdjusting()) {
                // The user is dragging the knob
                return;
            }
    
            // Determine which scrollbar fired the event
            int orient = source.getOrientation();
            if (orient == Adjustable.HORIZONTAL) {
                // Event from horizontal scrollbar
            } else {
                // Event from vertical scrollbar
            }
    
            // Determine the type of event
            int type = evt.getAdjustmentType();
            switch (type) {
              case AdjustmentEvent.UNIT_INCREMENT:
                  // Scrollbar was increased by one unit
                  break;
              case AdjustmentEvent.UNIT_DECREMENT:
                  // Scrollbar was decreased by one unit
                  break;
              case AdjustmentEvent.BLOCK_INCREMENT:
                  // Scrollbar was increased by one block
                  break;
              case AdjustmentEvent.BLOCK_DECREMENT:
                  // Scrollbar was decreased by one block
                  break;
              case AdjustmentEvent.TRACK:
                  // The knob on the scrollbar was dragged
                  break;
            }
    
            // Get current value
            int value = evt.getValue();
        }
    }
}//end of classes
