/*
*DrawLinealModePanel.java 
*
*
*the panel where the lineal mode will draw , and here is the selection and zoom for the lineal mode
*
*
*
*Asem A. Othman
*/
import java.awt.*;
import java.awt.image.*;
import java.text.*;
import java.util.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.event.*;
import javax.imageio.*;
import java.io.*;



public class DrawLinealModePanel extends DrawPanel
{

	/**
	 * 
	 * @uml.property name="proFilesArr"
	 * @uml.associationEnd multiplicity="(0 -1)" elementType="ProcessingFiles"
	 */
	//->Variables
	//	To know what it will take from the profile object
	public ArrayList proFilesArr = new ArrayList();

	
  //	falges to know what will appear in the plot
	//these flages update in the action listener of the check box 
    public boolean drawFrag = true;
    public boolean drawChain = true;
    public boolean drawChainFile = true;
    public boolean drawCluster = true;
    
    public boolean drawRevFrag = true;
    public boolean drawRevChain = true;
    public boolean drawRevChainFile = true;
    public boolean drawRevCluster = true;
    
//  the colors of the lines
    public Color drawFragColor = new Color(255,100,100);
    public Color drawChainColor = new Color(255,50,100);
    public Color drawChainFileColor = new Color(0,128,128);
    public Color drawClusterColor = new Color(0,205,0);
    
    public Color drawRevFragColor = new Color(0,0,0);
    public Color drawRevChainColor = new Color(255,0,0);
    public Color drawRevChainFileColor = new Color(255,250,0);
    public Color drawRevClusterColor = new Color(128,0,128);
    
    //the points of the drawn axis
    Point axisPoint = new Point(540,20);//the axis point which according to it the scale will happen

	/**
	 * 
	 * @uml.property name="panelMouseListener"
	 * @uml.associationEnd multiplicity="(1 1)" inverse="this$0:DrawLinealModePanel$PanelMouseListener"
	 */
	//to make selection and zoom
	PanelMouseListener panelMouseListener = new PanelMouseListener();

    
    //to draw rectangle when select from the panel 
    Rectangle selectRect= new Rectangle(0,0,0,0); 
    boolean selectFlag = false;

	/**
	 * 
	 * @uml.property name="selectedFragmentsIndex"
	 * @uml.associationEnd multiplicity="(0 -1)" elementType="java.lang.String"
	 */
	// to store the index of selected fragments
	Vector selectedFragmentsIndex;

    Vector selectedRevFragmentsIndex ;
	//when showing the selected fragments in the list there are offset
	//in indecies for the reverse fragmnets
	int offset;
    
	//- to draw with specific pen
	final static BasicStroke stroke2f = new BasicStroke(2f);
	final static BasicStroke stroke1f = new BasicStroke(1f);
	final static float dash1[] = {10.0f};
	final static BasicStroke selectStroke = new BasicStroke(2.0f, 
                                                      BasicStroke.CAP_BUTT, 
                                                      BasicStroke.JOIN_MITER, 
                                                      10.0f, dash1, 0.0f);
	
	//For Sort before selection
	boolean sortFlag = true;

	/**
	 * 
	 * @uml.property name="sortedIndeciesOfFragments"
	 * @uml.associationEnd multiplicity="(0 -1)" elementType="[I"
	 */
	ArrayList SortedIndeciesOfFragments = new ArrayList();

	
	
	//- To try the image buffer
	BufferedImage backGroundImage;  // declare the image
	Graphics2D g;
	int widthOfImage= 0;
	int heightOfImage =0;

	/**
	 * 
	 * @uml.property name="parent"
	 * @uml.associationEnd multiplicity="(1 1)" inverse="panel:VisChainerLinealMode"
	 */
	//the refrence to the window on it this panel
	VisChainerLinealMode parent;

	/**
	 * 
	 * @uml.property name="scrollPane"
	 * @uml.associationEnd multiplicity="(1 1)"
	 */
	JScrollPane scrollPane;

	/**
	 * 
	 * @uml.property name="zoomFactorX" 
	 */
	//---- To Zoom
	double zoomFactorX = 1;

	double  zoomFactorY = 1;
	Point centerForZooming = new Point(0,0);
	
	//--the maximum length of the allgenomes
	int theMaxLength =0;
	//--the height between the axis of the genomes
	int heightInterval = 100;
	int firstLineY = 20;//where the first axis will draw in y axis
//	---the charcter font size
	int charcterFontSize = 10 ;
	int rulerStep = 50;
	int sizeOfXruler = 25;//for the size of the column header in y..but it x ruler
	
	//--object from the system to capture the image
	private Robot robot ;
	
//	-[flag]this panel have array of all the objects of the files..so if it will darw only one file in new window, the flag become true
	//in the lineal mode it will never draw the file opened and doesn't overlay on the main window"future work..make for it , its own lineal mode window"
	public boolean  forNewWindow = false;
	int forNewWindowIndex =-1;
	
	//---if the zooming happen the user can crop only the selection
	boolean cropZoomFlag = false; 
	int max = 0 ;
	int min = 0 ;
	/*
	 * the constractoe
	 * param>the parent window
	 * param>the scroll pane that will add to it the ruler and move it after make zooming
	 */
	DrawLinealModePanel(VisChainerLinealMode p,JScrollPane scp)
	{
		super(p,scp);
		parent = p;
		scrollPane = scp;
		this.addMouseListener(this.panelMouseListener);
		this.addMouseMotionListener(this.panelMouseListener);
		 //--make the ruler in the begining
		makeRuler();
		    
		    try {
			      robot = new Robot();
			    } catch (AWTException awte) {
			      awte.printStackTrace();}
		
	}
	
	/*
	 * capture 
	 * this method will capture image form the window opened 
	 * return>buffered image ...to draw or to export as file
	 */
	 BufferedImage capture() {
	     
	      Rectangle screen = scrollPane.getViewport().getViewRect();
	      Point loc = screen.getLocation();
	      SwingUtilities.convertPointToScreen(loc,DrawLinealModePanel.this);
	      screen.setLocation(loc);
	      return robot.createScreenCapture(screen);
	  }
	 
	 
//	/---------- set ruler mode
	 /*
	  * setrulerMode
	  * param> range which will draw in the panel, in the ruler
	  * and return the number of the mode
	  * 1> normal
	  * 2>skip
	  * 3>write expontional number
	  * this mode according the ruler step and the character font size..
	  */
	 int setRulerMode(int range)
	 {
		 int rulerDrawingMode=1;
		 String temp = ""+range+"";
	     if((float)rulerStep/(float)charcterFontSize  > (temp.length()-2) )
	     {
	    	 rulerDrawingMode =1;//draw normally
	     }
	     else
	    	 if((float)rulerStep/(float)charcterFontSize  > (temp.length()*2-2))
	    	 {
		    	 rulerDrawingMode =2;//skip
		     }
	    	 else
	    	 {
	    		 rulerDrawingMode =3;//exponential mode
	    	 }
	     return rulerDrawingMode;
	 }
	 
	 /*
	  * draw the ruler
	  */
	 void makeRuler()
	 {
		 JLabel[] corners = new JLabel[4];
	     for (int i = 0; i < 4; i++) {
	       corners[i] = new JLabel();
	       corners[i].setBackground(Color.white);
	       corners[i].setOpaque(true);
	     } 
	    	JLabel columnheader = new JLabel() {
	       public void paintComponent(Graphics g) {
	         super.paintComponent(g);
	         Rectangle r = g.getClipBounds();
	        int rulerDrawingMode = setRulerMode( (int)(r.getMaxX()*( (float)theMaxLength / (float)axisPoint.x) )  );
	         if(rulerDrawingMode==1){
	         for (int i = rulerStep - (r.x % rulerStep); i < r.width; i += rulerStep) {
	        	 g.drawLine(r.x + i,sizeOfXruler-3, r.x + i, sizeOfXruler);
		         int newX = (int)((r.x + i)*((float)theMaxLength/(float)axisPoint.x));
		         g.drawString("" +newX , r.x + i - 10, 16);
	         }//end of for
	         }//end of if
	         if(rulerDrawingMode==2){
		         for (int i = rulerStep - (r.x % rulerStep); i < r.width; i += (rulerStep*2)) {
		        	 g.drawLine(r.x + i,sizeOfXruler-3, r.x + i, sizeOfXruler);
			         int newX = (int)((r.x + i)*((float)theMaxLength/(float)axisPoint.x));
			         g.drawString("" +newX , r.x + i - 10, 16);
		         }//end of for
		         }//end of if
	         if(rulerDrawingMode==3){
	        	 DecimalFormat formatter = new DecimalFormat("###E0");  // exponent must be multiple of 3;
	        	 String s;
		         for (int i = rulerStep - (r.x % rulerStep); i < r.width; i += rulerStep) {
		        	 g.drawLine(r.x + i,sizeOfXruler-3, r.x + i, sizeOfXruler);
			         int newX = (int)((r.x + i)*((float)theMaxLength/(float)axisPoint.x));
		            s = formatter.format(newX); 
		           g.drawString("" +s , r.x + i - 10, 16);
		         }//end of for
		         }//end of if
	       }

	       public Dimension getPreferredSize() {
	         return new Dimension((int) DrawLinealModePanel.this.getPreferredSize().getWidth(),
	        		 sizeOfXruler);
	       }
	     };
	     columnheader.setBackground(Color.white);
	     columnheader.setOpaque(true);
	     
	    scrollPane.setColumnHeaderView(columnheader);
	    scrollPane.setCorner(JScrollPane.LOWER_LEFT_CORNER, corners[0]);
	    scrollPane.setCorner(JScrollPane.LOWER_RIGHT_CORNER, corners[1]);
	    scrollPane.setCorner(JScrollPane.UPPER_LEFT_CORNER, corners[2]);
	    scrollPane.setCorner(JScrollPane.UPPER_RIGHT_CORNER, corners[3]);
	     
	 }
	 //paint function
	 /*
	  * paint function of the panel
	  * override on the paint function in the super class
	  */
	public void paint(Graphics g1) 
	{
		//super.paint(g1);

		if(selectFlag )
		{	
			Graphics2D gc = (Graphics2D)g1;
		if(backGroundImage == null)
				backGroundImage = capture();
		Rectangle screen = scrollPane.getViewport().getViewRect();
	     Point loc = screen.getLocation();
         //Draw the precomputed image
	     gc.drawImage(backGroundImage,loc.x,loc.y,null);
		gc.setStroke(selectStroke);
		//to draw select rectangle 
		gc.setColor(new Color(0,128,200));
		gc.drawRect(this.selectRect.x,this.selectRect.y,this.selectRect.width,this.selectRect.height);
		}
		if(!selectFlag)
		{
			backGroundImage=null;
			Graphics2D g = (Graphics2D)g1;
			toDraw(g);
		}
	}
	/*
	 * to draw
	 * this the method which will draw the axis and then pass on all the file objects in the 
	 * profiles arr and draw the file according to the flag and the color
	 * the points will draw in another method,this method send the array list of the fragment postion to it
	 */
	void toDraw(Graphics2D g)
	{
	
		//	 to darw axis
        this.drawAxis(g);
        for(int i =0 ; i< proFilesArr.size();i++)
		{
		ProcessingFiles proFiles =(ProcessingFiles)proFilesArr.get(i);
		
		if( this.forNewWindow != proFiles.forNewWindow)
			continue;
		if(this.forNewWindow && i != forNewWindowIndex)
			continue;
		g.setStroke(stroke2f);
		
		g.setColor(drawChainFileColor);
		if(drawChainFile)
		this.drawChaines(g,proFiles.arrToDrawTheChainesFile,proFiles,false);
		
	
		g.setColor(drawChainColor);
		if(drawChain)
		this.drawChaines(g,proFiles.arrToDrawTheChaines,proFiles,false);
		
		g.setColor(drawClusterColor);
		if(drawCluster)
		this.drawChaines(g,proFiles.arrToDrawTheClusters,proFiles,false);
		
		g.setColor(drawRevChainFileColor);
		if(drawRevChainFile)
		this.drawChaines(g,proFiles.arrToDrawTheRevChainesFile,proFiles,true);
		
		g.setColor(drawRevChainColor);
		if(drawRevChain)
		this.drawChaines(g,proFiles.arrToDrawTheRevChaines,proFiles,true);
		
		g.setColor(drawRevClusterColor);
		if(drawRevCluster)
		this.drawChaines(g,proFiles.arrToDrawTheRevClusters,proFiles,true);
		
		g.setStroke(stroke1f);
		//--------- to draw the forward ------
		g.setColor(drawFragColor);
		if(drawFrag)
		{
			if( !cropZoomFlag)
				this.drawChaines(g,proFiles.arrToDrawTheFragments,proFiles,false);
			else
				this.drawTheSelectionArea(g, proFiles.arrToDrawTheFragments, proFiles);
		
		}
		//--------- to draw Reverse --------
		g.setColor(drawRevFragColor);
		if(drawRevFrag)
		this.drawChaines(g,proFiles.arrToDrawTheRevFragments,proFiles,true);
		
		toDrawAnnotations(g);
		}
	}
	//-----------------------------------------------------------------------
	//---------- Draw Axis --------------
	void drawAxis(Graphics2D g)
	{  
		g.setColor(Color.BLACK);
		g.setStroke(stroke2f);
		for(int i =0 ; i < parent.parent.num; i++)
		{
			if(i == 0)
				g.drawLine(0, 20,axisPoint.x,20);
			else
				g.drawLine(0, (int)((i)*heightInterval),axisPoint.x, (int)((i)*heightInterval));
		}
		
	}
	
	//----------------------------------------------------------------------
	// DARW THE FRAGMENTS in 2D plot 
	//// DARW THE CHIANES in 2D plot
	//// DARW THE Clusters in 2D plot
	/////////////////////------------------------------------------------
	//				TO DRAW THE REVRSE FILE.
	//-------------------------------------------------------------------
	// DARW THE FRAGMENTS in 2D plot 
	//// DARW THE CHIANES in 2D plot 
	//// DARW THE Clusters in 2D plot   
	public  void drawChaines(Graphics g, MyFragmentPosArrayListToDraw arrListToDraw,ProcessingFiles proFiles,boolean ReverseFlag)
	 {
		float forG  = (float)axisPoint.x / (float)theMaxLength;
		 for(int i=0; i< arrListToDraw.size();i++)
		 	{	
			 FragmentPosArrayList fragmentPos = arrListToDraw.get(i);
	 		for(int j=1 ; j< parent.parent.num;j++)
	 		{
	 			int[] d1 = fragmentPos.get(j-1);
	 			int[] d2 = fragmentPos.get(j);
	 			if(j==1)
	 				g.drawLine((int)(  ((d1[0]+d1[1])/2) *forG),firstLineY, (int)(( (d2[0]+d2[1])/2) *forG ),(int)((j)*heightInterval));
	 			else
	 				g.drawLine((int)(((d1[0]+d1[1])/2)*forG), (int)((j-1)*heightInterval), (int)(((d2[0]+d2[1])/2)*forG), (int)((j)*heightInterval));
	 			}
		 	}	
	 }
	  
	 int reverseTransformation(int x)
	 {
		 	int  p = (int)(x * ((float)theMaxLength/(float)axisPoint.x));
		 	
		    return p;
	 }
	 /*
		 * to draw only the select in case of the zooming
		 * and now it work only with fragments
		 */
		void drawTheSelectionArea(Graphics2D g, MyFragmentPosArrayListToDraw arrListToDraw,ProcessingFiles proFiles)
		 { 
			float forG  = (float)axisPoint.x / (float)theMaxLength;
			int indexOfObject = proFilesArr.indexOf(proFiles);
			
	        int[] SortedIndeciesOfFragmentsArr = (int[])SortedIndeciesOfFragments.get(indexOfObject);
	       
	        int startIndex= 0;
	        	//-------------------
	        	//BinarySearch(SortedIndeciesOfFragmentsArr,0,SortedIndeciesOfFragmentsArr.length-1, indexOfObject,(int)min);
			
			for(int i =startIndex ;i< SortedIndeciesOfFragmentsArr.length;i++)
				{
					FragmentPosArrayList  fragmentPos = arrListToDraw.get(SortedIndeciesOfFragmentsArr[i]);
					int[] d = fragmentPos.get(0);
					
					if(d[0] < max  && d[1] < max &&d[0] >  min&& d[1] > min  )
					{
						for(int j=1 ; j< parent.parent.num;j++)
			 			{
							int[] d1 = fragmentPos.get(j-1);
				 			int[] d2 = fragmentPos.get(j);
				 			if(j==1)
				 				g.drawLine((int)(  ((d1[0]+d1[1])/2) *forG),firstLineY, (int)(( (d2[0]+d2[1])/2) *forG ),(int)((j)*heightInterval));
				 			else
				 				g.drawLine((int)(((d1[0]+d1[1])/2)*forG), (int)((j-1)*heightInterval), (int)(((d2[0]+d2[1])/2)*forG), (int)((j)*heightInterval));
			 			}
					}
				}
			
	 }
		/**
		 * draw the annotaion of the genomes
		 * @param g
		 */
		void toDrawAnnotations(Graphics2D g)
		{
			ArrayList  arrAnno = parent.parent.annoObjects;
			float forG  = (float)axisPoint.x / (float)theMaxLength;
			for(int i =0; i< arrAnno.size();i++)
			{
				AnnotationForGenome anno = (AnnotationForGenome)arrAnno.get(i);
				for(int j = 0 ; j< anno.annotationInfo.size();j++)
				{
					int[] arrForInfo = (int[])anno.annotationInfo.get(j);
					
					float xMin = arrForInfo[1]*forG;
					float xMax = arrForInfo[2]*forG;
					//if( i==1)
					Arrow.drawHorizArrow(g, Color.RED, (int)xMin,firstLineY, (int)(xMax-xMin), "AS",Arrow.RIGHT);
				}
			}
		}
		/**
		 *  getFragmentFromSelectRect== 
		 * will return array list contians the stirng of the selected fragments
		* getFragmentFromSelectRect== 
		 *will return array list contians the stirng of the selected fragments
		 * @param notSelect
		 * @return
		 */
		 
		 public ArrayList getFragmentFromSelectRect(int notSelect)
		{
			 //to store the indeices of the selected fragments..in the array which draw the file
			this.selectedFragmentsIndex = new Vector();
			this.selectedRevFragmentsIndex = new Vector();
			offset = 1;
			
			//to store all information of the fragment as string and send then to the return array
			ArrayList arrF=new ArrayList();
			ArrayList arrR=new ArrayList();
			
			arrF.add("Forward Fragments ------------------------------------------");
			arrR.add("Reverse Fragments-------------------------------------------");
			
			//----- to know the range in other projections,if it entered by the message box
			int[] begindIndexarr=new int[parent.parent.num];
			int[] endIndexarr=new int[parent.parent.num];
			
			for(int j =0; j<parent.parent.num;j++)
			{
				begindIndexarr[j] = 0;
				endIndexarr[j] =(int) parent.parent.maxEndInFragments.get(j);
			}//end of for(int j =0; j<ProcessingFiles.num;j++)
			//to show the funcction in case if the user choose selestion not zoom from the popup menu
			if(parent.parent.num > 2 && notSelect ==1 )
			{
				//show the message box and make the check in the action of ok button
				MsgBox msg=new MsgBox("Enter the Range in Genome",true,begindIndexarr,endIndexarr);
			}//if if(ProcessingFiles.num > 2)
			
			
			/*
			 * the selection happened on the sorted array of the index
			 * binary search used only to find the start point to search in the sorted index array
			 */
			
			if(this.drawFrag)
			{
			//--------------------------------------------------------------------------
			long StarTime = System.currentTimeMillis();
			
			//when find the start point in the genome start search until the end point
			boolean flag1 = true;
			
			int p1= selectRect.x;
			int p2= selectRect.x+selectRect.width;
			double  temp =reverseTransformation(p1);
			p1=(int)temp;
			temp = reverseTransformation(p2);
			p2=(int)temp;
			
			//begin the select by looking in the sorted array of the indecis
			for(int h=0;h<SortedIndeciesOfFragments.size();h++)
			{
			ProcessingFiles proFiles = (ProcessingFiles)proFilesArr.get(h);
			int[] SortedIndeciesOfFragmentsArr = (int[])SortedIndeciesOfFragments.get(h);
			
			for(int i=0/*BinarySearch(SortedIndeciesOfFragmentsArr,0,SortedIndeciesOfFragmentsArr.length-1, h,p1)*/;i< SortedIndeciesOfFragmentsArr.length;i++)
			{
				FragmentPosArrayList fragmentPos = proFiles.arrToDrawTheFragments.get(SortedIndeciesOfFragmentsArr[i]);
				boolean selectedFlag = false;
				for(int w =0 ; w< parent.parent.num ; w++)
				{
					int[] arrForCompare = (int[])fragmentPos.get(w);
					if(arrForCompare[0] > p1 && arrForCompare[0] < p2)
					{
						selectedFlag = true;
					}
					else
					{
						break;
					}
				}
				
				if(selectedFlag)
				{
					//Fragment f =
					FragmentPosArrayList  arr = proFiles.arrToDrawTheFragments.get(SortedIndeciesOfFragmentsArr[i]);
					String s = "#"+ proFiles.arrOfFragmentScores[SortedIndeciesOfFragmentsArr[i]];	
					for(int g=0;g<parent.parent.num;g++)
					{
						int[] posOfFragment = (int[])arr.get(g);	
						s += " ["+posOfFragment[0]+","+posOfFragment[1]+"]"+"  ";
					}
					arrF.add(s);
					selectedFragmentsIndex.add(""+i+"\t"+h);
				}
				
			}//end of for(int i=0;i< SortedIndeciesOfFragments.length;i++)
		}//end of for(int h=0;h<SortedIndeciesOfFragments.size();h++)
			double elapsedTime =(double)(System.currentTimeMillis()-StarTime)/1000;
			System.out.println("--selection time---"+elapsedTime);
		}//end of if 
			///////////////////////////////////////////////////////
			
			//to get the reverse fragment
			//////////----------------------------------------------
			if (this.drawRevFrag)
			{
				/*float forG1 = (float)Math.abs(p4.x-p1.x)/(float)firstEnd;
				float forG2 = (float)Math.abs(p1.y-p2.y)/(float)secondEnd;
			for(int j=0;j< proFilesArr.size();j++)	{
			ProcessingFiles proFiles = (ProcessingFiles)proFilesArr.get(j);
			for(int i=0; i<proFiles.arrToDrawTheRevFragments.size();i++)
			{
				FragmentPosArrayList fragmentPos = proFiles.arrToDrawTheRevFragments.get(i);
				int[] arrToDraw = new int[4];
			
				int[] d =(int[])fragmentPos.get( this.firstGenomeNum);
				arrToDraw[0] = d[0];
				arrToDraw[1] = d[1];
				d =(int[])fragmentPos.get( this.secondGenomeNum);
				arrToDraw[2] = d[0];
				arrToDraw[3] = d[1];
				//[0]-->s1 , [1]-->e1,[2]-->s2  ,[3]-->e2
				int[] p = this.drawingPoints(arrToDraw,forG1,forG2);
				boolean rangeFlag = true;
				for(int jj =0; jj<parent.parent.num;jj++)
				{
					if(jj != this.firstGenomeNum && jj != this.secondGenomeNum)
					{
						int[] dfp =(int[])fragmentPos.get(jj);
						if( !(begindIndexarr[jj] <= dfp[0] &&  endIndexarr[jj] >= dfp[1]))
							rangeFlag=false;
					}//end ofif(j != this.firstGenomeNum && j != this.secondGenomeNum)
				}//end of for(int j =0; j<ProcessingFiles.num;j++)
				
				if(selectRect.contains(p[0],p[2]) && selectRect.contains(p[1],p[3])&& rangeFlag)
				{
					Fragment f = (Fragment)proFiles.arrOfRevFragmentFinal.get(i);
					
					String s = "#"+f.score;
					
//					 for first genome fragment postion
					for(int g=0;g<parent.parent.num;g++)
					{int[] posOfFragment = (int[])f.fragmentsPos.get(g);
						
					s += " ["+posOfFragment[0]+","+posOfFragment[1]+"]"+"  ";
					}
					
					//for this.secondGenomeNum fragment postion
					//posOfFragment = (int[])f.fragmentsPos.get(this.secondGenomeNum);
						
					//s += " ["+posOfFragment[0]+","+posOfFragment[1]+"]"+"  ";
					
					arrR.add(s);
					selectedRevFragmentsIndex.add(""+i+"\t"+j);
				}//end of if
			}//end of for
			}//end of for
			*/
			}//end of if
			//System.out.println("  "+offset);
			
			ArrayList arr = new ArrayList();
			for(int i = 0;i<arrF.size();i++)
			{
				arr.add(arrF.get(i));
			}
			offset = arrF.size();
			for(int i = 0;i<arrR.size();i++)
			{
				arr.add(arrR.get(i));
			}
			return arr;
		}

		//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	/*
	 * the binary searh function
	 * param> the array of the index
	 * param>the lower index 
	 * param>the length
	 * param>the index of the file object in the profiles array
	 * param>the value to make comparison"the min mum point in the selected rectangle"
	 */
	   int BinarySearch(int[] arr,int low,int high,MyFragmentPosArrayListToDraw arrOfPoints,int val)
	   {
		   
		int mid;
		while(low<=high){
			 mid = (low + high) / 2;
			 FragmentPosArrayList fragmentPos = arrOfPoints.get(arr[mid]);
			  int[] d =(int[])fragmentPos.get(0);
	         
	          if (val <d[0])
	                 high = mid-1;
	         else if (val>d[0])
	                 low = mid+1;
	         else
	                 return mid;
		}
		return low;
				
	}
		
		//-------------------------------------------------------------------------------
	 /*
	  * to export image
	  */
	public void exportImage(BufferedImage bb ,String s)
	{
		try {
            // Save as JPEG
          File  file = new File(s);
            ImageIO.write(bb , "jpg", file);
        } catch (IOException ex) {
        	JOptionPane.showConfirmDialog(null, ""+ex);
        }
	}
//**********************************************************
//  class PanelMouseListener to handle the mouse event     *
//**********************************************************
	class PanelMouseListener extends MouseInputAdapter 
	 {
	 	int xStart = -1;
	 	int yStart = -1;
        public void mousePressed(MouseEvent e) 
        {
            
            //System.out.println("   "+e.getX()+"   "+e.getY());
             int x = e.getX();
       		 int y = e.getY();
       		 selectRect.x =x;
       		 selectRect.y= y;
       		 xStart = x;
       		 yStart = y;
       		 selectRect.width= 0;
       		 selectRect.height= 0;
       		 selectFlag= true;// to make sorting in the first time
       		 if(sortFlag || SortedIndeciesOfFragments.size() != proFilesArr.size())
       		 {
       			 sortFlag=false;
       			for(int h = SortedIndeciesOfFragments.size() ;h< proFilesArr.size();h++)
       			{
       				ProcessingFiles proFiles= (ProcessingFiles)proFilesArr.get(h);
       				int[] SortedIndeciesOfFragmentsArr = new int[proFiles.arrToDrawTheFragments.size()];
       				for(int i=0;i<SortedIndeciesOfFragmentsArr.length;i++)
       				{
       					SortedIndeciesOfFragmentsArr[i]=i;
      				 }
       			
       			 proFiles.sort(SortedIndeciesOfFragmentsArr, 0, proFiles.arrToDrawTheFragments);
       			 SortedIndeciesOfFragments.add(SortedIndeciesOfFragmentsArr);
       		 }//end of for(int h = 0;h< proFilesArr.size();h++)
       		 }//end of if(sortFlag || SortedIndeciesOfFragments.size() == proFilesArr.size())
       		 
        }
                
        public void mouseClicked(MouseEvent e) 
        {
           
        	if(true) {
        		
        		centerForZooming.x = e.getX();
                centerForZooming.y = e.getY();
        		JPopupMenu popup = createPopupMenu(0);
                popup.show(e.getComponent(),
                           e.getX(), e.getY());
                
        	}
        	
        	
        }
        
        
        public void mouseDragged(MouseEvent e)
        {
            updateSize(e);
            
        }
        
        public void mouseMoved(MouseEvent e)
        {
         int x = e.getX();
        	int p = reverseTransformation(x);
           parent.stLabel.setText("   "+p+"   ");
        }

		public void mouseReleased(MouseEvent e) 
        {
            updateSize(e);
            //Array list contians the index of select rectangles
            if(selectRect.width > 1 && selectRect.height > 1)
            {
         
            	centerForZooming.x = e.getX();
                centerForZooming.y = e.getY();
        		JPopupMenu popup = createPopupMenu(1);
                popup.show(e.getComponent(),
                           e.getX(), e.getY());
               
            }
	//-------------------------------------------------------	
            
       		xStart=-1;
       		yStart=-1;
       		
        }
    
    	void updateSize(MouseEvent e) 
    	{
         int x = e.getX();
         int y = e.getY();
         
       	 int width= x - xStart  ;
       	 int height= y - yStart ;
       	 
       	 //Make the width and height positive, if necessary.
        if (width < 0) 
        {	
            width = 0 - width;
            selectRect.x = xStart - width + 1; 
            if (selectRect.x < 0) 
            {
                width += selectRect.x; 
                selectRect.x = 10;
            }
        }
        if (height < 0) 
        {
            height = 0 - height;
            selectRect.y = yStart - height + 1; 
            if (selectRect.y < 0) 
            {
                height += selectRect.y; 
                selectRect.y = 10;
            }
        }
        
        selectRect.width = width;
        selectRect.height = height;
       	 
       	 //System.out.println("   "+selectRect.x+"   "+selectRect.y+"   "+selectRect.width+"   "+selectRect.height+"   ");   
        repaint(selectRect.x+50,selectRect.y+50,selectRect.width+20,selectRect.height+20);
        repaint(selectRect.x-50,selectRect.y-50,selectRect.width+20,selectRect.height+20);
    	}
        
	}//end of inner class for mouse listener
	
	
	JPopupMenu createPopupMenu(int mode)
	{
		JPopupMenu popup = new JPopupMenu();

		JMenu zoom = new JMenu("Zoom");
		JMenuItem zoom1 = new JMenuItem("300%");
		JMenuItem zoom2 = new JMenuItem("200%");
		JMenuItem zoom3 = new JMenuItem("50%");
		
		JMenuItem unCrop = new JMenuItem("Uncrop");
		JMenuItem selectZoom = new JMenuItem("Zoom The Selection Area");
		JMenuItem cropZoom = new JMenuItem("Zoom The Selection Area and crop");
		JMenuItem select = new JMenuItem("Select");
		
		zoom1.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent e)
			{
				toZoom(3);	
			}
		});
		
		zoom2.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent e)
			{
				toZoom(2);
			}
		});
		
		zoom3.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent e)
			{
				toZoom(0.5);
			}
		});
		
		selectZoom.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent e)
			{
				
				
                double newZoomFactorX =(float)(scrollPane.getViewport().getVisibleRect().getWidth())/(float)selectRect.width;
			    toZoom(newZoomFactorX);
				
			}
		});
		
		select.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent e)
			{
				 if(selectFlag)
	                {
	            	ArrayList arrOfFound = getFragmentFromSelectRect(1);
	            
	            //---- the fragment frame where will the fragments will draw its sequences
	   //---------------------------------          
	             //FragmentFrame fragmentFrame=new FragmentFrame(arrOfFound.toArray(),parent);
	             // fragmentFrame.setLocationRelativeTo(parent); 
	          	 //  fragmentFrame.setVisible(true);
	          	   //---pass (by refrence)to the frame
	          	   //1)the arraylist of fragments
	          	   //2)the arraylist of rev. fragments
	          	   //3)the arraylist of the selected indecies of fragmnets 
	          	   //4)the arraylist of the selected indecies of rev. fragmnets
	          	   //5)the offset of the indecies"pass by value"
	          	   //6)the array of the sequences
	          	  // fragmentFrame.arrOfFragmentFinal =passTheFragmentListFromProFilesToDrawPanels(proFiles. arrOfFragmentFinal,firstGenomeNum,secondGenomeNum);
	          	   //fragmentFrame.arrOfRevFragmentFinal =passTheFragmentListFromProFilesToDrawPanels( proFiles.arrOfRevFragmentFinal,firstGenomeNum,secondGenomeNum);
	          	  
	          
	            }
				 
				selectRect.width= 0;
	       		selectRect.height= 0;
	       		selectRect.x =-1;
	       		selectRect.y= -1;
	       		selectFlag = false;
			}
		});
		cropZoom.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent e)
			{
				cropZoomFlag = true;
				max= (int)(     selectRect.getMaxX()*(   (float)theMaxLength/(float)axisPoint.x   )   ) ;
				min = (int)(     selectRect.x*(   (float)theMaxLength/(float)axisPoint.x   )   ) ;
				double newZoomFactorX =(float)(scrollPane.getViewport().getVisibleRect().getWidth())/(float)selectRect.width;
				toZoom(newZoomFactorX);
			}
		});
		unCrop.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent e)
			{
				cropZoomFlag = false;
			}
		});
		zoom.add(zoom1);
		zoom.add(zoom2);
		zoom.add(zoom3);
		popup.add(zoom);
		
		if(cropZoomFlag)
			popup.add(unCrop);
		if(mode == 0)
		{
			return popup;
		}
		else
		{
			popup.addSeparator();
			popup.add(selectZoom);
			popup.add(cropZoom);
			popup.addSeparator();
			popup.add(select);
			
			return popup;
		}
		
	}

	/**
	 * 
	 * @uml.property name="zoomFactorX"
	 */
	/*
	 * zoomMethod
	 * param>zoom factor in x
	 * param>zoom factor in y
	 * before make zooming the method check if the zoom will be more than the charater size or not
	 * and then make zooming on the axis and the size of the panel...because the points draw with rescpect to the new axis
	 */

	void toZoom(double newZoomFactorX) {
		int x = (int) selectRect.getX();
		double p = reverseTransformation(x);

		if ((((float) getSize().getWidth() * newZoomFactorX) / theMaxLength) <= charcterFontSize) {

			zoomFactorX = newZoomFactorX;

			axisPoint.move(
				(int) (axisPoint.x * zoomFactorX),
				(int) (axisPoint.y));

		} else {
			zoomFactorX = (float) (theMaxLength * charcterFontSize)
				/ (float) getSize().getWidth();
			JOptionPane.showMessageDialog(parent, "max  ZOOM-- "
				+ newZoomFactorX
				+ "   "
				+ "& max is assign which are  "
				+ zoomFactorX);
		}

		setPreferredSize(new Dimension((int) (axisPoint.x), (int) (getHeight())));
		setSize(new Dimension(
			(int) (axisPoint.x),
			(int) (zoomFactorY * getHeight())));
		int pp = (int) (p * ((float) axisPoint.x / (float) theMaxLength));
		scrollPane.getViewport().setViewPosition(
			new Point((int) pp, (int) selectRect.y));
		makeRuler();
		selectFlag = false;

	}

//	---------------------------------------------------------------
	class MsgBox extends JDialog implements ActionListener {
		 boolean id = false;
		 Button ok;
		 Button can;
		 public JTextField startText;
		 public JTextField endText;
		 public boolean flagOfVisibility = false;
		 public int[] begindIndexarr;
		 public int[] endIndexarr;
		 MsgBox(String msg, boolean okcan,int[] arrbegin,int[] endarr){
			 super(parent.parent.parent);
			 begindIndexarr = arrbegin;
			 endIndexarr = endarr;
		  this.setTitle("Message....");
		  this.setModal(true);
		  this.getContentPane().setLayout(new BorderLayout());
		  this.getContentPane(). add(new Label(msg),BorderLayout.NORTH);
		  addRangePanel();
		  addOKCancelPanel(okcan);
		  createFrame();
		  pack();
		  setVisible(true);
		  }

		 void addRangePanel( ) {
			  Panel p = new Panel();
			  p.setLayout(new GridLayout(6,1));
			  JLabel start = new JLabel(" Ranges (e.g., 1000-2000,3500-5600,..) in");
			  JLabel end = new JLabel(" Genomes: (e.g., 1,3,5,..)");
			  JLabel comment1 = new JLabel("Empty 'Ranges' field: adds no constraints w.r.t. the non-projects genomes");
			  JLabel comment2 = new JLabel(" Clicking 'Cancel' ignores all the ranges in the 'Ranges' field");
			  startText = new JTextField();
			  endText=new JTextField();
			  p.add(start);
			  p.add(startText);
			  p.add(end);
			  p.add(endText);
			  p.add(comment1);
			  p.add(comment2);
			  this.getContentPane().add(p,BorderLayout.CENTER);
			  }
		 
		 void addOKCancelPanel( boolean okcan ) {
		  Panel p = new Panel();
		  p.setLayout(new FlowLayout());
		  createOKButton( p );
		  if (okcan == true)
		     createCancelButton( p );
		  this.getContentPane().add(p,BorderLayout.SOUTH);
		  }

		 void createOKButton(Panel p) {
		  p.add(ok = new Button("OK"));
		  ok.addActionListener(this); 
		  }

		 void createCancelButton(Panel p) {
		  p.add(can = new Button("Cancel"));
		  can.addActionListener(this);
		  }

		 void createFrame() {
		  Dimension d = getToolkit().getScreenSize();
		  setLocation(d.width/3,d.height/3);
		  }

		 public void actionPerformed(ActionEvent ae){
		  if(ae.getSource() == ok) {
		    id = true;
		    setVisible(false);
		    
		    //----------------- to know the ranges of the other projections
		    ArrayList genomeIndex = new ArrayList();
		    ArrayList  ranges = new ArrayList();
		    boolean flag = false;
		try{
		
		//--- to take the ranges
		StringTokenizer st1 = new StringTokenizer(startText.getText(),",");
		for(int i = 0; i < st1.countTokens();i++)
		{
			StringTokenizer st2 = new StringTokenizer(startText.getText(),"-");
			int[] range2D = new int[2];
			range2D[0] = Integer.parseInt(st2.nextToken());
			range2D[1] = Integer.parseInt(st2.nextToken());
			ranges.add(range2D);
		}
		
		st1 = new StringTokenizer(endText.getText(),",");
		for(int i = 0; i < st1.countTokens();i++)
		{ 
			genomeIndex.add(st1.nextToken());
			int[] checkranges = (int[])ranges.get(i);
			
			if(checkranges[0]  >= 0 && checkranges[0] <= endIndexarr[Integer.parseInt((String)genomeIndex.get(i))-1]  &&
					checkranges[1]  >= 0 && checkranges[1] <= endIndexarr[Integer.parseInt((String)genomeIndex.get(i))-1] && checkranges[0] < checkranges[1])
			{
				flag = true;
			}
			else
			{
				throw(new Exception());
			}
		}
		for(int i = 0; i <genomeIndex.size()  ;i++)
		{ 
			int[] checkranges = (int[])ranges.get(i);
			if( flag  )
			{
				begindIndexarr[ (Integer.parseInt((String)genomeIndex.get(i)) -1 ) ] = checkranges[0];
				endIndexarr[ (Integer.parseInt((String)genomeIndex.get(i))-1) ] = checkranges[1];
				
			}
		}
		if(genomeIndex.size() == 0 && ranges.size() == 0)
		{
			JOptionPane.showMessageDialog(parent.parent, "Empty spaces ,it act as cancel","Information",JOptionPane.INFORMATION_MESSAGE);
		}
		}//end of try   // make parssing
		catch(Exception exx)
		{
			JOptionPane.showMessageDialog(parent.parent, "Non-correct format for Ranges/Geomes","Error",JOptionPane.ERROR_MESSAGE);
			setVisible(true);
		} 
	 }
		  else if(ae.getSource() == can) {
		    setVisible(false);
		    }
		  }
		}
	//*-*-*-*--*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
}//end of classes
