import java.awt.*;
import java.awt.font.*;
import java.awt.geom.*;

class Arrow
{
    static Font font = new Font("lucida sans demibold", Font.PLAIN, 1);
    static final int UP = 0 ;
    static final int LEFT = 1 ;
    static final int DOWN = 2 ;
    static final int RIGHT = 3 ;
 
    /**
     * (x,y) is the left end of the arrow
     */
    public static void drawHorizArrow(Graphics2D g2, Color color, int x, int y,
                                     int length, String id, int orientation)
    {
    	int arrsize = 2;
        Color origColor = g2.getColor();
        g2.setPaint(color);
        g2.draw(new Line2D.Double(x, y, x + length, y));
        if(orientation == LEFT)
        {
            g2.draw(new Line2D.Double(x, y, x + arrsize, y - arrsize));
            g2.draw(new Line2D.Double(x, y, x + arrsize, y + arrsize));
        }
        else
        {
            g2.draw(new Line2D.Double(x + length, y, x + length - arrsize, y - arrsize));
            g2.draw(new Line2D.Double(x + length, y, x + length - arrsize, y + arrsize));
        }
        Font origFont = g2.getFont();
        g2.setFont(font);
        FontRenderContext frc = g2.getFontRenderContext();
        float width = (float)font.getStringBounds(id, frc).getWidth();
        LineMetrics lm = font.getLineMetrics(id, frc);
        float sx = x + (length - width)/2;
        float sy = y - lm.getDescent();
        g2.drawString(id, sx, sy);
        g2.setPaint(origColor);
        g2.setFont(origFont);
    }
     
    /**
     * (x,y) is the top of the arrow
     */
    public static void drawVertArrow(Graphics2D g2, Color color, int x, int y,
                                     int length, String id, int orientation)
    {
        Color origColor = g2.getColor();
        g2.setPaint(color);
        g2.draw(new Line2D.Double(x, y, x, y + length));
        if(orientation == UP)
        {
            g2.draw(new Line2D.Double(x, y, x - 8, y + 8));
            g2.draw(new Line2D.Double(x, y, x + 8, y + 8));
        }
        else
        {
            g2.draw(new Line2D.Double(x, y + length, x - 8, y + length - 8));
            g2.draw(new Line2D.Double(x, y + length, x + 8, y + length - 8));
        }
        Font origFont = g2.getFont();
        g2.setFont(font);
        FontRenderContext frc = g2.getFontRenderContext();
        float width = (float)font.getStringBounds(id, frc).getWidth();
        LineMetrics lm = font.getLineMetrics(id, frc);
        float height = lm.getAscent();
        float sx = x - (width + 4);
        float sy = y + (length + height)/2;
        g2.drawString(id, sx, sy);
        g2.setPaint(origColor);
        g2.setFont(origFont);
    }
}
