/**
 * AnnotationForGenome
 * to read by it the annotaion files and then save the feuture holder in it as member variable...
 * 
 * so in the main class will have arraylist form this claa to reach to each object
 * 
 * 
 * @author Asem A. Othamn
 */

import java.awt.Color;
import java.io.*;
import java.util.*;

import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
 
import org.biojava.bio.*;
import org.biojava.bio.seq.*;
import org.biojava.bio.seq.io.*;
import org.biojava.bio.symbol.*;

public class AnnotationForGenome
{
	//the genome index
	int genomeIndex = -1;

	/**
	 * refrence to the main frame to show the dialog , it need parent
	 * 
	 * @uml.property name="parent"
	 * @uml.associationEnd multiplicity="(0 1)"
	 */
	VisChainerMain parent;

	/**
	 * 
	 * @uml.property name="fc"
	 * @uml.associationEnd multiplicity="(1 1)"
	 */
	// file chooser which will appear when open file
	JFileChooser fc = new JFileChooser();

	/**
	 * 
	 * @uml.property name="keysName"
	 * @uml.associationEnd multiplicity="(0 -1)" elementType="java.lang.String"
	 */
	//Array list to save the keys
	public ArrayList keysName = new ArrayList();

	/**
	 * 
	 * @uml.property name="colorForKeys"
	 * @uml.associationEnd multiplicity="(0 -1)" elementType="java.awt.Color"
	 */
	public ArrayList ColorForKeys = new ArrayList();

	/**
	 * 
	 * @uml.property name="annotationInfo"
	 * @uml.associationEnd multiplicity="(0 -1)" elementType="I"
	 */
	//Array list to save the key inde in the keysName array list and the start and end location
	public ArrayList annotationInfo = new ArrayList();

    
	/**
	 * the constractor
	 * @param p-> the main frame for each session
	 * @param genomeindex-> the genome index which this annotation for it
	 */
	public AnnotationForGenome(VisChainerMain p , int genomeindex) 
	{
		
	}
	/**
	 * readAnnotation methd
	 * this method will read annotaion from embl file
	 * 
	 */
	void readAnnotation()
	{
		fc.setDialogTitle("Open Embl File");
		int returnVal = fc.showOpenDialog(parent);
		if (returnVal == JFileChooser.APPROVE_OPTION) 
		{  
			 BufferedReader br = null;
		      SequenceIterator sequences;

		    try {
		 
		      //create a buffered reader to read the sequence file specified by args[0]
		      br = new BufferedReader(new FileReader(fc.getSelectedFile()));
		      //read the EMBL File
		      sequences = SeqIOTools.readEmbl(br);
		      while(sequences.hasNext())
		      {
		    		    Sequence seq = sequences.nextSequence();
		    		    //do stuff with the sequence
		    		    
		    		    Annotation seqAn = seq.getAnnotation();
		    		    for (Iterator i = seqAn.keys().iterator(); i.hasNext(); ) 
		    		    {
		    			Object key = i.next();
		    			Object value = seqAn.getProperty(key);
		    			System.out.println(key.toString() + ": " + value.toString());
		    			System.out.println("\n");
		    		    }//end of for (Iterator i = seqAn.keys().iterator(); i.hasNext(); ) 
		    		    FeatureFilter ff = new FeatureFilter.ContainedByLocation(LocationTools.makeLocation(0, seq.length()));
		    		    FeatureHolder fh = seq.filter(ff);
		    		    saveAnnotation(fh);
		      }//end the while
		    }
		    catch (Exception ex)
		    {	           
		    }
		}
	   else
	   {
	   	JOptionPane.showMessageDialog(parent,"You don't select any files");
	   }
	}//end of method
	
	 
	// 
	/**
	 *will save the keys of the annotaion in array list and the fetures in the sequence and its location will save in another arraylist which have "key'int', start and end locations" 
	 */
	void saveAnnotation(FeatureHolder fh)
	{
		for (Iterator i = fh.features(); i.hasNext(); ) 
		{
	        Feature f = (Feature) i.next();	
		    int indexOfTheKey = keysName.size();//before add the element so its the size if the type exist so it take its index
		    boolean keyExistenceFlag = false;
		   
		    for(int j = 0 ; j< keysName.size() ; j++)
		    {
		    	if(f.getType().compareTo((String)keysName.get(j)) == 0 )
		    	{
		    		indexOfTheKey = j;
		    		keyExistenceFlag = true;
		    	}
		    }
		    if(!keyExistenceFlag)
		    {
		    	indexOfTheKey = keysName.size();//before add the element so its the size
		    	keysName.add(f.getType());
		    	ColorForKeys.add(Color.RED);
		    }
		    int[] annoArr = new int[3];
		    annoArr[0] = indexOfTheKey;
		    System.out.println("key  "+annoArr[0] +f.getType());
		    annoArr[1] = f.getLocation().getMin();
		    System.out.println("  start  "+annoArr[1]);
		    annoArr[2] = f.getLocation().getMax();
		    System.out.println("  end  "+annoArr[2]);
		   //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////-----f.getLocation().toString();
		    annotationInfo.add(annoArr);
		  // saveAnnotation(fh);
		}//end of for
	}//end of method
}//end of class
